/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.view.AnalysisResultsContent;
import com.android.tools.idea.profiling.view.CaptureEditorLightToolWindowManager;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.idea.profiling.view.EmptyManager;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisResultsManager
extends CaptureEditorLightToolWindowManager {
    private final AnalysisResultsContent myContent;

    @NotNull
    public static AnalysisResultsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getInstance"));
        }
        AnalysisResultsManager analysisResultsManager = (AnalysisResultsManager)((Object)project.getComponent(AnalysisResultsManager.class));
        if (analysisResultsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getInstance"));
        }
        return analysisResultsManager;
    }

    protected AnalysisResultsManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "<init>"));
        }
        super(project, fileEditorManager);
        this.myContent = new AnalysisResultsContent();
        Disposer.register((Disposable)this, () -> this.myContent.dispose());
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myContent.update(designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            DesignerEditorPanelFacade activeDesigner = this.getActiveDesigner();
            if (activeDesigner != null && activeDesigner instanceof CapturePanel && activeDesigner.getClientProperty((Object)this.getComponentName()) == null) {
                activeDesigner.putClientProperty((Object)this.getComponentName(), (Object)this.myContent);
            }
            this.myToolWindow.setIcon(this.getIcon());
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    @NotNull
    protected Icon getIcon() {
        Icon icon = this.myContent.getIcon() == null ? AllIcons.Toolwindows.ToolWindowFind : this.myContent.getIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getIcon"));
        }
        return icon;
    }

    @Override
    @NotNull
    protected String getManagerName() {
        String string = AndroidBundle.message("android.captures.analysis.results.manager.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getManagerName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getToolWindowTitleBarText() {
        String string = AndroidBundle.message("android.captures.analysis.results.manager.titlebar.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getToolWindowTitleBarText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected AnAction[] createActions() {
        AnAction[] anActionArray = new AnAction[]{new ToggleAction(AndroidBundle.message("android.captures.analysis.results.manager.run.name", new Object[0]), AndroidBundle.message("android.captures.analysis.results.manager.run.description", new Object[0]), AllIcons.Toolwindows.ToolWindowRun){

            public boolean isSelected(AnActionEvent e) {
                AnalysisResultsContent analysisResultsContent = AnalysisResultsManager.this.getContentFromDesigner();
                return analysisResultsContent != null && !analysisResultsContent.canRunAnalysis();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisResultsContent analysisResultsContent;
                if (state && (analysisResultsContent = AnalysisResultsManager.this.getContentFromDesigner()) != null && analysisResultsContent.canRunAnalysis()) {
                    analysisResultsContent.performAnalysis();
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/profiling/view/AnalysisResultsManager$1", "update"));
                }
                super.update(e);
                Presentation presentation = e.getPresentation();
                if (this.isSelected(e)) {
                    presentation.setText(AndroidBundle.message("android.captures.analysis.results.manager.run.disabled.name", new Object[0]));
                    presentation.setDescription(AndroidBundle.message("android.captures.analysis.results.manager.run.disabled.description", new Object[0]));
                    presentation.setIcon(AllIcons.Process.DisabledRun);
                } else {
                    presentation.setText(AndroidBundle.message("android.captures.analysis.results.manager.run.enabled.name", new Object[0]));
                    presentation.setDescription(AndroidBundle.message("android.captures.analysis.results.manager.run.enabled.description", new Object[0]));
                    presentation.setIcon(AllIcons.Toolwindows.ToolWindowRun);
                }
            }
        }};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "createActions"));
        }
        return anActionArray;
    }

    @Override
    @NotNull
    protected JComponent getContent() {
        JComponent jComponent = this.myContent.getMainPanel();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getContent"));
        }
        return jComponent;
    }

    @Override
    @Nullable
    protected JComponent getFocusedComponent() {
        return this.myContent.getFocusComponent();
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.RIGHT;
    }

    @NotNull
    public String getComponentName() {
        if ("CaptureAnalysis" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "getComponentName"));
        }
        return "CaptureAnalysis";
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "createContent"));
        }
        AnalysisResultsContent content = new AnalysisResultsContent();
        content.update(designer);
        Icon icon = content.getIcon();
        if (icon == null) {
            icon = this.getIcon();
        }
        JComponent focus = content.getFocusComponent();
        LightToolWindow lightToolWindow = this.createContent(designer, content, this.getToolWindowTitleBarText(), icon, content.getMainPanel(), focus == null ? content.getMainPanel() : focus, 320, this.createActions());
        try {
            LightToolWindow.class.getDeclaredMethod("minimize", new Class[0]).invoke((Object)lightToolWindow, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lightToolWindow;
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/android/tools/idea/profiling/view/AnalysisResultsManager", "createToggleAction"));
        }
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return EmptyManager.getInstance(this.myProject);
            }
        };
    }

    @Nullable
    private AnalysisResultsContent getContentFromDesigner() {
        DesignerEditorPanelFacade activeDesigner = this.getActiveDesigner();
        if (activeDesigner != null && activeDesigner instanceof CapturePanel) {
            Object property = activeDesigner.getClientProperty((Object)this.getComponentName());
            if (property instanceof LightToolWindow) {
                LightToolWindow lightToolWindow = (LightToolWindow)property;
                Object content = lightToolWindow.getContent();
                if (content instanceof AnalysisResultsContent) {
                    return (AnalysisResultsContent)content;
                }
            } else if (property instanceof AnalysisResultsContent) {
                return (AnalysisResultsContent)property;
            }
        }
        return null;
    }
}

