/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.res.ResourceHelper");
    public static final String STATE_NAME_PREFIX = "state_";
    public static final String ALPHA_FLOATING_ERROR_FORMAT = "The alpha attribute in %1$s/%2$s does not resolve to a floating point number";
    public static final String DIMENSION_ERROR_FORMAT = "The specified dimension %1$s does not have a unit";
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final String[] NO_PREFIX_PACKAGES = new String[]{"android.widget.", "android.view.", "android.webkit."};
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f)};

    public static boolean isProjectStyle(@NotNull String styleResourceUrl) {
        if (styleResourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceUrl", "com/android/tools/idea/res/ResourceHelper", "isProjectStyle"));
        }
        return !styleResourceUrl.startsWith("@android:style/");
    }

    @NotNull
    public static String styleToTheme(@NotNull String style) {
        int index;
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/res/ResourceHelper", "styleToTheme"));
        }
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        } else if (style.startsWith("@") && (index = style.indexOf(47)) != -1) {
            style = style.substring(index + 1);
        }
        String string = style;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "styleToTheme"));
        }
        return string;
    }

    public static boolean isValueBasedResourceType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/ResourceHelper", "isValueBasedResourceType"));
        }
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType != ResourceFolderType.VALUES) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getResourceName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceHelper", "getResourceName"));
        }
        String string = LintUtils.getBaseName((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceHelper", "getResourceName"));
        }
        String string = LintUtils.getBaseName((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static String getResourceUrl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceHelper", "getResourceUrl"));
        }
        ResourceFolderType type = ResourceFolderType.getFolderType((String)file.getParent().getName());
        assert (type != null && type != ResourceFolderType.VALUES);
        String string = "@" + type.getName() + '/' + ResourceHelper.getResourceName(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "getResourceUrl"));
        }
        return string;
    }

    public static boolean isFileBasedResourceType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/ResourceHelper", "isFileBasedResourceType"));
        }
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    @Nullable
    public static ResourceFolderType getFolderType(@Nullable PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (ResourceFolderType)ApplicationManager.getApplication().runReadAction(() -> ResourceHelper.getFolderType(file));
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderType(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return ResourceFolderType.getFolderType((String)parent.getName());
            }
        }
        return null;
    }

    @Nullable
    public static ResourceFolderType getFolderType(@Nullable VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return ResourceFolderType.getFolderType((String)parent.getName());
        }
        return null;
    }

    @Nullable
    public static ResourceFolderType getFolderType(@NotNull ResourceFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceHelper", "getFolderType"));
        }
        File parent = file.getFile().getParentFile();
        if (parent != null) {
            return ResourceFolderType.getFolderType((String)parent.getName());
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration getFolderConfiguration(@Nullable PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (FolderConfiguration)ApplicationManager.getApplication().runReadAction(() -> ResourceHelper.getFolderConfiguration(file));
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderConfiguration(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return FolderConfiguration.getConfigForFolder((String)parent.getName());
            }
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration getFolderConfiguration(@Nullable VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return FolderConfiguration.getConfigForFolder((String)parent.getName());
        }
        return null;
    }

    public static List<VirtualFile> getResourceVariations(@Nullable VirtualFile file, boolean includeSelf) {
        VirtualFile resFolder;
        if (file == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> variations = new ArrayList<VirtualFile>();
        String name = file.getName();
        VirtualFile parent = file.getParent();
        if (parent != null && (resFolder = parent.getParent()) != null) {
            String parentName = parent.getName();
            String prefix = parentName;
            int qualifiers = prefix.indexOf(45);
            if (qualifiers != -1) {
                parentName = prefix.substring(0, qualifiers);
                prefix = prefix.substring(0, qualifiers + 1);
            } else {
                prefix = prefix + '-';
            }
            for (VirtualFile resource : resFolder.getChildren()) {
                VirtualFile variation;
                String n = resource.getName();
                if (!n.startsWith(prefix) && !n.equals(parentName) || !resource.isDirectory() || (variation = resource.findChild(name)) == null || !includeSelf && file.equals(variation)) continue;
                variations.add(variation);
            }
        }
        return variations;
    }

    public static boolean isViewPackageNeeded(@NotNull String qualifiedName, int apiLevel) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/res/ResourceHelper", "isViewPackageNeeded"));
        }
        for (String noPrefixPackage : NO_PREFIX_PACKAGES) {
            if (!ResourceHelper.isDirectlyInPackage(qualifiedName, noPrefixPackage)) continue;
            return false;
        }
        if (apiLevel >= 20) {
            return !ResourceHelper.isDirectlyInPackage(qualifiedName, "android.app.");
        }
        return true;
    }

    public static boolean isClassPackageNeeded(@NotNull String qualifiedName, @NotNull PsiClass baseClass, int apiLevel) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/res/ResourceHelper", "isClassPackageNeeded"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/android/tools/idea/res/ResourceHelper", "isClassPackageNeeded"));
        }
        PsiClass viewClass = JavaPsiFacade.getInstance((Project)baseClass.getProject()).findClass("android.view.View", GlobalSearchScope.allScope((Project)baseClass.getProject()));
        if (viewClass != null && baseClass.isInheritor(viewClass, true)) {
            return ResourceHelper.isViewPackageNeeded(qualifiedName, apiLevel);
        }
        if ("android.preference.Preference".equals(baseClass.getQualifiedName())) {
            return !ResourceHelper.isDirectlyInPackage(qualifiedName, "android.preference.");
        }
        return !qualifiedName.startsWith("android.");
    }

    public static boolean isDirectlyInPackage(@NotNull String qualifiedName, @NotNull String packagePrefix) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/res/ResourceHelper", "isDirectlyInPackage"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/android/tools/idea/res/ResourceHelper", "isDirectlyInPackage"));
        }
        return qualifiedName.startsWith(packagePrefix) && qualifiedName.indexOf(46, packagePrefix.length() + 1) == -1;
    }

    @Nullable
    public static Color resolveColor(@NotNull RenderResources resources, @Nullable ResourceValue colorValue, @NotNull Project project) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveColor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveColor"));
        }
        return ResourceHelper.resolveColor(resources, colorValue, project, 0);
    }

    @Nullable
    private static Color resolveColor(@NotNull RenderResources resources, @Nullable ResourceValue colorValue, @NotNull Project project, int depth) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveColor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveColor"));
        }
        if (depth >= 50) {
            LOG.warn("too deep " + colorValue);
            return null;
        }
        if (colorValue != null) {
            colorValue = resources.resolveResValue(colorValue);
        }
        if (colorValue == null) {
            return null;
        }
        StateList stateList = ResourceHelper.resolveStateList(resources, colorValue, project);
        if (stateList != null) {
            List<StateListState> states = stateList.getStates();
            if (states.isEmpty()) {
                return null;
            }
            StateListState state = states.get(states.size() - 1);
            Color stateColor = ResourceHelper.parseColor(state.getValue());
            if (stateColor == null) {
                stateColor = ResourceHelper.resolveColor(resources, resources.findResValue(state.getValue(), false), project, depth + 1);
            }
            if (stateColor == null) {
                return null;
            }
            try {
                return ResourceHelper.makeColorWithAlpha(resources, stateColor, state.getAlpha());
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("The alpha attribute in %s/%s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                return stateColor;
            }
        }
        return ResourceHelper.parseColor(colorValue.getValue());
    }

    @NotNull
    public static List<Color> resolveMultipleColors(@NotNull RenderResources resources, @Nullable ResourceValue value, @NotNull Project project) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
        }
        List<Color> list = ResourceHelper.resolveMultipleColors(resources, value, project, 0);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
        }
        return list;
    }

    @NotNull
    private static List<Color> resolveMultipleColors(@NotNull RenderResources resources, @Nullable ResourceValue value, @NotNull Project project, int depth) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
        }
        if (depth >= 50) {
            LOG.warn("too deep " + value);
            List<Color> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
            }
            return list;
        }
        if (value != null) {
            value = resources.resolveResValue(value);
        }
        if (value == null) {
            List<Color> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
            }
            return list;
        }
        ArrayList<Color> result = new ArrayList<Color>();
        StateList stateList = ResourceHelper.resolveStateList(resources, value, project);
        if (stateList != null) {
            for (StateListState state : stateList.getStates()) {
                Color color;
                ResourceValue resolvedStateResource = resources.findResValue(state.getValue(), false);
                ImmutableList stateColors = resolvedStateResource != null ? ResourceHelper.resolveMultipleColors(resources, resolvedStateResource, project, depth + 1) : ((color = ResourceHelper.parseColor(state.getValue())) == null ? Collections.emptyList() : ImmutableList.of((Object)color));
                for (Color color2 : stateColors) {
                    try {
                        result.add(ResourceHelper.makeColorWithAlpha(resources, color2, state.getAlpha()));
                    }
                    catch (NumberFormatException e) {
                        result.add(color2);
                        LOG.warn(String.format(ALPHA_FLOATING_ERROR_FORMAT, stateList.getDirName(), stateList.getFileName()));
                    }
                }
            }
        } else {
            Color color = ResourceHelper.parseColor(value.getValue());
            if (color != null) {
                result.add(color);
            }
        }
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveMultipleColors"));
        }
        return arrayList;
    }

    @NotNull
    public static String resolveStringValue(@NotNull RenderResources resources, @NotNull String value) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveStringValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/res/ResourceHelper", "resolveStringValue"));
        }
        ResourceValue resValue = resources.findResValue(value, false);
        if (resValue == null) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveStringValue"));
            }
            return string;
        }
        ResourceValue finalValue = resources.resolveResValue(resValue);
        if (finalValue == null || finalValue.getValue() == null) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveStringValue"));
            }
            return string;
        }
        String string = finalValue.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "resolveStringValue"));
        }
        return string;
    }

    public static boolean parseFloatAttribute(@NotNull String value, TypedValue outValue, boolean requireUnit) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/res/ResourceHelper", "parseFloatAttribute"));
        }
        int len = (value = value.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = value.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if ((buf[0] < '0' || buf[0] > '9') && buf[0] != '.' && buf[0] != '-' && buf[0] != '+') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).length() == 0 && outValue != null) {
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    ResourceHelper.applyUnit(sUnitNames[1], outValue, sFloatOut);
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    LOG.warn(String.format(DIMENSION_ERROR_FORMAT, value));
                }
                return true;
            }
        }
        return false;
    }

    private static void computeTypedValue(TypedValue outValue, float value, float scale) {
        int shift;
        int radix;
        long bits;
        boolean neg;
        boolean bl = neg = (value *= scale) < 0.0f;
        if (neg) {
            value = -value;
        }
        if (((bits = (long)(value * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((bits & Integer.MIN_VALUE) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(bits >> shift & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        outValue.data |= radix << 4 | mantissa << 8;
    }

    private static boolean parseUnit(String str, TypedValue outValue, float[] outScale) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            ResourceHelper.applyUnit(unit, outValue, outScale);
            return true;
        }
        return false;
    }

    private static void applyUnit(UnitEntry unit, TypedValue outValue, float[] outScale) {
        outValue.type = unit.type;
        outValue.data = unit.unit << 0;
        outScale[0] = unit.scale;
    }

    @NotNull
    public static Color makeColorWithAlpha(@NotNull RenderResources resources, @NotNull Color color, @Nullable String alphaValue) throws NumberFormatException {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "makeColorWithAlpha"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/res/ResourceHelper", "makeColorWithAlpha"));
        }
        float alpha = 1.0f;
        if (alphaValue != null) {
            alpha = Float.parseFloat(ResourceHelper.resolveStringValue(resources, alphaValue));
        }
        int combinedAlpha = (int)((float)color.getAlpha() * alpha);
        Color color2 = ColorUtil.toAlpha((Color)color, (int)ResourceHelper.clamp(combinedAlpha, 0, 255));
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "makeColorWithAlpha"));
        }
        return color2;
    }

    @Nullable
    public static StateList resolveStateList(@NotNull RenderResources renderResources, @NotNull ResourceValue value, @NotNull Project project) {
        if (renderResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderResources", "com/android/tools/idea/res/ResourceHelper", "resolveStateList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/res/ResourceHelper", "resolveStateList"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveStateList"));
        }
        return ResourceHelper.resolveStateList(renderResources, value, project, 0);
    }

    @Nullable
    private static StateList resolveStateList(@NotNull RenderResources renderResources, @NotNull ResourceValue resourceValue, @NotNull Project project, int depth) {
        if (renderResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderResources", "com/android/tools/idea/res/ResourceHelper", "resolveStateList"));
        }
        if (resourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceValue", "com/android/tools/idea/res/ResourceHelper", "resolveStateList"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveStateList"));
        }
        if (depth >= 50) {
            LOG.warn("too deep " + resourceValue);
            return null;
        }
        String value = resourceValue.getValue();
        if (value == null) {
            return null;
        }
        if (value.startsWith("@")) {
            ResourceValue resValue = renderResources.findResValue(value, resourceValue.isFramework());
            if (resValue != null) {
                return ResourceHelper.resolveStateList(renderResources, resValue, project, depth + 1);
            }
        } else {
            XmlTag rootTag;
            PsiFile psiFile;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(value);
            if (virtualFile != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(project, virtualFile)) instanceof XmlFile && (rootTag = ((XmlFile)psiFile).getRootTag()) != null && "selector".equals(rootTag.getName())) {
                StateList stateList = new StateList(psiFile.getName(), psiFile.getContainingDirectory().getName());
                for (XmlTag subTag : rootTag.findSubTags("item")) {
                    StateListState stateListState = ResourceHelper.createStateListState(subTag, resourceValue.isFramework());
                    if (stateListState == null) {
                        return null;
                    }
                    stateList.addState(stateListState);
                }
                return stateList;
            }
        }
        return null;
    }

    @Nullable
    private static StateListState createStateListState(XmlTag tag, boolean isFramework) {
        XmlAttribute[] attributes;
        String stateValue = null;
        String alphaValue = null;
        HashMap<String, Boolean> stateAttributes = new HashMap<String, Boolean>();
        for (XmlAttribute attr : attributes = tag.getAttributes()) {
            ResourceUrl url;
            String name = attr.getLocalName();
            String value = attr.getValue();
            if (value == null) continue;
            if ("color".equals(name) || "drawable".equals(name)) {
                url = ResourceUrl.parse((String)value, (boolean)isFramework);
                stateValue = url != null ? url.toString() : value;
                continue;
            }
            if ("alpha".equals(name)) {
                url = ResourceUrl.parse((String)value, (boolean)isFramework);
                alphaValue = url != null ? url.toString() : value;
                continue;
            }
            if (!name.startsWith(STATE_NAME_PREFIX)) continue;
            stateAttributes.put(name, Boolean.valueOf(value));
        }
        if (stateValue == null) {
            return null;
        }
        return new StateListState(stateValue, stateAttributes, alphaValue);
    }

    @Nullable
    public static Color parseColor(@Nullable String s) {
        if (StringUtil.isEmpty((String)(s = StringUtil.trim((String)s)))) {
            return null;
        }
        if (s.charAt(0) == '#') {
            long longColor;
            try {
                longColor = Long.parseLong(s.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (s.length() == 4 || s.length() == 5) {
                long a = s.length() == 4 ? 255L : ResourceHelper.extend((longColor & 0xF000L) >> 12);
                long r = ResourceHelper.extend((longColor & 0xF00L) >> 8);
                long g = ResourceHelper.extend((longColor & 0xF0L) >> 4);
                long b = ResourceHelper.extend(longColor & 0xFL);
                longColor = a << 24 | r << 16 | g << 8 | b;
                return new Color((int)longColor, true);
            }
            if (s.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (s.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    @NotNull
    public static String colorToString(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/res/ResourceHelper", "colorToString"));
        }
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            String string = String.format("#%08x", longColor |= (long)color.getAlpha() << 24);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "colorToString"));
            }
            return string;
        }
        String string = String.format("#%06x", longColor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "colorToString"));
        }
        return string;
    }

    private static long extend(long nibble) {
        return nibble | nibble << 4;
    }

    @Nullable
    public static File resolveDrawable(@NotNull RenderResources resources, @Nullable ResourceValue drawable, @NotNull Project project) {
        List<StateListState> states;
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveDrawable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceHelper", "resolveDrawable"));
        }
        if (drawable != null) {
            drawable = resources.resolveResValue(drawable);
        }
        if (drawable == null) {
            return null;
        }
        String result = drawable.getValue();
        StateList stateList = ResourceHelper.resolveStateList(resources, drawable, project);
        if (stateList != null && !(states = stateList.getStates()).isEmpty()) {
            StateListState state = states.get(states.size() - 1);
            result = state.getValue();
        }
        if (result == null) {
            return null;
        }
        File file = new File(result);
        return file.isFile() ? file : null;
    }

    @Nullable
    public static File resolveLayout(@NotNull RenderResources resources, @Nullable ResourceValue layout) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/res/ResourceHelper", "resolveLayout"));
        }
        if (layout != null) {
            layout = resources.resolveResValue(layout);
        }
        if (layout == null) {
            return null;
        }
        String value = layout.getValue();
        for (int depth = 0; value != null && depth < 50; ++depth) {
            if (DataBindingUtil.isBindingExpression(value) && (value = DataBindingUtil.getBindingExprDefault(value)) == null) {
                return null;
            }
            if (value.startsWith("@")) {
                boolean isFramework = layout.isFramework();
                if ((layout = resources.findResValue(value, isFramework)) == null) break;
            } else {
                File file = new File(value);
                if (file.exists()) {
                    return file;
                }
                return null;
            }
            value = layout.getValue();
        }
        return null;
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public static String prependResourcePrefix(@Nullable Module module, @Nullable String name, @Nullable ResourceFolderType folderType) {
        String resourcePrefix;
        AndroidModuleModel androidModel;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidModuleModel.get(facet)) != null && (resourcePrefix = LintUtils.computeResourcePrefix((AndroidProject)androidModel.getAndroidProject())) != null) {
            if (name != null) {
                return name.startsWith(resourcePrefix) ? name : LintUtils.computeResourceName((String)resourcePrefix, (String)name, (ResourceFolderType)folderType);
            }
            return resourcePrefix;
        }
        return name;
    }

    public static int clamp(int i, int min, int max) {
        return Math.max(min, Math.min(i, max));
    }

    @NotNull
    public static List<String> getCompletionFromTypes(@NotNull AndroidFacet facet, @NotNull EnumSet<ResourceType> completionTypes) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ResourceHelper", "getCompletionFromTypes"));
        }
        if (completionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionTypes", "com/android/tools/idea/res/ResourceHelper", "getCompletionFromTypes"));
        }
        List<String> list = ResourceHelper.getCompletionFromTypes(facet, completionTypes, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "getCompletionFromTypes"));
        }
        return list;
    }

    @NotNull
    public static List<String> getCompletionFromTypes(@NotNull AndroidFacet facet, @NotNull EnumSet<ResourceType> completionTypes, boolean sort) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ResourceHelper", "getCompletionFromTypes"));
        }
        if (completionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionTypes", "com/android/tools/idea/res/ResourceHelper", "getCompletionFromTypes"));
        }
        EnumSet types = Sets.newEnumSet(completionTypes, ResourceType.class);
        if (types.contains(ResourceType.MIPMAP)) {
            types.add(ResourceType.DRAWABLE);
        } else if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.MIPMAP);
        }
        boolean completionTypesContainsColor = types.contains(ResourceType.COLOR);
        if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.COLOR);
        }
        AppResourceRepository repository = AppResourceRepository.getAppResources(facet, true);
        ResourceVisibilityLookup lookup = repository.getResourceVisibility(facet);
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet.getModule());
        FrameworkResources frameworkResources = null;
        if (androidPlatform != null) {
            AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget());
            try {
                frameworkResources = targetData.getFrameworkResources(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList resources = Lists.newArrayListWithCapacity((int)500);
        for (ResourceType type : types) {
            boolean includeFileResources;
            boolean bl = includeFileResources = type != ResourceType.COLOR || completionTypesContainsColor;
            if (frameworkResources != null) {
                ResourceHelper.addFrameworkItems(resources, type, includeFileResources, frameworkResources);
            }
            ResourceHelper.addProjectItems(resources, type, includeFileResources, repository, lookup);
        }
        if (sort) {
            Collections.sort(resources, ResourceHelper::compareResourceReferences);
        }
        ArrayList arrayList = resources;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper", "getCompletionFromTypes"));
        }
        return arrayList;
    }

    public static int compareResourceReferences(String resource1, String resource2) {
        int framework2;
        int framework1 = resource1.startsWith("@android:") ? 1 : 0;
        int delta = framework1 - (framework2 = resource2.startsWith("@android:") ? 1 : 0);
        if (delta != 0) {
            return delta;
        }
        return resource1.compareToIgnoreCase(resource2);
    }

    private static void addFrameworkItems(@NotNull List<String> destination, @NotNull ResourceType type, boolean includeFileResources, @NotNull FrameworkResources frameworkResources) {
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/res/ResourceHelper", "addFrameworkItems"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/ResourceHelper", "addFrameworkItems"));
        }
        if (frameworkResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkResources", "com/android/tools/idea/res/ResourceHelper", "addFrameworkItems"));
        }
        List items = frameworkResources.getResourceItemsOfType(type);
        for (ResourceItem item : items) {
            List sourceFileList;
            if (!includeFileResources && !(sourceFileList = item.getSourceFileList()).isEmpty() && !((com.android.ide.common.resources.ResourceFile)sourceFileList.get(0)).getFolder().getFolder().getName().startsWith("values")) continue;
            destination.add("@android:" + type.getName() + '/' + item.getName());
        }
    }

    private static void addProjectItems(@NotNull List<String> destination, @NotNull ResourceType type, boolean includeFileResources, @NotNull AppResourceRepository repository, @Nullable ResourceVisibilityLookup lookup) {
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/res/ResourceHelper", "addProjectItems"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/ResourceHelper", "addProjectItems"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/res/ResourceHelper", "addProjectItems"));
        }
        for (String resourceName : repository.getItemsOfType(type)) {
            List items;
            if (lookup != null && lookup.isPrivate(type, resourceName) || (items = repository.getResourceItem(type, resourceName)) == null || !includeFileResources && ((com.android.ide.common.res2.ResourceItem)items.get(0)).getSourceType() != DataFile.FileType.XML_VALUES) continue;
            destination.add("@" + type.getName() + '/' + resourceName);
        }
    }

    public static String getTextContent(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/res/ResourceHelper", "getTextContent"));
        }
        XmlTag[] subTags = tag.getSubTags();
        XmlText[] textElements = tag.getValue().getTextElements();
        if (subTags.length == 0) {
            if (textElements.length == 1) {
                return ResourceHelper.getXmlTextValue(textElements[0]);
            }
            if (textElements.length == 0) {
                return "";
            }
        }
        StringBuilder sb = new StringBuilder(40);
        ResourceHelper.appendText(sb, tag);
        return sb.toString();
    }

    private static String getXmlTextValue(XmlText element) {
        PsiElement current = element.getFirstChild();
        if (current != null) {
            PsiElement[] children;
            if (current.getNextSibling() != null) {
                StringBuilder sb = new StringBuilder();
                while (current != null) {
                    IElementType type = current.getNode().getElementType();
                    if (type == XmlElementType.XML_CDATA) {
                        PsiElement[] children2 = current.getChildren();
                        if (children2.length == 3) {
                            assert (children2[1].getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS);
                            sb.append(children2[1].getText());
                        }
                    } else {
                        sb.append(current.getText());
                    }
                    current = current.getNextSibling();
                }
                return sb.toString();
            }
            if (current.getNode().getElementType() == XmlElementType.XML_CDATA && (children = current.getChildren()).length == 3) {
                assert (children[1].getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS);
                return children[1].getText();
            }
        }
        return element.getText();
    }

    private static void appendText(@NotNull StringBuilder sb, @NotNull XmlTag tag) {
        PsiElement[] children;
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/android/tools/idea/res/ResourceHelper", "appendText"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/res/ResourceHelper", "appendText"));
        }
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof XmlText) {
                XmlText text = (XmlText)child;
                sb.append(ResourceHelper.getXmlTextValue(text));
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTag childTag = (XmlTag)child;
            if ("g".equals(childTag.getLocalName()) && childTag.getNamespace().startsWith("urn:oasis:names:tc:xliff:document:")) {
                String example = childTag.getAttributeValue("example");
                if (example != null) {
                    sb.append('(').append(example).append(')');
                    continue;
                }
                String id = childTag.getAttributeValue("id");
                if (id != null) {
                    sb.append('$').append('{').append(id).append('}');
                    continue;
                }
            }
            ResourceHelper.appendText(sb, childTag);
        }
    }

    public static class StateListState {
        public static final String STATE_ENABLED = "state_enabled";
        private String myValue;
        private String myAlpha;
        private final Map<String, Boolean> myAttributes;

        public StateListState(@NotNull String value, @NotNull Map<String, Boolean> attributes, @Nullable String alpha) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/res/ResourceHelper$StateListState", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/res/ResourceHelper$StateListState", "<init>"));
            }
            this.myValue = value;
            this.myAttributes = attributes;
            this.myAlpha = alpha;
        }

        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/res/ResourceHelper$StateListState", "setValue"));
            }
            this.myValue = value;
        }

        public void setAlpha(@Nullable String alpha) {
            this.myAlpha = alpha;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateListState", "getValue"));
            }
            return string;
        }

        @Nullable
        public String getAlpha() {
            return this.myAlpha;
        }

        @NotNull
        public Map<String, Boolean> getAttributes() {
            Map<String, Boolean> map = this.myAttributes;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateListState", "getAttributes"));
            }
            return map;
        }

        @NotNull
        public ImmutableList<String> getAttributesNames(boolean capitalize) {
            Map<String, Boolean> attributes = this.getAttributes();
            if (attributes.isEmpty()) {
                ImmutableList immutableList = ImmutableList.of((Object)(capitalize ? "Default" : "default"));
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateListState", "getAttributesNames"));
                }
                return immutableList;
            }
            ImmutableList.Builder attributeDescriptions = ImmutableList.builder();
            for (Map.Entry<String, Boolean> attribute : attributes.entrySet()) {
                String description = attribute.getKey().substring(ResourceHelper.STATE_NAME_PREFIX.length());
                if (!attribute.getValue().booleanValue()) {
                    description = "not " + description;
                }
                attributeDescriptions.add((Object)(capitalize ? StringUtil.capitalize((String)description) : description));
            }
            ImmutableList immutableList = attributeDescriptions.build();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateListState", "getAttributesNames"));
            }
            return immutableList;
        }

        private boolean matchesWithEnabledObjectState(@NotNull ImmutableSet<ImmutableMap<String, Boolean>> allowedObjectStates) {
            if (allowedObjectStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedObjectStates", "com/android/tools/idea/res/ResourceHelper$StateListState", "matchesWithEnabledObjectState"));
            }
            if (this.myAttributes.containsKey(STATE_ENABLED) && !this.myAttributes.get(STATE_ENABLED).booleanValue()) {
                return false;
            }
            for (Map allowedAttributes : allowedObjectStates) {
                if (allowedAttributes.containsKey(STATE_ENABLED) && !((Boolean)allowedAttributes.get(STATE_ENABLED)).booleanValue()) continue;
                boolean match = true;
                for (String attribute : this.myAttributes.keySet()) {
                    if (!allowedAttributes.containsKey(attribute) || this.myAttributes.get(attribute) == allowedAttributes.get(attribute)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public String getDescription() {
            String string = Joiner.on((String)", ").join(this.getAttributesNames(true));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateListState", "getDescription"));
            }
            return string;
        }
    }

    public static class StateList {
        private final String myFileName;
        private final String myDirName;
        private final List<StateListState> myStates;

        public StateList(@NotNull String fileName, @NotNull String dirName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/res/ResourceHelper$StateList", "<init>"));
            }
            if (dirName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/android/tools/idea/res/ResourceHelper$StateList", "<init>"));
            }
            this.myFileName = fileName;
            this.myDirName = dirName;
            this.myStates = new ArrayList<StateListState>();
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "getFileName"));
            }
            return string;
        }

        @NotNull
        public String getDirName() {
            String string = this.myDirName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "getDirName"));
            }
            return string;
        }

        @NotNull
        public ResourceFolderType getFolderType() {
            ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)this.myDirName);
            if (resourceFolderType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "getFolderType"));
            }
            return resourceFolderType;
        }

        @NotNull
        public ResourceType getType() {
            ResourceFolderType resFolderType = this.getFolderType();
            ResourceType resType = ResourceType.getEnum((String)resFolderType.getName());
            assert (resType != null);
            ResourceType resourceType = resType;
            if (resourceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "getType"));
            }
            return resourceType;
        }

        @NotNull
        public List<StateListState> getStates() {
            List<StateListState> list = this.myStates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "getStates"));
            }
            return list;
        }

        public void addState(@NotNull StateListState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/res/ResourceHelper$StateList", "addState"));
            }
            this.myStates.add(state);
        }

        @NotNull
        public ImmutableList<StateListState> getDisabledStates() {
            ImmutableList.Builder disabledStatesBuilder = ImmutableList.builder();
            ImmutableSet<ImmutableMap<String, Boolean>> remainingObjectStates = ImmutableSet.of((Object)ImmutableMap.of((Object)"state_enabled", (Object)true), (Object)ImmutableMap.of((Object)"state_enabled", (Object)false));
            for (StateListState state : this.myStates) {
                if (!state.matchesWithEnabledObjectState((ImmutableSet<ImmutableMap<String, Boolean>>)((ImmutableSet)remainingObjectStates))) {
                    disabledStatesBuilder.add((Object)state);
                }
                remainingObjectStates = StateList.removeState(state, remainingObjectStates);
            }
            ImmutableList immutableList = disabledStatesBuilder.build();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "getDisabledStates"));
            }
            return immutableList;
        }

        @NotNull
        private static ImmutableSet<ImmutableMap<String, Boolean>> removeState(@NotNull StateListState state, @NotNull ImmutableSet<ImmutableMap<String, Boolean>> allowedStates) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/res/ResourceHelper$StateList", "removeState"));
            }
            if (allowedStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedStates", "com/android/tools/idea/res/ResourceHelper$StateList", "removeState"));
            }
            ImmutableSet.Builder remainingStates = ImmutableSet.builder();
            Map<String, Boolean> stateAttributes = state.getAttributes();
            for (String attribute : stateAttributes.keySet()) {
                for (ImmutableMap allowedState : allowedStates) {
                    if (!allowedState.containsKey((Object)attribute)) {
                        ImmutableMap.Builder newAllowedState = ImmutableMap.builder();
                        newAllowedState.putAll((Map)allowedState).put((Object)attribute, (Object)(stateAttributes.get(attribute) == false ? 1 : 0));
                        remainingStates.add((Object)newAllowedState.build());
                        continue;
                    }
                    if (allowedState.get((Object)attribute) == stateAttributes.get(attribute)) continue;
                    remainingStates.add((Object)allowedState);
                }
            }
            ImmutableSet immutableSet = remainingStates.build();
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceHelper$StateList", "removeState"));
            }
            return immutableSet;
        }
    }

    public static class TypedValue {
        static final int TYPE_FLOAT = 4;
        static final int TYPE_DIMENSION = 5;
        static final int COMPLEX_UNIT_SHIFT = 0;
        static final int COMPLEX_UNIT_MASK = 15;
        static final int COMPLEX_UNIT_PX = 0;
        static final int COMPLEX_UNIT_DIP = 1;
        static final int COMPLEX_UNIT_SP = 2;
        static final int COMPLEX_UNIT_PT = 3;
        static final int COMPLEX_UNIT_IN = 4;
        static final int COMPLEX_UNIT_MM = 5;
        static final int COMPLEX_RADIX_SHIFT = 4;
        static final int COMPLEX_RADIX_MASK = 3;
        static final int COMPLEX_RADIX_23p0 = 0;
        static final int COMPLEX_RADIX_16p7 = 1;
        static final int COMPLEX_RADIX_8p15 = 2;
        static final int COMPLEX_RADIX_0p23 = 3;
        static final int COMPLEX_MANTISSA_SHIFT = 8;
        static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
        private static final float MANTISSA_MULT = 0.00390625f;
        private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
        public int type;
        public int data;

        public static int complexToDimensionPixelSize(int data, Configuration config) {
            float value = TypedValue.complexToFloat(data);
            float f = TypedValue.applyDimension(data >> 0 & 0xF, value, config);
            int res = (int)(f + 0.5f);
            if (res != 0) {
                return res;
            }
            if (value == 0.0f) {
                return 0;
            }
            if (value > 0.0f) {
                return 1;
            }
            return -1;
        }

        static float complexToFloat(int complex) {
            return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
        }

        static float applyDimension(int unit, float value, Configuration config) {
            Device device = config.getDevice();
            float xdpi = 493.0f;
            if (device != null) {
                xdpi = (float)device.getDefaultHardware().getScreen().getXdpi();
            }
            switch (unit) {
                case 0: {
                    return value;
                }
                case 1: {
                    return value * (float)config.getDensity().getDpiValue() / 160.0f;
                }
                case 2: {
                    return value * (float)config.getDensity().getDpiValue() / 160.0f;
                }
                case 3: {
                    return value * xdpi * 0.013888889f;
                }
                case 4: {
                    return value * xdpi * 0.013888889f;
                }
                case 5: {
                    return value * xdpi * 0.013888889f;
                }
            }
            return 0.0f;
        }
    }

    private static final class UnitEntry {
        String name;
        int type;
        int unit;
        float scale;

        UnitEntry(String name, int type, int unit, float scale) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

