/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullApkInstaller {
    @NotNull
    private final Project myProject;
    @NotNull
    private final LaunchOptions myLaunchOptions;
    @NotNull
    private final InstalledApkCache myInstalledApkCache;
    @NotNull
    private final ConsolePrinter myPrinter;

    public FullApkInstaller(@NotNull Project project, @NotNull LaunchOptions options, @NotNull InstalledApkCache installedApkCache, @NotNull ConsolePrinter printer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/FullApkInstaller", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/run/FullApkInstaller", "<init>"));
        }
        if (installedApkCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedApkCache", "com/android/tools/idea/run/FullApkInstaller", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/FullApkInstaller", "<init>"));
        }
        this.myProject = project;
        this.myLaunchOptions = options;
        this.myInstalledApkCache = installedApkCache;
        this.myPrinter = printer;
    }

    public boolean uploadAndInstallApk(@NotNull IDevice device, @NotNull String packageName, @NotNull File localFile, @NotNull LaunchStatus launchStatus) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/FullApkInstaller", "uploadAndInstallApk"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/FullApkInstaller", "uploadAndInstallApk"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/android/tools/idea/run/FullApkInstaller", "uploadAndInstallApk"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/FullApkInstaller", "uploadAndInstallApk"));
        }
        if (!this.needsInstall(device, localFile, packageName)) {
            return true;
        }
        String remotePath = "/data/local/tmp/" + packageName;
        this.myPrinter.stdout("$ adb push " + localFile + " " + remotePath);
        try {
            device.pushFile(localFile.getPath(), remotePath);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e) {
            this.myPrinter.stderr(e.toString());
            return false;
        }
        ApkInstaller installer = new ApkInstaller(this.myPrinter, remotePath, this.myLaunchOptions.getPmInstallOptions());
        RetryingInstaller retryingInstaller = new RetryingInstaller(this.myProject, device, installer, packageName, this.myPrinter, launchStatus);
        boolean installed = retryingInstaller.install();
        if (installed) {
            try {
                this.myInstalledApkCache.setInstalled(device, localFile, packageName);
            }
            catch (IOException e) {
                Logger.getInstance(FullApkInstaller.class).info("Exception while caching installation state: ", (Throwable)e);
            }
        }
        return installed;
    }

    boolean needsInstall(@NotNull IDevice device, @NotNull File localFile, @NotNull String packageName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/FullApkInstaller", "needsInstall"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/android/tools/idea/run/FullApkInstaller", "needsInstall"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/FullApkInstaller", "needsInstall"));
        }
        if (!this.myLaunchOptions.isSkipNoopApkInstallations()) {
            return true;
        }
        try {
            Integer userId = LaunchUtils.getUserIdFromFlags(this.myLaunchOptions.getPmInstallOptions());
            if (!this.myInstalledApkCache.isInstalled(device, localFile, packageName, userId)) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        this.myPrinter.stdout("No apk changes detected since last installation, skipping installation of " + localFile.getPath());
        if (this.myLaunchOptions.isForceStopRunningApp()) {
            this.forceStopPackageSilently(device, packageName, true);
        }
        return false;
    }

    private void forceStopPackageSilently(@NotNull IDevice device, @NotNull String packageName, boolean ignoreErrors) {
        block4: {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/FullApkInstaller", "forceStopPackageSilently"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/FullApkInstaller", "forceStopPackageSilently"));
            }
            String command = "am force-stop " + packageName;
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver(), 1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (ignoreErrors) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ApkInstaller
    implements RetryingInstaller.Installer {
        private final String myRemotePath;
        private final ConsolePrinter myPrinter;
        private final String myPmInstallOptions;

        public ApkInstaller(@NotNull ConsolePrinter printer, @NotNull String remotePath, @Nullable String pmInstallOptions) {
            if (printer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "<init>"));
            }
            if (remotePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "<init>"));
            }
            this.myPrinter = printer;
            this.myRemotePath = remotePath;
            this.myPmInstallOptions = pmInstallOptions;
        }

        @Override
        @NotNull
        public InstallResult installApp(@NotNull IDevice device, @NotNull LaunchStatus launchStatus) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "installApp"));
            }
            if (launchStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "installApp"));
            }
            ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(launchStatus);
            String command = ApkInstaller.getPmInstallCommand(this.myRemotePath, this.myPmInstallOptions);
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)receiver);
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                Logger.getInstance(ApkInstaller.class).info(e);
                InstallResult installResult = new InstallResult(InstallResult.FailureCode.DEVICE_NOT_RESPONDING, "Exception while installing: " + e, null);
                if (installResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "installApp"));
                }
                return installResult;
            }
            InstallResult installResult = InstallResult.forLaunchOutput(receiver);
            if (installResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "installApp"));
            }
            return installResult;
        }

        @NotNull
        private static String getPmInstallCommand(@NotNull String remotePath, @Nullable String pmInstallOptions) {
            if (remotePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "getPmInstallCommand"));
            }
            StringBuilder sb = new StringBuilder(30);
            sb.append("pm install ");
            if (!StringUtil.isEmpty((String)pmInstallOptions)) {
                sb.append(pmInstallOptions);
                sb.append(' ');
            }
            sb.append("-r \"");
            sb.append(remotePath);
            sb.append("\"");
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/FullApkInstaller$ApkInstaller", "getPmInstallCommand"));
            }
            return string;
        }
    }
}

