/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.EmulatorTargetChooser;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.EmulatorTargetConfigurable;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorTargetProvider
extends DeployTargetProvider<State> {
    @Override
    @NotNull
    public String getId() {
        String string = TargetSelectionMode.EMULATOR.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Emulator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider", "getDisplayName"));
        }
        return "Emulator";
    }

    @Override
    @NotNull
    public State createState() {
        State state = new State();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider", "createState"));
        }
        return state;
    }

    @Override
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/EmulatorTargetProvider", "createConfigurable"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/run/editor/EmulatorTargetProvider", "createConfigurable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/editor/EmulatorTargetProvider", "createConfigurable"));
        }
        return new EmulatorTargetConfigurable(project, parentDisposable, context);
    }

    @Override
    public DeployTarget<State> getDeployTarget() {
        return new DeployTarget<State>(){

            @Override
            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "hasCustomRunProfileState"));
                }
                return false;
            }

            @Override
            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull State state) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "getRunProfileState"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "getRunProfileState"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "getRunProfileState"));
                }
                return null;
            }

            @Override
            @Nullable
            public DeviceFutures getDevices(@NotNull State state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "getDevices"));
                }
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "getDevices"));
                }
                if (deviceCount == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/editor/EmulatorTargetProvider$1", "getDevices"));
                }
                return new EmulatorTargetChooser(facet, Strings.emptyToNull((String)state.PREFERRED_AVD)).getDevices(deviceCount);
            }
        };
    }

    public static final class State
    extends DeployTargetState {
        public String PREFERRED_AVD = "";

        @Override
        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/EmulatorTargetProvider$State", "validate"));
            }
            if (StringUtil.isEmpty((String)this.PREFERRED_AVD)) {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider$State", "validate"));
                }
                return immutableList;
            }
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager == null) {
                ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0])));
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider$State", "validate"));
                }
                return immutableList;
            }
            AvdInfo avdInfo = avdManager.getAvd(this.PREFERRED_AVD, false);
            if (avdInfo == null) {
                ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.not.found.error", this.PREFERRED_AVD)));
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider$State", "validate"));
                }
                return immutableList;
            }
            if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
                String message = avdInfo.getErrorMessage();
                message = AndroidBundle.message("avd.not.valid.error", this.PREFERRED_AVD) + (message != null ? ": " + message : "") + ". Try to repair it through AVD manager";
                ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(message));
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider$State", "validate"));
                }
                return immutableList;
            }
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/EmulatorTargetProvider$State", "validate"));
            }
            return immutableList;
        }
    }
}

