/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.progress;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProgressRunner
implements ProgressRunner {
    private final boolean myInvokeInUiThread;
    private boolean myModal;
    private final boolean myCancellable;
    private final Project myProject;
    private final String myProgressTitle;

    public StudioProgressRunner(boolean modal, boolean cancellable, String progressTitle, boolean invokeInUiThread, @Nullable Project project) {
        this.myModal = modal;
        this.myCancellable = cancellable;
        this.myProject = project;
        this.myProgressTitle = progressTitle;
        this.myInvokeInUiThread = invokeInUiThread;
    }

    public void runAsyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/android/tools/idea/sdk/progress/StudioProgressRunner", "runAsyncWithProgress"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean hasOpenProjects;
                Task.Backgroundable task = new Task.Backgroundable(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable, new PerformInBackgroundOption(){

                    public boolean shouldStartInBackground() {
                        return !StudioProgressRunner.this.myModal;
                    }
                }){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/progress/StudioProgressRunner$1$2", "run"));
                        }
                        r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                    }

                    public boolean isConditionalModal() {
                        return true;
                    }
                };
                boolean bl = hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
                if (hasOpenProjects) {
                    ProgressManager.getInstance().run((Task)task);
                } else {
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (com.intellij.openapi.progress.ProgressIndicator)new EmptyProgressIndicator());
                }
            }
        });
    }

    public void runSyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/android/tools/idea/sdk/progress/StudioProgressRunner", "runSyncWithProgress"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Object task = StudioProgressRunner.this.myModal ? new Task.Modal(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/progress/StudioProgressRunner$2$1", "run"));
                        }
                        r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                    }
                } : new Task.Backgroundable(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/progress/StudioProgressRunner$2$2", "run"));
                        }
                        r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            }
        });
    }

    public void runSyncWithoutProgress(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/android/tools/idea/sdk/progress/StudioProgressRunner", "runSyncWithoutProgress"));
        }
        if (this.myInvokeInUiThread) {
            ApplicationManager.getApplication().invokeAndWait(r, ModalityState.any());
        } else {
            r.run();
        }
    }
}

