/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkQuickfixUtils {
    private static final ProgressIndicator REPO_LOGGER = new StudioLoggerProgressIndicator(SdkQuickfixUtils.class);

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Component parent, @NotNull Collection<String> requestedPaths, boolean backgroundable) {
        if (requestedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPaths", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPaths"));
        }
        return SdkQuickfixUtils.createDialog(null, parent, requestedPaths, null, null, SdkQuickfixUtils.getSdkHandler(), backgroundable);
    }

    @Nullable
    public static ModelWizardDialog createDialogForPackages(@Nullable Component parent, @NotNull Collection<UpdatablePackage> requestedPackages, @NotNull Collection<LocalPackage> uninstallPackages, boolean backgroundable) {
        if (requestedPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPackages"));
        }
        if (uninstallPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uninstallPackages", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPackages"));
        }
        return SdkQuickfixUtils.createDialog(null, parent, null, requestedPackages, uninstallPackages, SdkQuickfixUtils.getSdkHandler(), backgroundable);
    }

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Project project, @NotNull Collection<String> requestedPaths) {
        if (requestedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPaths", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPaths"));
        }
        return SdkQuickfixUtils.createDialog(project, null, requestedPaths, null, null, SdkQuickfixUtils.getSdkHandler(), false);
    }

    private static AndroidSdkHandler getSdkHandler() {
        AndroidSdkData data = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (data == null) {
            String title = "SDK Problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return null;
        }
        return data.getSdkHandler();
    }

    @Nullable
    static ModelWizardDialog createDialog(@Nullable Project project, @Nullable Component parent, @Nullable Collection<String> requestedPaths, @Nullable Collection<UpdatablePackage> requestedPackages, @Nullable Collection<LocalPackage> requestedUninstalls, @Nullable AndroidSdkHandler sdkHandler, boolean backgroundable) {
        List<UpdatablePackage> resolvedPackages;
        if (sdkHandler == null) {
            return null;
        }
        RepoManager mgr = sdkHandler.getSdkManager(REPO_LOGGER);
        if (mgr.getLocalPath() == null) {
            String title = "SDK Problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return null;
        }
        ArrayList<String> unknownPaths = new ArrayList<String>();
        mgr.loadSynchronously(0L, (ProgressIndicator)new StudioLoggerProgressIndicator(SdkQuickfixUtils.class), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        RepositoryPackages packages = mgr.getPackages();
        if (requestedPackages == null) {
            requestedPackages = new ArrayList<UpdatablePackage>();
        }
        requestedPackages.addAll(SdkQuickfixUtils.lookupPaths(requestedPaths, packages, unknownPaths));
        try {
            resolvedPackages = SdkQuickfixUtils.resolve(requestedPackages, packages);
        }
        catch (PackageResolutionException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Error Resolving Packages");
            return null;
        }
        HashSet<LocalPackage> resolvedUninstalls = new HashSet<LocalPackage>();
        if (requestedUninstalls != null) {
            resolvedUninstalls.addAll(requestedUninstalls);
            resolvedPackages.forEach(updatable -> resolvedUninstalls.remove(updatable.getLocal()));
        }
        ArrayList unavailableDownloads = Lists.newArrayList();
        SdkQuickfixUtils.verifyAvailability(resolvedPackages, unavailableDownloads);
        if (!unknownPaths.isEmpty() || !unavailableDownloads.isEmpty()) {
            String title = "Packages Unavailable";
            HtmlBuilder builder = new HtmlBuilder();
            builder.openHtmlBody().add(String.format("%1$s packages are not available for download!", resolvedPackages.isEmpty() ? "All" : "Some")).newline().newline().add("The following packages are not available:").beginList();
            for (UpdatablePackage updatablePackage : unavailableDownloads) {
                builder.listItem().add(updatablePackage.getRepresentative().getDisplayName());
            }
            for (String string : unknownPaths) {
                builder.listItem().add("Package id " + string);
            }
            builder.endList().closeHtmlBody();
            Messages.showErrorDialog((String)builder.getHtml(), (String)title);
        }
        if (resolvedPackages.isEmpty() && resolvedUninstalls.isEmpty()) {
            return null;
        }
        List<RemotePackage> installRequests = resolvedPackages.stream().map(UpdatablePackage::getRemote).collect(Collectors.toList());
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new LicenseAgreementStep(new LicenseAgreementModel(mgr.getLocalPath()), installRequests));
        InstallSelectedPackagesStep installStep = new InstallSelectedPackagesStep(resolvedPackages, resolvedUninstalls, sdkHandler, backgroundable);
        wizardBuilder.addStep(installStep);
        ModelWizard modelWizard = wizardBuilder.build();
        String title = "SDK Quickfix Installation";
        return new StudioWizardDialogBuilder(modelWizard, title, parent).setProject(project).setModalityType(DialogWrapper.IdeModalityType.IDE).setCancellationPolicy(ModelWizardDialog.CancellationPolicy.CAN_CANCEL_UNTIL_CAN_FINISH).build();
    }

    @NotNull
    private static Collection<UpdatablePackage> lookupPaths(Collection<String> requestedPaths, RepositoryPackages packages, List<String> unknownPaths) {
        Map consolidated = packages.getConsolidatedPkgs();
        ArrayList<UpdatablePackage> result = new ArrayList<UpdatablePackage>();
        if (requestedPaths != null) {
            for (String path : requestedPaths) {
                UpdatablePackage p = (UpdatablePackage)consolidated.get(path);
                if (p == null || !p.hasRemote()) {
                    unknownPaths.add(path);
                    continue;
                }
                result.add(p);
            }
        }
        ArrayList<UpdatablePackage> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "lookupPaths"));
        }
        return arrayList;
    }

    private static void verifyAvailability(List<UpdatablePackage> requestedPackages, List<UpdatablePackage> unavailableDownloads) {
        ListIterator<UpdatablePackage> iter = requestedPackages.listIterator();
        while (iter.hasNext()) {
            UpdatablePackage p = (UpdatablePackage)iter.next();
            if (p.hasRemote()) continue;
            iter.remove();
            unavailableDownloads.add(p);
        }
    }

    public static List<UpdatablePackage> resolve(@Nullable Collection<UpdatablePackage> requestedPackages, @NotNull RepositoryPackages packages) throws PackageResolutionException {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "resolve"));
        }
        ArrayList<UpdatablePackage> result = new ArrayList<UpdatablePackage>();
        if (requestedPackages == null) {
            requestedPackages = Lists.newArrayList();
        }
        ArrayList resolved = Lists.newArrayList((Iterable)requestedPackages);
        ArrayList remotes = Lists.newArrayList();
        for (UpdatablePackage p : resolved) {
            if (!p.hasRemote()) continue;
            remotes.add(p.getRemote());
        }
        final AtomicReference warning = new AtomicReference();
        ProgressIndicatorAdapter errorCollector = new ProgressIndicatorAdapter(){

            public void logWarning(@NotNull String s) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils$1", "logWarning"));
                }
                warning.set(s);
            }
        };
        List requiredPackages = InstallerUtil.computeRequiredPackages((Collection)remotes, (RepositoryPackages)packages, (ProgressIndicator)errorCollector);
        if (requiredPackages == null) {
            throw new PackageResolutionException((String)warning.get());
        }
        Set requiredPaths = requiredPackages.stream().map(RepoPackage::getPath).collect(Collectors.toCollection(LinkedHashSet::new));
        Map allPackages = packages.getConsolidatedPkgs();
        for (String path : requiredPaths) {
            UpdatablePackage requiredPackage = (UpdatablePackage)allPackages.get(path);
            if (requiredPackage == null) {
                throw new PackageResolutionException("Failed to find package with key " + path);
            }
            result.add(requiredPackage);
        }
        return result;
    }

    public static class PackageResolutionException
    extends Exception {
        public PackageResolutionException(String message) {
            super(message);
        }
    }
}

