/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteDefinition;
import com.android.tools.idea.uibuilder.property.NlPropertyPanelDefinition;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeDefinition;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditorPanel
extends WorkBench<DesignSurface> {
    private final XmlFile myFile;
    private final DesignSurface mySurface;

    public NlEditorPanel(@NotNull NlEditor editor, @NotNull Project project, @NotNull AndroidFacet facet, @NotNull VirtualFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlEditorPanel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlEditorPanel", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/editor/NlEditorPanel", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/editor/NlEditorPanel", "<init>"));
        }
        super(project, "NELE_EDITOR", (FileEditor)editor);
        this.setOpaque(true);
        this.myFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, file);
        assert (this.myFile != null) : file;
        this.mySurface = new DesignSurface(project, false);
        Disposer.register((Disposable)editor, (Disposable)this.mySurface);
        NlModel model = NlModel.create(this.mySurface, (Disposable)editor, facet, this.myFile);
        this.mySurface.setModel(model);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JComponent toolbarComponent = this.mySurface.getActionManager().createToolbar(model);
        contentPanel.add((Component)toolbarComponent, "North");
        contentPanel.add(this.mySurface);
        ArrayList<ToolWindowDefinition> tools = new ArrayList<ToolWindowDefinition>(4);
        tools.add(new NlPaletteDefinition(project, Side.LEFT, Split.TOP, AutoHide.DOCKED));
        tools.add(new NlComponentTreeDefinition(Side.LEFT, Split.BOTTOM, AutoHide.DOCKED));
        tools.add(new NlPropertyPanelDefinition(project, Side.RIGHT, Split.TOP, AutoHide.DOCKED));
        this.init(contentPanel, this.mySurface, tools);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditorPanel", "getFile"));
        }
        return xmlFile;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditorPanel", "getSurface"));
        }
        return designSurface;
    }

    public static class NlConfigurationHolder
    implements ConfigurationHolder {
        @NotNull
        private final DesignSurface mySurface;

        public NlConfigurationHolder(@NotNull DesignSurface surface) {
            if (surface == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlEditorPanel$NlConfigurationHolder", "<init>"));
            }
            this.mySurface = surface;
        }

        @Override
        @Nullable
        public Configuration getConfiguration() {
            return this.mySurface.getConfiguration();
        }
    }
}

