/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.ViewWithBackgroundCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCompleteViewCreator
extends ViewWithBackgroundCreator {
    private String myViewTag;

    public AutoCompleteViewCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/AutoCompleteViewCreator", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/AutoCompleteViewCreator", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/mockup/editor/creators/AutoCompleteViewCreator", "<init>"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/mockup/editor/creators/AutoCompleteViewCreator", "<init>"));
        }
        super(mockup, model, screenView, selection);
        this.myViewTag = "View";
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/AutoCompleteViewCreator", "getOptionsComponent"));
        }
        ViewAndColorForm autoCompleteForm = new ViewAndColorForm("Create a new view", this.createColorSelectedListener(doneCallback), this.getModel().getFacet());
        BufferedImage image = this.getMockup().getImage();
        if (image == null) {
            return null;
        }
        this.extractColor(autoCompleteForm, image);
        autoCompleteForm.setAddListener(e -> {
            this.myViewTag = autoCompleteForm.getTagName();
        });
        return autoCompleteForm.getComponent();
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        String string = this.myViewTag;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/AutoCompleteViewCreator", "getAndroidViewTag"));
        }
        return string;
    }
}

