/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "<init>"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "<init>"));
        }
        super(mockup, model, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "addAttributes"));
        }
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("include" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "getAndroidViewTag"));
        }
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component = this.getMockup().getComponent();
        if (component.isOrHasSuperclass("android.support.v7.widget.RecyclerView")) {
            this.addListItemAttribute(component);
            return component;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component) {
        String newLayoutResource = this.createNewIncludedLayout();
        WriteCommandAction.runWriteCommandAction((Project)this.getModel().getProject(), (String)"Add listitem attribute", null, () -> component.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource), (PsiFile[])new PsiFile[]{this.getModel().getFile()});
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "addIncludeAttribute"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "addIncludeAttribute"));
        }
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        ResourceFolderType folderType;
        AndroidFacet facet = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet, folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(ResourceType.LAYOUT), null, null, null, true, null, null, null, false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        NlModel nlModel = NlModel.create(this.getScreenView().getSurface(), (Disposable)newFile.getProject(), facet, newFile);
        ModelListener listener = new ModelListener(){

            @Override
            public void modelChanged(@NotNull NlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator$1", "modelChanged"));
                }
            }

            @Override
            public void modelRendered(@NotNull NlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator$1", "modelRendered"));
                }
                model.removeListener(this);
                if (model.getComponents().isEmpty()) {
                    return;
                }
                NlComponent component = model.getComponents().get(0);
                AttributesTransaction transaction = component.startAttributeTransaction();
                IncludeTagCreator.this.addShowInAttribute(transaction);
                IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                WriteCommandAction.runWriteCommandAction((Project)model.getProject(), transaction::commit);
            }

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator$1", "modelChangedOnLayout"));
                }
            }
        };
        nlModel.addListener(listener);
        nlModel.requestRender();
        return IncludeTagCreator.getResourceName(newFile);
    }

    @NotNull
    private static String getResourceName(@NotNull XmlFile newFile) {
        if (newFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFile", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "getResourceName"));
        }
        String string = AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "getResourceName"));
        }
        return string;
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator", "addShowInAttribute"));
        }
        String showInName = IncludeTagCreator.getResourceName(this.getModel().getFile());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }
}

