/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public final class ResourcesUtil {
    private static final Logger LOGGER = Logger.getInstance(ResourcesUtil.class);

    public static boolean checkDrawableExist(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet) {
        if (drawableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "checkDrawableExist"));
        }
        if (drawableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableType", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "checkDrawableExist"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "checkDrawableExist"));
        }
        List<VirtualFile> drawableSubDirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, VfsUtilCore.toVirtualFileArray(facet.getModuleResources(true).getResourceDirs()));
        for (VirtualFile dir : drawableSubDirs) {
            if (dir.findChild(String.format("%s.%s", drawableName, drawableType)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull NlModel model, @NotNull BufferedImage image, @NotNull Object requestor) {
        if (drawableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (drawableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableType", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        AndroidFacet facet = model.getFacet();
        List<VirtualFile> drawableSubDirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, VfsUtilCore.toVirtualFileArray(facet.getModuleResources(true).getResourceDirs()));
        try {
            byte[] imageInByte = ResourcesUtil.imageToByteArray(image, drawableType);
            Project project = model.getProject();
            if (!drawableSubDirs.isEmpty()) {
                ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableSubDirs.get(0), doneCallback, requestor);
            } else {
                ResourcesUtil.createDrawableAndFolder(drawableName, drawableType, facet, imageInByte, project, doneCallback, requestor);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while converting image to bytes");
            return false;
        }
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Mockup mockup, @NotNull NlModel model, @NotNull Rectangle selectionBounds, @NotNull Object requestor) {
        if (drawableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (drawableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableType", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (selectionBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionBounds", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawable"));
        }
        BufferedImage image = mockup.getImage();
        if (image == null) {
            return false;
        }
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subImage = image.getSubimage(selectionBounds.x + realCropping.x, selectionBounds.y + realCropping.y, selectionBounds.width, selectionBounds.height);
        return ResourcesUtil.createDrawable(drawableName, drawableType, doneCallback, model, subImage, requestor);
    }

    public static byte[] imageToByteArray(BufferedImage subImage, String imageType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)subImage, imageType, baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        return imageInByte;
    }

    private static void createDrawableAndFolder(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        if (drawableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        if (drawableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableType", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        if (imageInByte == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInByte", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableAndFolder"));
        }
        Collection<VirtualFile> resDirectories = facet.getMainIdeaSourceProvider().getResDirectories();
        Iterator<VirtualFile> iterator = resDirectories.iterator();
        if (iterator.hasNext()) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableAndFolder$1"));
                }
                if (drawableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableAndFolder$1"));
                }
                if (drawableType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableType", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableAndFolder$1"));
                }
                if (imageInByte == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInByte", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableAndFolder$1"));
                }
                if (doneCallback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableAndFolder$1"));
                }
                if (requestor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableAndFolder$1"));
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$0"));
                    }
                    if (drawableName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$0"));
                    }
                    if (drawableType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableType", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$0"));
                    }
                    if (imageInByte == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInByte", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$0"));
                    }
                    if (doneCallback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$0"));
                    }
                    if (requestor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$0"));
                    }
                    try {
                        VirtualFile drawableDir = AndroidUtils.createChildDirectoryIfNotExist(project, (VirtualFile)iterator.next(), "drawable");
                        ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableDir, doneCallback, requestor);
                    }
                    catch (IOException e) {
                        LOGGER.error((Throwable)e);
                    }
                });
            }, "Export selection to drawable", null);
        }
    }

    private static void createDrawableFile(@NotNull String fileName, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull VirtualFile drawableDir, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableFile"));
        }
        if (imageInByte == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInByte", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableFile"));
        }
        if (drawableDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableDir", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableFile"));
        }
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableFile"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "createDrawableFile"));
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (drawableDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableDir", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableFile$3"));
            }
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableFile$3"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableFile$3"));
            }
            if (imageInByte == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInByte", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableFile$3"));
            }
            if (doneCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$createDrawableFile$3"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (drawableDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawableDir", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$2"));
                }
                if (requestor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$2"));
                }
                if (fileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$2"));
                }
                if (imageInByte == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInByte", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$2"));
                }
                if (doneCallback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil", "lambda$null$2"));
                }
                try {
                    VirtualFile folder = drawableDir.createChildData(requestor, fileName);
                    folder.setBinaryContent(imageInByte);
                    doneCallback.done(1);
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                    doneCallback.done(0);
                }
            });
        }, "Export selection to drawable", null);
    }
}

