/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static final float DEFAULT_DENSITY = 160.0f;

    public static int getSwingX(@NotNull ScreenView view, int androidX) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getSwingX"));
        }
        return view.getX() + (int)(view.getScale() * (double)androidX);
    }

    public static int getSwingY(@NotNull ScreenView view, int androidY) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getSwingY"));
        }
        return view.getY() + (int)(view.getScale() * (double)androidY);
    }

    public static int getSwingDimension(@NotNull ScreenView view, int androidDimension) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getSwingDimension"));
        }
        return (int)(view.getScale() * (double)androidDimension);
    }

    public static int dpToPx(@NotNull ScreenView view, int androidDp) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "dpToPx"));
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidDp * ((float)dpiValue / 160.0f));
    }

    public static int dpToPx(@NotNull ScreenView view, float androidDp) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "dpToPx"));
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round(androidDp * ((float)dpiValue / 160.0f));
    }

    public static int pxToDp(@NotNull ScreenView view, int androidPx) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "pxToDp"));
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidPx * (160.0f / (float)dpiValue));
    }

    public static int getSwingXDip(@NotNull ScreenView view, int androidDpX) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getSwingXDip"));
        }
        return Coordinates.getSwingX(view, Coordinates.dpToPx(view, androidDpX));
    }

    public static int getSwingYDip(@NotNull ScreenView view, int androidDpY) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getSwingYDip"));
        }
        return Coordinates.getSwingY(view, Coordinates.dpToPx(view, androidDpY));
    }

    public static int getSwingDimensionDip(@NotNull ScreenView view, int androidDpDimension) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getSwingDimensionDip"));
        }
        return Coordinates.getSwingDimension(view, Coordinates.dpToPx(view, androidDpDimension));
    }

    public static int getAndroidX(@NotNull ScreenView view, int swingX) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getAndroidX"));
        }
        return (int)((double)(swingX - view.getX()) / view.getScale());
    }

    public static int getAndroidXDip(@NotNull ScreenView view, int swingX) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getAndroidXDip"));
        }
        return Coordinates.pxToDp(view, Coordinates.getAndroidX(view, swingX));
    }

    public static int getAndroidY(@NotNull ScreenView view, int swingY) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getAndroidY"));
        }
        return (int)((double)(swingY - view.getY()) / view.getScale());
    }

    public static int getAndroidYDip(@NotNull ScreenView view, int swingY) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getAndroidYDip"));
        }
        return Coordinates.pxToDp(view, Coordinates.getAndroidY(view, swingY));
    }

    public static int getAndroidDimension(@NotNull ScreenView view, int swingDimension) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getAndroidDimension"));
        }
        return (int)((double)swingDimension / view.getScale());
    }

    public static int getAndroidDimensionDip(@NotNull ScreenView view, int swingDimension) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "getAndroidDimensionDip"));
        }
        return Coordinates.pxToDp(view, Coordinates.getSwingDimension(view, swingDimension));
    }

    @Nullable
    public static NlComponent findComponent(@NotNull ScreenView view, int swingX, int swingY) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "findComponent"));
        }
        return view.getModel().findLeafAt(Coordinates.getAndroidX(view, swingX), Coordinates.getAndroidY(view, swingY), false);
    }

    @Nullable
    public static NlComponent findImmediateComponent(@NotNull ScreenView view, int swingX, int swingY) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/Coordinates", "findImmediateComponent"));
        }
        if (view.getModel().getComponents().isEmpty()) {
            return null;
        }
        SelectionModel selectionModel = view.getSelectionModel();
        NlComponent start = null;
        start = selectionModel.isEmpty() ? view.getModel().getComponents().get(0).getRoot() : selectionModel.getPrimary();
        NlComponent found = start.findImmediateLeafAt(Coordinates.getAndroidX(view, swingX), Coordinates.getAndroidY(view, swingY));
        if (found == null) {
            found = Coordinates.findComponent(view, swingX, swingY);
        }
        return found;
    }
}

