/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.property.NlPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.google.common.collect.ImmutableSet;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlMarginPropertyAccumulator
extends NlPropertyAccumulator {
    private static final ColoredTableCellRenderer MARGIN_VALUE_RENDERER = NlMarginPropertyAccumulator.createTableCellRenderer();
    private final String myAllMargin;
    private final String myLeftMargin;
    private final String myRightMargin;
    private final String myStartMargin;
    private final String myEndMargin;
    private final String myTopMargin;
    private final String myBottomMargin;
    private final Set<String> myPropertyNames;

    public NlMarginPropertyAccumulator(@NotNull String groupName, @NotNull String allMargin, @NotNull String leftMargin, @NotNull String rightMargin, @NotNull String startMargin, @NotNull String endMargin, @NotNull String topMargin, @NotNull String bottomMargin) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (allMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (leftMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (rightMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (startMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (endMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (topMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        if (bottomMargin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bottomMargin", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "<init>"));
        }
        super(groupName);
        this.myAllMargin = allMargin;
        this.myLeftMargin = leftMargin;
        this.myRightMargin = rightMargin;
        this.myStartMargin = startMargin;
        this.myEndMargin = endMargin;
        this.myTopMargin = topMargin;
        this.myBottomMargin = bottomMargin;
        this.myPropertyNames = ImmutableSet.of((Object)allMargin, (Object)leftMargin, (Object)rightMargin, (Object)startMargin, (Object)endMargin, (Object)topMargin, (Object[])new String[]{bottomMargin});
    }

    @Override
    protected boolean isApplicable(@NotNull NlPropertyItem property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "isApplicable"));
        }
        return this.myPropertyNames.contains(property.getName());
    }

    @Override
    @NotNull
    protected PTableGroupItem createGroupNode(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "createGroupNode"));
        }
        MarginGroupNode marginGroupNode = new MarginGroupNode();
        if (marginGroupNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator", "createGroupNode"));
        }
        return marginGroupNode;
    }

    private static ColoredTableCellRenderer createTableCellRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                assert (value instanceof MarginGroupNode);
                MarginGroupNode node = (MarginGroupNode)value;
                NlMarginPropertyAccumulator accumulator = node.getAccumulator();
                this.append("[");
                this.append(node, accumulator.myAllMargin, null);
                this.append(", ");
                this.append(node, accumulator.myLeftMargin, accumulator.myStartMargin);
                this.append(", ");
                this.append(node, accumulator.myTopMargin, null);
                this.append(", ");
                this.append(node, accumulator.myRightMargin, accumulator.myEndMargin);
                this.append(", ");
                this.append(node, accumulator.myBottomMargin, null);
                this.append("]");
            }

            private void append(@NotNull MarginGroupNode node, @NotNull String propertyName, @Nullable String propertyOverride) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator$1", "append"));
                }
                if (propertyName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator$1", "append"));
                }
                SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                PTableItem property = node.getItemByName(propertyName);
                PTableItem override = propertyOverride != null ? node.getItemByName(propertyOverride) : null;
                String value = null;
                if (override != null && !override.isDefaultValue(value = override.getResolvedValue())) {
                    attributes = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
                }
                if (property != null && value == null && !property.isDefaultValue(value = property.getResolvedValue())) {
                    attributes = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
                }
                if (value == null) {
                    value = "?";
                }
                this.append(value, attributes);
            }
        };
    }

    private class MarginGroupNode
    extends PTableGroupItem {
        private MarginGroupNode() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = NlMarginPropertyAccumulator.this.getGroupName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator$MarginGroupNode", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public TableCellRenderer getCellRenderer() {
            ColoredTableCellRenderer coloredTableCellRenderer = MARGIN_VALUE_RENDERER;
            if (coloredTableCellRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlMarginPropertyAccumulator$MarginGroupNode", "getCellRenderer"));
            }
            return coloredTableCellRenderer;
        }

        private NlMarginPropertyAccumulator getAccumulator() {
            return NlMarginPropertyAccumulator.this;
        }
    }
}

