/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.utils.Pair;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        AndroidFacet facet = NlProperties.getFacet(components);
        if (facet == null) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
            }
            return immutableTable;
        }
        GradleDependencyManager dependencyManager = GradleDependencyManager.getInstance(facet.getModule().getProject());
        Table<String, String, NlPropertyItem> table = this.getProperties(facet, components, dependencyManager);
        if (table == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        return table;
    }

    Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        if (dependencyManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        return (Table)ApplicationManager.getApplication().runReadAction(() -> {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "lambda$getProperties$0"));
            }
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "lambda$getProperties$0"));
            }
            if (dependencyManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/property/NlProperties", "lambda$getProperties$0"));
            }
            return this.getPropertiesWithReadLock(facet, components, dependencyManager);
        });
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesWithReadLock(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
        }
        if (dependencyManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
        }
        LocalResourceManager localResourceManager = facet.getLocalResourceManager();
        SystemResourceManager systemResourceManager = facet.getSystemResourceManager();
        if (systemResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
            }
            return immutableTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        for (NlComponent component : components) {
            XmlTag tag = component.getTag();
            if (!tag.isValid()) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
                }
                return immutableTable;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
                }
                return immutableTable;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                String namespace = NlProperties.getNamespace(desc, tag);
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(namespace) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(desc.getName());
                NlPropertyItem property = NlPropertyItem.create(components, desc, namespace, attrDef);
                properties.put((Object)StringUtil.notNullize((String)namespace), (Object)property.getName(), (Object)property);
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(components, new AndroidAnyAttributeDescriptor("popupBackground"), "http://schemas.android.com/apk/res/android", systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.setUpSrcCompat(combinedProperties, facet, components, dependencyManager);
        NlProperties.initStarState(combinedProperties);
        Table<String, String, NlPropertyItem> table = combinedProperties;
        if (table == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
        }
        return table;
    }

    @Nullable
    private static AndroidFacet getFacet(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "getFacet"));
        }
        if (components.isEmpty()) {
            return null;
        }
        NlComponent first = components.get(0);
        XmlTag firstTag = first.getTag();
        return AndroidFacet.getInstance((PsiElement)firstTag);
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "initStarState"));
        }
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property.getFirst(), property.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/NlProperties", "saveStarState"));
        }
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        StringBuilder builder = new StringBuilder();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            builder.append(starredProperty);
            builder.append(";");
        }
        if (starred) {
            builder.append(propertyNameWithPrefix);
            builder.append(";");
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, builder.toString());
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertyNameWithPrefix"));
        }
        if (namespace == null) {
            String string = propertyName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertyNameWithPrefix"));
            }
            return string;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                String string = "tools:" + propertyName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertyNameWithPrefix"));
                }
                return string;
            }
            case "http://schemas.android.com/apk/res/android": {
                String string = propertyName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertyNameWithPrefix"));
                }
                return string;
            }
        }
        String string = "app:" + propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertyNameWithPrefix"));
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNameWithPrefix", "com/android/tools/idea/uibuilder/property/NlProperties", "split"));
        }
        if (propertyNameWithPrefix.startsWith("tools:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "split"));
            }
            return pair;
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "split"));
            }
            return pair;
        }
        Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "split"));
        }
        return pair;
    }

    @Nullable
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/uibuilder/property/NlProperties", "getNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/property/NlProperties", "getNamespace"));
        }
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            return ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        return null;
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "combine"));
        }
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpDesignProperties"));
        }
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static void setUpSrcCompat(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        if (dependencyManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        NlPropertyItem srcProperty = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)"src");
        if (srcProperty != null && NlProperties.shouldAddSrcCompat(facet, components, dependencyManager)) {
            AttributeDefinition srcDefinition = srcProperty.getDefinition();
            assert (srcDefinition != null);
            AttributeDefinition srcCompatDefinition = new AttributeDefinition("srcCompat", null, srcDefinition.getFormats());
            srcCompatDefinition.getParentStyleables().addAll(srcDefinition.getParentStyleables());
            NlPropertyItem srcCompatProperty = new NlPropertyItem(components, "http://schemas.android.com/apk/res-auto", srcCompatDefinition);
            properties.put((Object)"http://schemas.android.com/apk/res-auto", (Object)"srcCompat", (Object)srcCompatProperty);
        }
    }

    private static boolean shouldAddSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "shouldAddSrcCompat"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "shouldAddSrcCompat"));
        }
        if (dependencyManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/property/NlProperties", "shouldAddSrcCompat"));
        }
        return dependencyManager.dependsOn(facet.getModule(), "com.android.support:appcompat-v7") && NlProperties.allComponentsAreImageViews(facet, components) && NlProperties.currentActivityIfFoundIsDerivedFromAppCompatActivity(components);
    }

    private static boolean allComponentsAreImageViews(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "allComponentsAreImageViews"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "allComponentsAreImageViews"));
        }
        ViewHandlerManager manager = ViewHandlerManager.get(facet);
        if (components.isEmpty()) {
            return false;
        }
        for (NlComponent component : components) {
            ViewHandler handler = manager.getHandler(component.getTagName());
            if (handler instanceof ImageViewHandler) continue;
            return false;
        }
        return true;
    }

    private static boolean currentActivityIfFoundIsDerivedFromAppCompatActivity(@NotNull List<NlComponent> components) {
        PsiClass activityClass;
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "currentActivityIfFoundIsDerivedFromAppCompatActivity"));
        }
        assert (!components.isEmpty());
        NlModel model = components.get(0).getModel();
        Configuration configuration = model.getConfiguration();
        String activityClassName = configuration.getActivity();
        if (activityClassName == null) {
            return true;
        }
        if (activityClassName.startsWith(".")) {
            MergedManifest manifest = MergedManifest.get(model.getModule());
            String pkg = StringUtil.notNullize((String)manifest.getPackage());
            activityClassName = pkg + activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)model.getProject());
        for (activityClass = facade.findClass(activityClassName, model.getModule().getModuleScope()); activityClass != null && !"android.support.v7.app.AppCompatActivity".equals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }
}

