/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.StyleEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAppearanceEnumSupport
extends StyleEnumSupport {
    static final String TEXT_APPEARANCE = "TextAppearance";
    static final Pattern TEXT_APPEARANCE_PATTERN = Pattern.compile("^((@(\\w+:)?)style/)?TextAppearance(\\.(.+))?$");

    public TextAppearanceEnumSupport(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/TextAppearanceEnumSupport", "<init>"));
        }
        super(property);
    }

    TextAppearanceEnumSupport(@NotNull NlProperty property, @NotNull StyleFilter styleFilter) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/TextAppearanceEnumSupport", "<init>"));
        }
        if (styleFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleFilter", "com/android/tools/idea/uibuilder/property/editors/support/TextAppearanceEnumSupport", "<init>"));
        }
        super(property, styleFilter);
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        List<ValueWithDisplayString> list = this.convertStylesToDisplayValues(this.myStyleFilter.getStylesDerivedFrom(TEXT_APPEARANCE, true));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/TextAppearanceEnumSupport", "getAllValues"));
        }
        return list;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (resolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValue", "com/android/tools/idea/uibuilder/property/editors/support/TextAppearanceEnumSupport", "createFromResolvedValue"));
        }
        if (!(value == null || value.startsWith("@style/") || value.startsWith("@android:style/") || value.startsWith("?attr/"))) {
            ResourceResolver resolver = this.myProperty.getResolver();
            StyleResourceValue resource = resolver.getStyle(value, true);
            if (resource == null) {
                resource = resolver.getStyle(value, false);
            }
            if (resource == null && !value.startsWith(TEXT_APPEARANCE)) {
                resource = resolver.getStyle("TextAppearance." + value, true);
            }
            if (resource == null && !value.startsWith(TEXT_APPEARANCE)) {
                resource = resolver.getStyle("TextAppearance." + value, false);
            }
            value = resource == null ? "@style/" + value : (resource.isFramework() ? "@android:style/" : "@style/") + resource.getName();
        }
        String display = resolvedValue;
        Matcher matcher = TEXT_APPEARANCE_PATTERN.matcher(resolvedValue);
        if (matcher.matches()) {
            display = matcher.group(5);
            if (display == null) {
                display = TEXT_APPEARANCE;
            }
        } else {
            display = StringUtil.trimStart((String)display, (String)"@android:style/");
            display = StringUtil.trimStart((String)display, (String)"@style/");
        }
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(display, value, this.generateHint(display, value));
        if (valueWithDisplayString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/TextAppearanceEnumSupport", "createFromResolvedValue"));
        }
        return valueWithDisplayString;
    }
}

