/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.ScenePicker;
import com.android.tools.idea.uibuilder.scene.decorator.SceneDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.Notch;
import com.android.tools.idea.uibuilder.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneComponent {
    public HashMap<String, Object> myCache;
    public SceneDecorator myDecorator;
    private boolean myAllowsAutoconnect;
    private final Scene myScene;
    private final NlComponent myNlComponent;
    private ArrayList<SceneComponent> myChildren;
    private SceneComponent myParent;
    private boolean myIsSelected;
    private boolean myDragging;
    private AnimatedValue myAnimatedDrawX;
    private AnimatedValue myAnimatedDrawY;
    private AnimatedValue myAnimatedDrawWidth;
    private AnimatedValue myAnimatedDrawHeight;
    private DrawState myDrawState;
    private ArrayList<Target> myTargets;
    private ViewGroupHandler myViewGroupHandler;
    private int myCurrentLeft;
    private int myCurrentTop;
    private int myCurrentRight;
    private int myCurrentBottom;
    private boolean myShowBaseline;
    private final boolean myAllowsFixedPosition;
    boolean used;
    private Notch.Provider myNotchProvider;

    public int getCenterX() {
        return this.myCurrentLeft + (this.myCurrentRight - this.myCurrentLeft) / 2;
    }

    public int getCenterY() {
        return this.myCurrentTop + (this.myCurrentBottom - this.myCurrentTop) / 2;
    }

    public SceneComponent(@NotNull Scene scene, @NotNull NlComponent component) {
        if (scene == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scene", "com/android/tools/idea/uibuilder/scene/SceneComponent", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/SceneComponent", "<init>"));
        }
        this.myCache = new HashMap();
        this.myAllowsAutoconnect = true;
        this.myChildren = new ArrayList();
        this.myParent = null;
        this.myIsSelected = false;
        this.myDragging = false;
        this.myAnimatedDrawX = new AnimatedValue();
        this.myAnimatedDrawY = new AnimatedValue();
        this.myAnimatedDrawWidth = new AnimatedValue();
        this.myAnimatedDrawHeight = new AnimatedValue();
        this.myDrawState = DrawState.NORMAL;
        this.myTargets = new ArrayList();
        this.myCurrentLeft = 0;
        this.myCurrentTop = 0;
        this.myCurrentRight = 0;
        this.myCurrentBottom = 0;
        this.myShowBaseline = false;
        this.used = true;
        this.myScene = scene;
        this.myNlComponent = component;
        this.updateFrom(component);
        this.myScene.addComponent(this);
        this.myDecorator = SceneDecorator.get(component);
        this.myAllowsAutoconnect = !this.myNlComponent.getTagName().equalsIgnoreCase("android.support.constraint.Guideline");
        this.myAllowsFixedPosition = !this.myNlComponent.getTagName().equalsIgnoreCase("android.support.constraint.Guideline");
    }

    public SceneComponent getParent() {
        return this.myParent;
    }

    public void setParent(@NotNull SceneComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/scene/SceneComponent", "setParent"));
        }
        this.myParent = parent;
    }

    public boolean allowsAutoConnect() {
        return this.myScene.isAutoconnectOn() && this.myAllowsAutoconnect;
    }

    public int findTarget(Class aClass) {
        int count = this.myTargets.size();
        for (int i = 0; i < count; ++i) {
            if (!aClass.isInstance(this.myTargets.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void removeTarget(int pos) {
        this.myTargets.remove(pos);
    }

    public boolean hasAncestor(SceneComponent candidate) {
        for (SceneComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    public boolean allowsFixedPosition() {
        return this.myAllowsFixedPosition;
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public boolean canShowBaseline() {
        return this.myShowBaseline;
    }

    public void setShowBaseline(boolean value) {
        this.myShowBaseline = value;
    }

    public int getDrawX() {
        return this.myAnimatedDrawX.getValue(0L);
    }

    public int getDrawY() {
        return this.myAnimatedDrawY.getValue(0L);
    }

    public int getOffsetParentX() {
        if (this.myParent != null) {
            return this.getDrawX() - this.myParent.getDrawX();
        }
        return this.getDrawX();
    }

    public int getOffsetParentY() {
        if (this.myParent != null) {
            return this.getDrawY() - this.myParent.getDrawY();
        }
        return this.getDrawY();
    }

    public int getDrawWidth() {
        return this.myAnimatedDrawWidth.getValue(0L);
    }

    public int getDrawHeight() {
        return this.myAnimatedDrawHeight.getValue(0L);
    }

    public int getDrawX(long time) {
        return this.myAnimatedDrawX.getValue(time);
    }

    public int getDrawY(long time) {
        return this.myAnimatedDrawY.getValue(time);
    }

    public int getDrawWidth(long time) {
        return this.myAnimatedDrawWidth.getValue(time);
    }

    public int getDrawHeight(long time) {
        return this.myAnimatedDrawHeight.getValue(time);
    }

    public void setPosition(int dx, int dy) {
        this.myAnimatedDrawX.setValue(dx);
        this.myAnimatedDrawY.setValue(dy);
    }

    @NotNull
    public NlComponent getNlComponent() {
        NlComponent nlComponent = this.myNlComponent;
        if (nlComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/SceneComponent", "getNlComponent"));
        }
        return nlComponent;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/SceneComponent", "getScene"));
        }
        return scene;
    }

    public ArrayList<SceneComponent> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public SceneComponent getChild(int i) {
        return this.myChildren.get(i);
    }

    public void setDrawState(@NotNull DrawState drawState) {
        if (drawState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawState", "com/android/tools/idea/uibuilder/scene/SceneComponent", "setDrawState"));
        }
        this.myDrawState = drawState;
        if (this.myIsSelected) {
            this.myDrawState = DrawState.SELECTED;
        }
    }

    public int getBaseline() {
        return this.myScene.pxToDp(this.myNlComponent.getBaseline());
    }

    public void setSelected(boolean selected) {
        if (!selected || selected && !this.myIsSelected) {
            this.myShowBaseline = false;
        }
        this.myIsSelected = selected;
        this.myDrawState = this.myIsSelected ? DrawState.SELECTED : DrawState.NORMAL;
    }

    public void setDragging(boolean dragging) {
        this.myDragging = dragging;
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public DrawState getDrawState() {
        return this.myDrawState;
    }

    public ArrayList<Target> getTargets() {
        return this.myTargets;
    }

    public SceneDecorator getDecorator() {
        return this.myDecorator;
    }

    public Notch.Provider getNotchProvider() {
        return this.myNotchProvider;
    }

    public void setNotchProvider(Notch.Provider notchProvider) {
        this.myNotchProvider = notchProvider;
    }

    public void setExpandTargetArea(boolean expandArea) {
        int count = this.myTargets.size();
        for (int i = 0; i < count; ++i) {
            Target target = this.myTargets.get(i);
            if (!(target instanceof AnchorTarget)) continue;
            AnchorTarget anchor = (AnchorTarget)target;
            anchor.setExpandSize(expandArea);
        }
        this.myScene.needsRebuildList();
    }

    AnchorTarget getAnchorTarget(@NotNull AnchorTarget.Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/scene/SceneComponent", "getAnchorTarget"));
        }
        int count = this.myTargets.size();
        for (int i = 0; i < count; ++i) {
            AnchorTarget target;
            if (!(this.myTargets.get(i) instanceof AnchorTarget) || (target = (AnchorTarget)this.myTargets.get(i)).getType() != type) continue;
            return target;
        }
        return null;
    }

    ResizeTarget getResizeTarget(ResizeTarget.Type type) {
        int count = this.myTargets.size();
        for (int i = 0; i < count; ++i) {
            ResizeTarget target;
            if (!(this.myTargets.get(i) instanceof ResizeTarget) || (target = (ResizeTarget)this.myTargets.get(i)).getType() != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentId", "com/android/tools/idea/uibuilder/scene/SceneComponent", "getSceneComponent"));
        }
        if (componentId.equalsIgnoreCase(this.myNlComponent.getId())) {
            return this;
        }
        int count = this.myChildren.size();
        for (int i = 0; i < count; ++i) {
            SceneComponent child = this.myChildren.get(i);
            SceneComponent found = child.getSceneComponent(componentId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public ViewGroupHandler getViewGroupHandler() {
        return this.myViewGroupHandler;
    }

    public void setViewGroupHandler(@Nullable ViewGroupHandler viewGroupHandler, boolean isParent) {
        if (viewGroupHandler == this.myViewGroupHandler) {
            return;
        }
        this.myTargets.clear();
        this.myNotchProvider = null;
        this.myViewGroupHandler = viewGroupHandler;
        if (this.myViewGroupHandler != null) {
            this.myViewGroupHandler.addTargets(this, isParent);
        }
    }

    public boolean intersects(Rectangle rectangle) {
        Rectangle bounds = new Rectangle();
        this.fillRect(bounds);
        return rectangle.intersects(bounds);
    }

    public void clearAttributes() {
        if (this.myViewGroupHandler != null) {
            this.myViewGroupHandler.clearAttributes(this);
        }
        int count = this.myChildren.size();
        for (int i = 0; i < count; ++i) {
            SceneComponent child = this.myChildren.get(i);
            child.clearAttributes();
        }
    }

    @NotNull
    public Target addTarget(@NotNull Target target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/uibuilder/scene/SceneComponent", "addTarget"));
        }
        target.setComponent(this);
        this.myTargets.add(target);
        Target target2 = target;
        if (target2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/SceneComponent", "addTarget"));
        }
        return target2;
    }

    public void addChild(@NotNull SceneComponent child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/uibuilder/scene/SceneComponent", "addChild"));
        }
        child.removeFromParent();
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void removeFromParent() {
        if (this.myParent != null) {
            this.myParent.remove(this);
        }
    }

    private void remove(@NotNull SceneComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/SceneComponent", "remove"));
        }
        this.myChildren.remove(component);
    }

    public void updateFrom(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/SceneComponent", "updateFrom"));
        }
        if (this.myScene.getAnimate()) {
            long time = System.currentTimeMillis();
            this.myAnimatedDrawX.setTarget(this.myScene.pxToDp(component.x), time);
            this.myAnimatedDrawY.setTarget(this.myScene.pxToDp(component.y), time);
            this.myAnimatedDrawWidth.setTarget(this.myScene.pxToDp(component.w), time);
            this.myAnimatedDrawHeight.setTarget(this.myScene.pxToDp(component.h), time);
        } else {
            this.myAnimatedDrawX.setValue(this.myScene.pxToDp(component.x));
            this.myAnimatedDrawY.setValue(this.myScene.pxToDp(component.y));
            this.myAnimatedDrawWidth.setValue(this.myScene.pxToDp(component.w));
            this.myAnimatedDrawHeight.setValue(this.myScene.pxToDp(component.h));
        }
    }

    public void markSelection(List<NlComponent> components) {
        int count = components.size();
        boolean selected = false;
        for (int i = 0; i < count; ++i) {
            NlComponent component = components.get(i);
            if (this.myNlComponent != component) continue;
            selected = true;
            break;
        }
        this.setSelected(selected);
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            child.markSelection(components);
        }
    }

    public boolean layout(@NotNull SceneContext sceneTransform, long time) {
        if (sceneTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneTransform", "com/android/tools/idea/uibuilder/scene/SceneComponent", "layout"));
        }
        boolean needsRepaint = false;
        this.myCurrentLeft = this.myAnimatedDrawX.getValue(time);
        this.myCurrentTop = this.myAnimatedDrawY.getValue(time);
        this.myCurrentRight = this.myCurrentLeft + this.myAnimatedDrawWidth.getValue(time);
        this.myCurrentBottom = this.myCurrentTop + this.myAnimatedDrawHeight.getValue(time);
        needsRepaint |= this.myAnimatedDrawX.animating;
        needsRepaint |= this.myAnimatedDrawY.animating;
        needsRepaint |= this.myAnimatedDrawWidth.animating;
        needsRepaint |= this.myAnimatedDrawHeight.animating;
        int num = this.myTargets.size();
        for (int i = 0; i < num; ++i) {
            Target target = this.myTargets.get(i);
            needsRepaint |= target.layout(sceneTransform, this.myCurrentLeft, this.myCurrentTop, this.myCurrentRight, this.myCurrentBottom);
        }
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            needsRepaint |= child.layout(sceneTransform, time);
        }
        return needsRepaint;
    }

    public void fillRect(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/android/tools/idea/uibuilder/scene/SceneComponent", "fillRect"));
        }
        rectangle.x = this.myCurrentLeft;
        rectangle.y = this.myCurrentTop;
        rectangle.width = this.myCurrentRight - this.myCurrentLeft;
        rectangle.height = this.myCurrentBottom - this.myCurrentTop;
    }

    public void addHit(@NotNull SceneContext sceneTransform, @NotNull ScenePicker picker) {
        if (sceneTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneTransform", "com/android/tools/idea/uibuilder/scene/SceneComponent", "addHit"));
        }
        if (picker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "picker", "com/android/tools/idea/uibuilder/scene/SceneComponent", "addHit"));
        }
        if (this.myDrawState == DrawState.HOVER) {
            this.myDrawState = DrawState.NORMAL;
        }
        picker.addRect(this, 0, sceneTransform.getSwingX(this.myCurrentLeft), sceneTransform.getSwingY(this.myCurrentTop), sceneTransform.getSwingX(this.myCurrentRight), sceneTransform.getSwingY(this.myCurrentBottom));
        int num = this.myTargets.size();
        for (int i = 0; i < num; ++i) {
            Target target = this.myTargets.get(i);
            target.addHit(sceneTransform, picker);
        }
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            child.addHit(sceneTransform, picker);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(long time, @NotNull DisplayList list, SceneContext sceneContext) {
        void sceneContext2;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/SceneComponent", "buildDisplayList"));
        }
        this.myDecorator.buildList(list, time, (SceneContext)sceneContext2, this);
    }

    public void fillDrawRect(long time, Rectangle rec) {
        rec.x = this.getDrawX(time);
        rec.y = this.getDrawY(time);
        rec.width = this.getDrawWidth(time);
        rec.height = this.getDrawHeight(time);
    }

    public Object getId() {
        return this.myNlComponent.getId();
    }

    public String getComponentClassName() {
        if (this.myNlComponent.viewInfo == null) {
            return null;
        }
        return this.myNlComponent.viewInfo.getClassName();
    }

    static class AnimatedValue {
        int value;
        int target;
        long startTime;
        int duration = 350;
        boolean animating = false;

        AnimatedValue() {
        }

        public void setValue(int v) {
            this.value = v;
            this.target = v;
            this.startTime = 0L;
            this.animating = false;
        }

        public void setTarget(int v, long time) {
            if (this.target == v) {
                this.animating = false;
                return;
            }
            this.startTime = time;
            this.target = v;
            this.animating = true;
        }

        public int getValue(long time) {
            if (this.startTime == 0L) {
                this.animating = false;
                return this.value;
            }
            float progress = (float)(time - this.startTime) / (float)this.duration;
            if (progress > 1.0f) {
                this.value = this.target;
                this.animating = false;
                return this.value;
            }
            if (progress <= 0.0f) {
                return this.value;
            }
            this.animating = true;
            return (int)(0.5 + this.EaseInOutInterpolator(progress, this.value, this.target));
        }

        double EaseInOutInterpolator(double progress, double begin, double end) {
            double change = (end - begin) / 2.0;
            if ((progress *= 2.0) < 1.0) {
                return change * progress * progress + begin;
            }
            return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
        }
    }

    public static enum DrawState {
        SUBDUED,
        NORMAL,
        HOVER,
        SELECTED;

    }
}

