/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.scene.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.Notch;
import com.android.tools.idea.uibuilder.scene.target.ConstraintTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragTarget
extends ConstraintTarget {
    private static final boolean DEBUG_RENDERER = false;
    protected int myOffsetX;
    protected int myOffsetY;
    protected int myFirstMouseX;
    protected int myFirstMouseY;
    protected boolean myChangedComponent;
    ArrayList<Notch> myHorizontalNotches = new ArrayList();
    ArrayList<Notch> myVerticalNotches = new ArrayList();
    Notch myCurrentNotchX = null;
    Notch myCurrentNotchY = null;

    @Override
    public boolean canChangeSelection() {
        return true;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int d;
        if (sceneTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneTransform", "com/android/tools/idea/uibuilder/scene/target/DragTarget", "layout"));
        }
        int minWidth = 16;
        int minHeight = 16;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/target/DragTarget", "render"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/target/DragTarget", "render"));
        }
        if (this.myCurrentNotchX != null) {
            this.myCurrentNotchX.render(list, sceneContext, this.myComponent);
        }
        if (this.myCurrentNotchY != null) {
            this.myCurrentNotchY.render(list, sceneContext, this.myComponent);
        }
    }

    @Nullable
    private SceneComponent getTargetComponent(@NotNull String uri, @NotNull ArrayList<String> attributes) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/android/tools/idea/uibuilder/scene/target/DragTarget", "getTargetComponent"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/scene/target/DragTarget", "getTargetComponent"));
        }
        NlComponent nlComponent = this.myComponent.getNlComponent();
        String target = null;
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            target = nlComponent.getAttribute(uri, attributes.get(i));
            if (target == null) continue;
            if (target.equalsIgnoreCase("parent")) {
                return this.myComponent.getParent();
            }
            if ((target = NlComponent.extractId(target)) == null) continue;
            return this.myComponent.getScene().getSceneComponent(target);
        }
        return null;
    }

    private int getLeftTargetOrigin(SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf") != null) {
            origin += target.getDrawWidth();
        }
        return origin;
    }

    private int getRightTargetOrigin(SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf") != null) {
            origin += target.getDrawWidth();
        }
        return origin;
    }

    private int getTopTargetOrigin(SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf") != null) {
            origin += target.getDrawHeight();
        }
        return origin;
    }

    private int getBottomTargetOrigin(SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf") != null) {
            origin += target.getDrawHeight();
        }
        return origin;
    }

    private int getMarginValue(String attribute) {
        NlComponent nlComponent = this.myComponent.getNlComponent();
        return ConstraintComponentUtilities.getDpValue(nlComponent, nlComponent.getAttribute("http://schemas.android.com/apk/res/android", attribute));
    }

    protected void updateAttributes(AttributesTransaction attributes, int x, int y) {
        int dx;
        SceneComponent targetLeftComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ourLeftAttributes);
        SceneComponent targetRightComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ourRightAttributes);
        this.checkIsInChain();
        if (targetLeftComponent != null && targetRightComponent != null) {
            if (!this.myIsInHorizontalChain) {
                int dx2;
                float dw;
                int dx1 = this.getLeftTargetOrigin(targetLeftComponent) + this.getMarginValue("layout_marginLeft");
                float bias = (float)(x - dx1) / (dw = (float)((dx2 = this.getRightTargetOrigin(targetRightComponent) - this.getMarginValue("layout_marginRight")) - dx1 - this.myComponent.getDrawWidth()));
                if (bias < 0.0f) {
                    bias = 0.0f;
                }
                if (bias > 1.0f) {
                    bias = 1.0f;
                }
                String biasValue = null;
                if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                    biasValue = null;
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasValue);
            }
        } else if (targetLeftComponent != null) {
            dx = x - this.getLeftTargetOrigin(targetLeftComponent);
            this.applyMargin(attributes, "layout_marginLeft", dx);
        } else if (targetRightComponent != null) {
            dx = this.getRightTargetOrigin(targetRightComponent) - (x + this.myComponent.getDrawWidth());
            this.applyMargin(attributes, "layout_marginRight", dx);
        } else {
            dx = x - this.myComponent.getParent().getDrawX();
            String positionX = String.format("%ddp", dx);
            attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
        }
        SceneComponent targetTopComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ourTopAttributes);
        SceneComponent targetBottomComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ourBottomAttributes);
        if (targetTopComponent != null && targetBottomComponent != null) {
            if (!this.myIsInVerticalChain) {
                int dy2;
                float dh;
                int dy1 = this.getTopTargetOrigin(targetTopComponent) + this.getMarginValue("layout_marginTop");
                float bias = (float)(y - dy1) / (dh = (float)((dy2 = this.getBottomTargetOrigin(targetBottomComponent) - this.getMarginValue("layout_marginBottom")) - dy1 - this.myComponent.getDrawHeight()));
                if (bias < 0.0f) {
                    bias = 0.0f;
                }
                if (bias > 1.0f) {
                    bias = 1.0f;
                }
                String biasValue = null;
                if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                    biasValue = null;
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasValue);
            }
        } else if (targetTopComponent != null) {
            int dy = y - this.getTopTargetOrigin(targetTopComponent);
            this.applyMargin(attributes, "layout_marginTop", dy);
        } else if (targetBottomComponent != null) {
            int dy = this.getBottomTargetOrigin(targetBottomComponent) - (y + this.myComponent.getDrawHeight());
            this.applyMargin(attributes, "layout_marginBottom", dy);
        } else {
            int dy = y - this.myComponent.getParent().getDrawY();
            String positionY = String.format("%ddp", dy);
            attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
        }
    }

    private void applyMargin(AttributesTransaction attributes, String attribute, int currentValue) {
        String marginString = this.myComponent.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = this.getMarginValue(attribute);
        }
        if (marginValue != -1 && marginValue == currentValue) {
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValue);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myFirstMouseX = x;
        this.myFirstMouseY = y;
        this.myOffsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.myOffsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myChangedComponent = false;
        this.gatherNotches();
    }

    protected void gatherNotches() {
        this.myCurrentNotchX = null;
        this.myCurrentNotchY = null;
        this.myHorizontalNotches.clear();
        this.myVerticalNotches.clear();
        SceneComponent parent = this.myComponent.getParent();
        Notch.Provider notchProvider = parent.getNotchProvider();
        if (notchProvider != null) {
            notchProvider.fill(parent, this.myComponent, this.myHorizontalNotches, this.myVerticalNotches);
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            Notch.Provider provider;
            SceneComponent child = parent.getChild(i);
            if (child == this.myComponent || (provider = child.getNotchProvider()) == null) continue;
            provider.fill(child, this.myComponent, this.myHorizontalNotches, this.myVerticalNotches);
        }
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable Target closestTarget) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        NlComponent component = this.myComponent.getNlComponent();
        AttributesTransaction attributes = component.startAttributeTransaction();
        int dx = x - this.myOffsetX;
        int dy = y - this.myOffsetY;
        dx = this.snapX(dx);
        dy = this.snapY(dy);
        this.updateAttributes(attributes, dx, dy);
        this.cleanup(attributes);
        attributes.apply();
        component.fireLiveChangeEvent();
        this.myComponent.getScene().needsLayout(1);
        this.myChangedComponent = true;
    }

    protected int snapX(int dx) {
        int count = this.myHorizontalNotches.size();
        for (int i = 0; i < count; ++i) {
            Notch notch = this.myHorizontalNotches.get(i);
            int x = notch.apply(dx);
            if (!notch.didApply()) continue;
            this.myCurrentNotchX = notch;
            return x;
        }
        this.myCurrentNotchX = null;
        return dx;
    }

    protected int snapY(int dy) {
        int count = this.myVerticalNotches.size();
        for (int i = 0; i < count; ++i) {
            Notch notch = this.myVerticalNotches.get(i);
            int y = notch.apply(dy);
            if (!notch.didApply()) continue;
            this.myCurrentNotchY = notch;
            return y;
        }
        this.myCurrentNotchY = null;
        return dy;
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable Target closestTarget) {
        if (this.myComponent.getParent() != null) {
            boolean commitChanges = true;
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                commitChanges = false;
            }
            NlComponent component = this.myComponent.getNlComponent();
            final AttributesTransaction attributes = component.startAttributeTransaction();
            int dx = x - this.myOffsetX;
            int dy = y - this.myOffsetY;
            if (this.myCurrentNotchX != null) {
                dx = this.myCurrentNotchX.apply(dx);
                if (this.myComponent.allowsAutoConnect()) {
                    this.myCurrentNotchX.apply(attributes);
                }
                this.myCurrentNotchX = null;
            }
            if (this.myCurrentNotchY != null) {
                dy = this.myCurrentNotchY.apply(dy);
                if (this.myComponent.allowsAutoConnect()) {
                    this.myCurrentNotchY.apply(attributes);
                }
                this.myCurrentNotchY = null;
            }
            this.updateAttributes(attributes, dx, dy);
            this.cleanup(attributes);
            attributes.apply();
            if (commitChanges) {
                NlModel nlModel = component.getModel();
                Project project = nlModel.getProject();
                XmlFile file = nlModel.getFile();
                String label = "Component dragged";
                WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/target/DragTarget$1", "run"));
                        }
                        attributes.commit();
                    }
                };
                action.execute();
            }
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    public boolean hasChangedComponent() {
        return this.myChangedComponent;
    }
}

