/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalGuideline;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalGuideline;
import com.android.tools.idea.uibuilder.scene.target.DragTarget;
import org.jetbrains.annotations.NotNull;

public class GuidelineTarget
extends DragTarget {
    boolean myIsHorizontal = true;
    int myBegin = 20;
    int myEnd = -1;
    float myPercent = -1.0f;

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    public GuidelineTarget(boolean isHorizontal) {
        this.myIsHorizontal = isHorizontal;
    }

    @Override
    public int getMouseCursor() {
        if (this.myIsHorizontal) {
            return 8;
        }
        return 11;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/target/GuidelineTarget", "render"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/target/GuidelineTarget", "render"));
        }
        if (this.myIsHorizontal) {
            int y = (int)(this.myTop + (this.myBottom - this.myTop) / 2.0f);
            SceneComponent parent = this.myComponent.getParent();
            DrawHorizontalGuideline.add(list, sceneContext, this.myLeft, y, this.myRight, parent.getDrawX(), parent.getDrawY(), parent.getDrawHeight(), this.myBegin, this.myEnd, this.myPercent, this.myComponent.isSelected());
        } else {
            int x = (int)(this.myLeft + (this.myRight - this.myLeft) / 2.0f);
            SceneComponent parent = this.myComponent.getParent();
            DrawVerticalGuideline.add(list, sceneContext, x, this.myTop, this.myBottom, parent.getDrawX(), parent.getDrawY(), parent.getDrawWidth(), this.myBegin, this.myEnd, this.myPercent, this.myComponent.isSelected());
        }
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneTransform", "com/android/tools/idea/uibuilder/scene/target/GuidelineTarget", "layout"));
        }
        int dist = 6;
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            if (this.myIsHorizontal) {
                this.myLeft = parent.getDrawX();
                this.myRight = parent.getDrawX() + parent.getDrawWidth();
                this.myTop = t - dist;
                this.myBottom = t + dist;
            } else {
                this.myLeft = l - dist;
                this.myRight = l + dist;
                this.myTop = parent.getDrawY();
                this.myBottom = parent.getDrawY() + parent.getDrawHeight();
            }
        }
        NlComponent component = this.myComponent.getNlComponent();
        String begin = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        if (begin != null) {
            this.myBegin = ConstraintComponentUtilities.getDpValue(component, begin);
            this.myEnd = -1;
            this.myPercent = -1.0f;
        } else if (end != null) {
            this.myBegin = -1;
            this.myEnd = ConstraintComponentUtilities.getDpValue(component, end);
            this.myPercent = -1.0f;
        } else if (percent != null) {
            this.myBegin = -1;
            this.myEnd = -1;
            try {
                this.myPercent = Float.valueOf(percent).floatValue();
            }
            catch (NumberFormatException e) {
                this.myPercent = 0.0f;
            }
        }
        return false;
    }

    @Override
    protected void updateAttributes(AttributesTransaction attributes, int x, int y) {
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        int value = y - parent.getDrawY();
        float dimension = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value = x - parent.getDrawX();
            dimension = parent.getDrawWidth();
        }
        if (begin != null) {
            String position = String.format("%ddp", value);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        } else if (end != null) {
            String position = String.format("%ddp", (int)dimension - value);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        } else if (percent != null) {
            String percentStringValue = null;
            float percentValue = (float)value / dimension;
            if (percentValue > 1.0f) {
                percentValue = 1.0f;
            }
            if (percentValue < 0.0f) {
                percentValue = 0.0f;
            }
            if ((percentStringValue = String.valueOf(percentValue = (float)Math.round(percentValue * 100.0f) / 100.0f)).equalsIgnoreCase("NaN")) {
                percentStringValue = "0.5";
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", percentStringValue);
        }
    }
}

