/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSourceDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JTextField myNameField;
    private JTextField myUrlField;
    private JBLabel myErrorLabel;
    private RepositorySourceProvider myProvider;
    private RepositorySource myExistingSource;
    private boolean myUrlSet;

    public EditSourceDialog(@NotNull RepositorySourceProvider provider, @Nullable RepositorySource existing) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/updater/configure/EditSourceDialog", "<init>"));
        }
        super(null);
        this.myUrlSet = false;
        this.myProvider = provider;
        this.myExistingSource = existing;
        this.$$$setupUI$$$();
        this.myNameField.setText(existing == null ? "Custom Update Site" : existing.getDisplayName());
        this.myUrlField.setText(existing == null ? "http://" : existing.getUrl());
        this.setModal(true);
        this.myUrlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSourceDialog.this.myUrlSet = true;
                EditSourceDialog.this.validateUrl(EditSourceDialog.this.myUrlField.getText());
            }
        });
        this.myUrlField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditSourceDialog.this.myUrlSet = true;
                EditSourceDialog.this.validateUrl(EditSourceDialog.this.myUrlField.getText());
            }
        });
        this.myUrlField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (EditSourceDialog.this.myUrlSet) {
                    EditSourceDialog.this.validateUrl(EditSourceDialog.this.myUrlField.getText() + e.getKeyChar());
                }
            }
        });
        this.init();
    }

    private boolean validateUrl(String url) {
        String error = this.getErrorMessage(url);
        if (error == null) {
            this.myErrorLabel.setVisible(false);
            this.setOKActionEnabled(true);
            this.contentPane.repaint();
            return true;
        }
        this.myErrorLabel.setText(error);
        this.myErrorLabel.setVisible(true);
        this.setOKActionEnabled(false);
        this.contentPane.repaint();
        return false;
    }

    @Nullable
    private String getErrorMessage(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            return "URL is invalid";
        }
        if (this.myExistingSource == null) {
            for (RepositorySource s : this.myProvider.getSources(null, (ProgressIndicator)new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass()), false)) {
                if (!urlString.equalsIgnoreCase(s.getUrl())) continue;
                return "An update site with this URL already exists";
            }
        }
        return null;
    }

    public String getUiName() {
        return this.myNameField.getText();
    }

    public String getUrl() {
        return this.myUrlField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    protected void doOKAction() {
        this.myUrlSet = true;
        if (this.validateUrl(this.myUrlField.getText())) {
            super.doOKAction();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JBLabel jBLabel;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setVisible(false);
        jBLabel.setForeground(new Color(-65536));
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Please enter the Name URL of the addon.xml for the update site");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("URL:");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUrlField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

