/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.android.compiler.AndroidDexCompilerConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidDexCompilerSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final AndroidDexCompilerConfiguration myConfig;
    private final Project myProject;
    private JPanel myContentPanel;
    private JSpinner myHeapSizeSpinner;
    private JLabel myVmOptionsLabel;
    private RawCommandLineEditor myVmOptionsEditor;
    private JBCheckBox myOptimizeCheckBox;
    private JBCheckBox myJumboModeCheckBox;
    private JBCheckBox myCoreLibraryCheckBox;
    private RawCommandLineEditor myProguardVmOptionsEditor;

    public AndroidDexCompilerSettingsConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myConfig = AndroidDexCompilerConfiguration.getInstance(project);
        this.myProject = project;
        this.myVmOptionsLabel.setLabelFor((Component)this.myVmOptionsEditor);
        this.myVmOptionsEditor.setDialogCaption(AndroidBundle.message("android.dex.compiler.vm.options.title", new Object[0]));
        this.myProguardVmOptionsEditor.setDialogCaption(AndroidBundle.message("android.proguard.vm.options.title", new Object[0]));
    }

    @Nls
    public String getDisplayName() {
        return AndroidBundle.message("android.dex.compiler.configurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "settings.android.dx.compiler";
    }

    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        int maxHeapSize = (Integer)this.myHeapSizeSpinner.getValue();
        return maxHeapSize != this.myConfig.MAX_HEAP_SIZE || !this.myVmOptionsEditor.getText().equals(this.myConfig.VM_OPTIONS) || this.myOptimizeCheckBox.isSelected() != this.myConfig.OPTIMIZE || this.myJumboModeCheckBox.isSelected() != this.myConfig.FORCE_JUMBO || this.myCoreLibraryCheckBox.isSelected() != this.myConfig.CORE_LIBRARY || !this.myProguardVmOptionsEditor.getText().equals(this.myConfig.PROGUARD_VM_OPTIONS);
    }

    public void apply() throws ConfigurationException {
        try {
            this.myConfig.MAX_HEAP_SIZE = (Integer)this.myHeapSizeSpinner.getValue();
            this.myConfig.VM_OPTIONS = this.myVmOptionsEditor.getText();
            this.myConfig.OPTIMIZE = this.myOptimizeCheckBox.isSelected();
            this.myConfig.FORCE_JUMBO = this.myJumboModeCheckBox.isSelected();
            this.myConfig.CORE_LIBRARY = this.myCoreLibraryCheckBox.isSelected();
            this.myConfig.PROGUARD_VM_OPTIONS = this.myProguardVmOptionsEditor.getText();
        }
        finally {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public void reset() {
        this.myHeapSizeSpinner.setModel(new SpinnerNumberModel(this.myConfig.MAX_HEAP_SIZE, 1, 10000000, 1));
        this.myVmOptionsEditor.setText(this.myConfig.VM_OPTIONS);
        this.myOptimizeCheckBox.setSelected(this.myConfig.OPTIMIZE);
        this.myJumboModeCheckBox.setSelected(this.myConfig.FORCE_JUMBO);
        this.myCoreLibraryCheckBox.setSelected(this.myConfig.CORE_LIBRARY);
        this.myProguardVmOptionsEditor.setText(this.myConfig.PROGUARD_VM_OPTIONS);
    }

    @NotNull
    public String getId() {
        if ("android.dex.compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidDexCompilerSettingsConfigurable", "getId"));
        }
        return "android.dex.compiler";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        RawCommandLineEditor rawCommandLineEditor;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JSpinner jSpinner;
        RawCommandLineEditor rawCommandLineEditor2;
        JLabel jLabel;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndentWithoutInsets");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"DEX", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Maximum heap size (MB):");
        jLabel2.setDisplayedMnemonic('M');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myVmOptionsLabel = jLabel = new JLabel();
        jLabel.setText("Additional VM options:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVmOptionsEditor = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor2, new GridConstraints(1, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myHeapSizeSpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(100, -1), null));
        this.myOptimizeCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Optimize");
        jBCheckBox3.setMnemonic('O');
        jBCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myJumboModeCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Force jumbo mode");
        jBCheckBox2.setMnemonic('J');
        jBCheckBox2.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myCoreLibraryCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Add \"--core-library\" flag");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndentWithoutInsets");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"ProGuard", (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("VM options:");
        jBLabel.setDisplayedMnemonic('V');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myProguardVmOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        jLabel2.setLabelFor(jSpinner);
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

