/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import org.jetbrains.android.inspections.FloatRangeConstraint;
import org.jetbrains.android.inspections.RangeAllowedValues;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntRangeConstraint
extends RangeAllowedValues {
    final long from;
    final long to;

    public IntRangeConstraint(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/IntRangeConstraint", "<init>"));
        }
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
        this.from = ResourceTypeInspection.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
        this.to = ResourceTypeInspection.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
    }

    IntRangeConstraint(long from, long to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public ResourceTypeInspection.InspectionResult isValid(@NotNull PsiExpression argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/IntRangeConstraint", "isValid"));
        }
        Number literalValue = this.guessSize(argument);
        if (literalValue != null) {
            long value = literalValue.longValue();
            return value >= this.from && value <= this.to ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalid(argument);
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    @Override
    @NotNull
    public String describe(@Nullable PsiExpression argument) {
        Number actual;
        StringBuilder sb = new StringBuilder(20);
        if (this.to == Long.MAX_VALUE) {
            sb.append("Value must be \u2265 ");
            sb.append(Long.toString(this.from));
        } else if (this.from == Long.MIN_VALUE) {
            sb.append("Value must be \u2264 ");
            sb.append(Long.toString(this.to));
        } else {
            sb.append("Value must be \u2265 ");
            sb.append(Long.toString(this.from));
            sb.append(" and \u2264 ");
            sb.append(Long.toString(this.to));
        }
        if (argument != null && (actual = this.guessSize(argument)) != null) {
            sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/IntRangeConstraint", "describe"));
        }
        return string;
    }

    public String toString() {
        return this.describe(null);
    }

    @Override
    public ResourceTypeInspection.InspectionResult contains(@NotNull RangeAllowedValues other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/IntRangeConstraint", "contains"));
        }
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            return otherRange.from >= this.from && otherRange.to <= this.to ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
        }
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            if (!otherRange.fromInclusive && otherRange.from == (double)this.from) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (!otherRange.toInclusive && otherRange.to == (double)this.to) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            return otherRange.from >= (double)this.from && otherRange.to <= (double)this.to ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }
}

