/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.layoutlib.bridge.MockView;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.util.Pair;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLoader {
    private static final Logger LOG = Logger.getInstance(ViewLoader.class);
    private static final int ALLOWED_NESTED_VIEWS = 100;
    @NotNull
    private final Module myModule;
    @NotNull
    private final Map<String, Class<?>> myLoadedClasses;
    @NotNull
    private final Multiset<Class<?>> myLoadingClasses;
    @NotNull
    private final Set<String> myRecentlyModifiedClasses;
    @Nullable
    private final Object myCredential;
    @NotNull
    private final LayoutLibrary myLayoutLibrary;
    @Nullable
    private RenderLogger myLogger;
    @Nullable
    private ModuleClassLoader myModuleClassLoader;

    public ViewLoader(@NotNull LayoutLibrary layoutLib, @NotNull AndroidFacet facet, @NotNull RenderLogger logger, @Nullable Object credential) {
        if (layoutLib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutLib", "org/jetbrains/android/uipreview/ViewLoader", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/uipreview/ViewLoader", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "org/jetbrains/android/uipreview/ViewLoader", "<init>"));
        }
        this.myLoadedClasses = Maps.newHashMap();
        this.myLoadingClasses = HashMultiset.create((int)5);
        this.myRecentlyModifiedClasses = Sets.newHashSetWithExpectedSize((int)5);
        this.myLayoutLibrary = layoutLib;
        this.myModule = facet.getModule();
        this.myLogger = logger;
        this.myCredential = credential;
    }

    public void setLogger(@Nullable RenderLogger logger) {
        this.myLogger = logger;
    }

    @Nullable
    private static String getRClassName(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ViewLoader", "getRClassName"));
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ViewLoader", "lambda$getRClassName$0"));
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            Manifest manifest = facet.getManifest();
            if (manifest == null) {
                return null;
            }
            String packageName = (String)manifest.getPackage().getValue();
            return packageName == null ? null : packageName + '.' + "R";
        });
    }

    private static boolean parseClass(@NotNull Class<?> rClass, @NotNull TIntObjectHashMap<Pair<ResourceType, String>> id2res, @NotNull Map<IntArrayWrapper, String> styleableId2Res, @NotNull Map<ResourceType, TObjectIntHashMap<String>> res2id) throws ClassNotFoundException {
        if (rClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rClass", "org/jetbrains/android/uipreview/ViewLoader", "parseClass"));
        }
        if (id2res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id2res", "org/jetbrains/android/uipreview/ViewLoader", "parseClass"));
        }
        if (styleableId2Res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableId2Res", "org/jetbrains/android/uipreview/ViewLoader", "parseClass"));
        }
        if (res2id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res2id", "org/jetbrains/android/uipreview/ViewLoader", "parseClass"));
        }
        try {
            Class<?>[] nestedClasses;
            try {
                nestedClasses = rClass.getDeclaredClasses();
            }
            catch (LinkageError e) {
                Throwable cause = e.getCause();
                LOG.debug((Throwable)e);
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                throw e;
            }
            for (Class<?> resClass : nestedClasses) {
                ResourceType resType = ResourceType.getEnum((String)resClass.getSimpleName());
                if (resType == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(String.format("  '%s' is not a valid resource type", LogAnonymizerUtil.anonymizeClassName(resClass.getSimpleName())));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  Defining resource type '%s'", LogAnonymizerUtil.anonymizeClassName(resClass.getSimpleName())));
                }
                TObjectIntHashMap resName2Id = new TObjectIntHashMap();
                res2id.put(resType, (TObjectIntHashMap<String>)resName2Id);
                for (Field field : resClass.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers())) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(String.format("  '%s' field is not static, skipping", field.getName()));
                        continue;
                    }
                    Class<?> type = field.getType();
                    if (type.isArray() && type.getComponentType() == Integer.TYPE) {
                        styleableId2Res.put(new IntArrayWrapper((int[])field.get(null)), field.getName());
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(String.format("  '%s' defined as int[]", field.getName()));
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        Integer value = (Integer)field.get(null);
                        id2res.put(value.intValue(), (Object)Pair.of((Object)resType, (Object)field.getName()));
                        resName2Id.put((Object)field.getName(), value.intValue());
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(String.format("  '%s' defined as int", field.getName()));
                        continue;
                    }
                    LOG.error("Unknown field type in R class: " + type);
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.info((Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    public Object loadClass(String className, Class<?>[] constructorSignature, Object[] constructorArgs) throws ClassNotFoundException {
        if ("android.support.v7.widget.RecyclerView$Adapter".equals(className)) {
            className = "com.android.layoutlib.bridge.android.support.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return this.loadClass(className, constructorSignature, constructorArgs, false);
    }

    @Nullable
    public Object loadView(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "loadView"));
        }
        Object aClass = this.loadClass(className, constructorSignature, constructorArgs, true);
        if (aClass != null) {
            return aClass;
        }
        try {
            Object o = this.createViewFromSuperclass(className, constructorSignature, constructorArgs);
            if (o != null) {
                return o;
            }
            return this.createMockView(className, constructorSignature, constructorArgs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException(className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object loadClass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs, boolean isView) {
        block17: {
            Object object;
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "loadClass"));
            }
            assert (this.myLogger != null);
            Class<?> aClass = this.myLoadedClasses.get(className);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("loadClassA(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
            }
            if (aClass != null) {
                this.checkModified(className);
                return this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
            }
            aClass = this.loadClass(className, isView);
            if (aClass == null) break block17;
            this.checkModified(className);
            if (this.myLoadingClasses.count(aClass) > 100) {
                throw new InstantiationException("The layout involves creation of " + className + " over " + 100 + " levels deep. Infinite recursion?");
            }
            this.myLoadingClasses.add(aClass);
            try {
                Object viewObject = this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
                this.myLoadedClasses.put(className, aClass);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  instance created");
                }
                object = viewObject;
            }
            catch (Throwable throwable) {
                try {
                    this.myLoadingClasses.remove(aClass);
                    throw throwable;
                }
                catch (InconvertibleClassError e) {
                    this.myLogger.addIncorrectFormatClass(e.getClassName(), e);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    break block17;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e);
                    }
                    this.myLogger.addBrokenClass(className, e);
                    break block17;
                }
                catch (InvocationTargetException e) {
                    Throwable cause;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    if ((cause = e.getCause()) instanceof InconvertibleClassError) {
                        InconvertibleClassError error = (InconvertibleClassError)cause;
                        this.myLogger.addIncorrectFormatClass(error.getClassName(), error);
                        break block17;
                    }
                    this.myLogger.addBrokenClass(className, cause);
                }
            }
            this.myLoadingClasses.remove(aClass);
            return object;
        }
        return null;
    }

    @NotNull
    private ModuleClassLoader getModuleClassLoader() {
        if (this.myModuleClassLoader == null) {
            boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
            try {
                this.myModuleClassLoader = ModuleClassLoader.get(this.myLayoutLibrary, this.myModule);
            }
            finally {
                RenderSecurityManager.exitSafeRegion(token);
            }
        }
        ModuleClassLoader moduleClassLoader = this.myModuleClassLoader;
        if (moduleClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getModuleClassLoader"));
        }
        return moduleClassLoader;
    }

    private void checkModified(@NotNull String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "org/jetbrains/android/uipreview/ViewLoader", "checkModified"));
        }
        if (DumbService.getInstance((Project)this.myModule.getProject()).isDumb()) {
            return;
        }
        if (this.myModuleClassLoader != null && this.myModuleClassLoader.isSourceModified(fqcn, this.myCredential) && !this.myRecentlyModifiedClasses.contains(fqcn)) {
            assert (this.myLogger != null);
            this.myRecentlyModifiedClasses.add(fqcn);
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            HtmlBuilder builder = problem.getHtmlBuilder();
            String className = fqcn.substring(fqcn.lastIndexOf(46) + 1);
            builder.addLink("The " + className + " custom view has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createBuildProjectUrl());
            this.myLogger.addMessage(problem);
        }
    }

    @NotNull
    private MockView createMockView(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        String label;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "createMockView"));
        }
        MockView mockView = (MockView)this.createNewInstance(MockView.class, constructorSignature, constructorArgs, true);
        switch (label = ViewLoader.getShortClassName(className)) {
            case "fragment": {
                label = "<fragment>";
                break;
            }
            case "include": {
                label = "Text";
            }
        }
        mockView.setText((CharSequence)label);
        mockView.setGravity(17);
        MockView mockView2 = mockView;
        if (mockView2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "createMockView"));
        }
        return mockView2;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getModule"));
        }
        return module;
    }

    @NotNull
    static String getShortClassName(@NotNull String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "org/jetbrains/android/uipreview/ViewLoader", "getShortClassName"));
        }
        int first = fqcn.indexOf(46);
        int last = fqcn.lastIndexOf(46);
        if (fqcn.startsWith("android.")) {
            if (last > first) {
                String string = fqcn.substring(0, first) + ".." + fqcn.substring(last);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getShortClassName"));
                }
                return string;
            }
        } else if (last > (first = fqcn.indexOf(46, first + 1)) && first >= 0) {
            String string = fqcn.substring(0, first) + ".." + fqcn.substring(last);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getShortClassName"));
            }
            return string;
        }
        String string = fqcn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getShortClassName"));
        }
        return string;
    }

    @NotNull
    private Object createNewInstance(@NotNull Class<?> clazz, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorParameters, boolean isView) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        block13: {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/android/uipreview/ViewLoader", "createNewInstance"));
            }
            constructor = null;
            try {
                constructor = clazz.getConstructor(constructorSignature);
            }
            catch (NoSuchMethodException e) {
                int paramsCount;
                if (!isView) {
                    throw e;
                }
                int n = paramsCount = constructorSignature != null ? constructorSignature.length : 0;
                if (paramsCount == 0) {
                    throw e;
                }
                assert (constructorParameters != null);
                for (int i = 3; i >= 1; --i) {
                    if (i == paramsCount) continue;
                    int k = paramsCount < i ? paramsCount : i;
                    Class[] sig = new Class[i];
                    System.arraycopy(constructorSignature, 0, sig, 0, k);
                    Object[] params = new Object[i];
                    System.arraycopy(constructorParameters, 0, params, 0, k);
                    for (int j = k + 1; j <= i; ++j) {
                        if (j == 2) {
                            sig[j - 1] = clazz.getClassLoader().loadClass("android.util.AttributeSet");
                            params[j - 1] = null;
                            continue;
                        }
                        if (j != 3) continue;
                        sig[j - 1] = Integer.TYPE;
                        params[j - 1] = 0;
                    }
                    constructorSignature = sig;
                    constructorParameters = params;
                    try {
                        constructor = clazz.getConstructor(constructorSignature);
                        if (constructor == null) continue;
                        if (constructorSignature.length >= 2) break;
                        assert (this.myLogger != null);
                        LOG.info("wrong_constructor: Custom view " + clazz.getSimpleName() + " is not using the 2- or 3-argument View constructors; XML attributes will not work");
                        this.myLogger.warning("wrongconstructor", String.format("Custom view %1$s is not using the 2- or 3-argument View constructors; XML attributes will not work", clazz.getSimpleName()), null);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (constructor != null) break block13;
                throw e;
            }
        }
        constructor.setAccessible(true);
        Object obj = constructor.newInstance(constructorParameters);
        if (obj == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "createNewInstance"));
        }
        return obj;
    }

    @Nullable
    public Class<?> loadClass(@NotNull String className, boolean logError) throws InconvertibleClassError {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "loadClass"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassB(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        try {
            return this.getModuleClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (logError && !className.equals("fragment")) {
                assert (this.myLogger != null);
                this.myLogger.addMissingClass(className);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object createViewFromSuperclass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "createViewFromSuperclass"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("createViewFromSuperClass(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        Ref token = new Ref();
        token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
        try {
            Object object = ApplicationManager.getApplication().runReadAction(() -> {
                if (className == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "lambda$createViewFromSuperclass$1"));
                }
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
                PsiClass psiClass = facade.findClass(className, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
                if (psiClass == null) {
                    return null;
                }
                HashSet visited = new HashSet();
                for (psiClass = psiClass.getSuperClass(); psiClass != null; psiClass = psiClass.getSuperClass()) {
                    Object object;
                    String qName = psiClass.getQualifiedName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  parent " + LogAnonymizerUtil.anonymizeClassName(qName));
                    }
                    if (qName == null || !visited.add(qName) || "android.view.View".equals(psiClass.getQualifiedName())) break;
                    if (AndroidUtils.isAbstract(psiClass)) continue;
                    Class<?> aClass = this.myLoadedClasses.get(qName);
                    if (aClass == null && this.myLayoutLibrary.getClassLoader() != null && (aClass = this.myLayoutLibrary.getClassLoader().loadClass(qName)) != null) {
                        this.myLoadedClasses.put(qName, aClass);
                    }
                    if (aClass == null) continue;
                    try {
                        RenderSecurityManager.exitSafeRegion((Boolean)token.get());
                        object = this.createNewInstance(aClass, constructorSignature, constructorArgs, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                            throw throwable;
                        }
                        catch (Throwable e) {
                            LOG.debug(e);
                        }
                    }
                    token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                    return object;
                }
                return null;
            });
            return object;
        }
        finally {
            RenderSecurityManager.exitSafeRegion((Boolean)token.get());
        }
    }

    public void loadAndParseRClassSilently() {
        assert (this.myLogger != null);
        String rClassName = ViewLoader.getRClassName(this.myModule);
        try {
            if (rClassName == null) {
                LOG.info(String.format("loadAndParseRClass: failed to find manifest package for project %1$s", this.myModule.getProject().getName()));
                return;
            }
            this.myLogger.setResourceClass(rClassName);
            this.loadAndParseRClass(rClassName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.myLogger.setMissingResourceClass(true);
        }
        catch (InconvertibleClassError e) {
            assert (rClassName != null);
            this.myLogger.addIncorrectFormatClass(rClassName, e);
        }
    }

    void loadAndParseRClass(@NotNull String className) throws ClassNotFoundException, InconvertibleClassError {
        EnumMap<ResourceType, TObjectIntHashMap<String>> res2id;
        HashMap<IntArrayWrapper, String> styleableId2res;
        TIntObjectHashMap id2res;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "loadAndParseRClass"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        Class<?> aClass = this.myLoadedClasses.get(className);
        AppResourceRepository appResources = AppResourceRepository.getAppResources(this.myModule, true);
        if (aClass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  The R class is not loaded.");
            }
            ModuleClassLoader moduleClassLoader = this.getModuleClassLoader();
            boolean isClassLoaded = moduleClassLoader.isClassLoaded(className);
            aClass = moduleClassLoader.loadClass(className);
            if (!isClassLoaded && aClass != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  Class found in module %s, first time load.", LogAnonymizerUtil.anonymize(this.myModule)));
                }
                this.myLoadedClasses.clear();
                ModuleClassLoader.clearCache(this.myModule);
                this.myModuleClassLoader = null;
                aClass = this.getModuleClassLoader().loadClass(className);
                if (appResources != null) {
                    appResources.resetDynamicIds(true);
                }
            } else if (LOG.isDebugEnabled() && isClassLoaded) {
                LOG.debug(String.format("  Class already loaded in module %s.", LogAnonymizerUtil.anonymize(this.myModule)));
            }
            if (aClass != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Class loaded");
                }
                assert (this.myLogger != null);
                this.myLoadedClasses.put(className, aClass);
                this.myLogger.setHasLoadedClasses(true);
            }
        }
        if (aClass != null && ViewLoader.parseClass(aClass, (TIntObjectHashMap<Pair<ResourceType, String>>)(id2res = new TIntObjectHashMap()), styleableId2res = new HashMap<IntArrayWrapper, String>(), res2id = new EnumMap<ResourceType, TObjectIntHashMap<String>>(ResourceType.class)) && appResources != null) {
            appResources.setCompiledResources((TIntObjectHashMap<Pair<ResourceType, String>>)id2res, styleableId2res, res2id);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("END loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
    }
}

