/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgBranchManager;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgCommonBranchActions
extends BranchActionGroup {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final HgBranchManager myBranchManager;
    @NotNull
    protected final String myBranchName;
    @NotNull
    protected final List<HgRepository> myRepositories;
    @Nullable
    private final HgBranchType myBranchType;

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        this(project, repositories, branchName, null);
    }

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName, @Nullable HgBranchType branchType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRepositories = repositories;
        this.myBranchManager = (HgBranchManager)((Object)ServiceManager.getService((Project)project, HgBranchManager.class));
        this.getTemplatePresentation().setText(this.myBranchName, false);
        this.myBranchType = branchType;
        this.setFavorite(this.myBranchManager.isFavorite(this.myBranchType, HgCommonBranchActions.chooseRepository(this.myRepositories), this.myBranchName));
        this.hideIconForUnnamedHeads();
    }

    private void hideIconForUnnamedHeads() {
        if (this.myBranchType == null) {
            this.getTemplatePresentation().setIcon(null);
            this.getTemplatePresentation().setHoveredIcon(null);
        }
    }

    @Nullable
    private static Repository chooseRepository(@NotNull List<HgRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "chooseRepository"));
        }
        assert (!repositories.isEmpty());
        return repositories.size() > 1 ? null : (Repository)repositories.get(0);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new UpdateAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName)};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "getChildren"));
        }
        return anActionArray;
    }

    public void toggle() {
        super.toggle();
        this.myBranchManager.setFavorite(this.myBranchType, HgCommonBranchActions.chooseRepository(this.myRepositories), this.myBranchName, this.isFavorite());
    }

    private static class UpdateAction
    extends HgBranchAbstractAction {
        public UpdateAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            super(project, "Update", repositories, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            HgUpdateCommand.updateTo(this.myBranchName, this.myRepositories, null);
        }
    }

    private static class MergeAction
    extends HgBranchAbstractAction {
        public MergeAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction", "<init>"));
            }
            super(project, "Merge", repositories, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            UpdatedFiles updatedFiles = UpdatedFiles.create();
            for (HgRepository repository : this.myRepositories) {
                HgMergeCommand.mergeWith(repository, this.myBranchName, updatedFiles);
            }
        }
    }
}

