/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HgCommandResult {
    public static final HgCommandResult CANCELLED = new HgCommandResult(new ProcessOutput(1));
    @NotNull
    private final ProcessOutput myProcessOutput;
    @NotNull
    private final byte[] myByteArrayOutput;

    public HgCommandResult(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutput", "org/zmlx/hg4idea/execution/HgCommandResult", "<init>"));
        }
        this(processOutput, ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public HgCommandResult(@NotNull ProcessOutput processOutput, @NotNull byte[] byteArrayOutput) {
        if (processOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutput", "org/zmlx/hg4idea/execution/HgCommandResult", "<init>"));
        }
        if (byteArrayOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteArrayOutput", "org/zmlx/hg4idea/execution/HgCommandResult", "<init>"));
        }
        this.myProcessOutput = processOutput;
        this.myByteArrayOutput = byteArrayOutput;
    }

    @NotNull
    public List<String> getOutputLines() {
        List list = this.myProcessOutput.getStdoutLines();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandResult", "getOutputLines"));
        }
        return list;
    }

    @NotNull
    public List<String> getErrorLines() {
        List list = this.myProcessOutput.getStderrLines();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandResult", "getErrorLines"));
        }
        return list;
    }

    @NotNull
    public String getRawOutput() {
        String string = this.myProcessOutput.getStdout();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandResult", "getRawOutput"));
        }
        return string;
    }

    @NotNull
    public String getRawError() {
        String string = this.myProcessOutput.getStderr();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandResult", "getRawError"));
        }
        return string;
    }

    @NotNull
    public byte[] getBytesOutput() {
        if (this.myByteArrayOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandResult", "getBytesOutput"));
        }
        return this.myByteArrayOutput;
    }

    public int getExitValue() {
        return this.myProcessOutput.getExitCode();
    }
}

