/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormEditorErrorCollector
extends FormErrorCollector {
    private final GuiEditor myEditor;
    @NotNull
    private final RadComponent myComponent;
    private List<ErrorInfo> myResults;
    private final InspectionProfile myProfile;
    private final PsiFile myFormPsiFile;

    FormEditorErrorCollector(GuiEditor editor, @NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/FormEditorErrorCollector", "<init>"));
        }
        this.myEditor = editor;
        this.myComponent = component;
        this.myFormPsiFile = PsiManager.getInstance((Project)editor.getProject()).findFile(editor.getFile());
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)editor.getProject());
        this.myProfile = profileManager.getCurrentProfile();
    }

    public ErrorInfo[] result() {
        return this.myResults == null ? null : this.myResults.toArray(new ErrorInfo[this.myResults.size()]);
    }

    @Override
    public void addError(@NotNull String inspectionId, @NotNull IComponent component, @Nullable IProperty prop, @NotNull String errorMessage, EditorQuickFixProvider ... editorQuickFixProviders) {
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/uiDesigner/inspections/FormEditorErrorCollector", "addError"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/FormEditorErrorCollector", "addError"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/uiDesigner/inspections/FormEditorErrorCollector", "addError"));
        }
        if (editorQuickFixProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorQuickFixProviders", "com/intellij/uiDesigner/inspections/FormEditorErrorCollector", "addError"));
        }
        if (this.myResults == null) {
            this.myResults = new ArrayList<ErrorInfo>();
        }
        ArrayList<QuickFix> quickFixes = new ArrayList<QuickFix>();
        for (EditorQuickFixProvider provider : editorQuickFixProviders) {
            if (provider == null) continue;
            quickFixes.add(provider.createQuickFix(this.myEditor, this.myComponent));
        }
        ErrorInfo errorInfo = new ErrorInfo(this.myComponent, prop == null ? null : prop.getName(), errorMessage, this.myProfile.getErrorLevel(HighlightDisplayKey.find((String)inspectionId), (PsiElement)this.myFormPsiFile), quickFixes.toArray(new QuickFix[quickFixes.size()]));
        errorInfo.setInspectionId(inspectionId);
        this.myResults.add(errorInfo);
    }
}

