/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeChangeCollector {
    private final HashSet<String> myUnmergedPaths = new HashSet();
    private final Project myProject;
    private final VirtualFile myRoot;
    private final GitRevisionNumber myStart;
    @NotNull
    private final GitRepository myRepository;

    public MergeChangeCollector(Project project, VirtualFile root, GitRevisionNumber start) {
        this.myStart = start;
        this.myProject = project;
        this.myRoot = root;
        this.myRepository = (GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root));
    }

    public void collect(UpdatedFiles updates, List<VcsException> exceptions) {
        try {
            Set<String> paths = this.getUnmergedPaths();
            MergeChangeCollector.addAll(updates, "MERGED_WITH_CONFLICTS", paths);
            TreeSet<String> updated = new TreeSet<String>();
            TreeSet<String> created = new TreeSet<String>();
            TreeSet<String> removed = new TreeSet<String>();
            String revisionsForDiff = this.getRevisionsForDiff();
            if (revisionsForDiff == null) {
                return;
            }
            this.getChangedFilesExceptUnmerged(updated, created, removed, revisionsForDiff);
            MergeChangeCollector.addAll(updates, "UPDATED", updated);
            MergeChangeCollector.addAll(updates, "CREATED", created);
            MergeChangeCollector.addAll(updates, "REMOVED_FROM_REPOSITORY", removed);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    @NotNull
    public Set<String> getUnmergedPaths() throws VcsException {
        String root = this.myRoot.getPath();
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--unmerged");
        String result2 = h.run();
        HashSet<String> paths = new HashSet<String>();
        StringScanner s = new StringScanner(result2);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            if (!this.myUnmergedPaths.add(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            paths.add(path);
        }
        HashSet<String> hashSet = paths;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/merge/MergeChangeCollector", "getUnmergedPaths"));
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getRevisionsForDiff() throws VcsException {
        String root = this.myRoot.getPath();
        GitRevisionNumber currentHead = GitRevisionNumber.resolve(this.myProject, this.myRoot, "HEAD");
        if (!currentHead.equals(this.myStart)) return this.myStart.getRev() + "..HEAD";
        File mergeHeadsFile = this.myRepository.getRepositoryFiles().getMergeHeadFile();
        try {
            if (!mergeHeadsFile.exists()) return null;
            String mergeHeads = new String(FileUtil.loadFileText((File)mergeHeadsFile, (String)"UTF-8"));
            StringScanner s = new StringScanner(mergeHeads);
            while (s.hasMoreData()) {
                String head = s.line();
                if (head.length() == 0) continue;
                return this.myStart.getRev() + "..." + head;
            }
            return null;
        }
        catch (IOException e) {
            throw new VcsException("Unable to read the file " + mergeHeadsFile + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void getChangedFilesExceptUnmerged(Collection<String> updated, Collection<String> created, Collection<String> removed, String revisions) throws VcsException {
        if (revisions == null) {
            return;
        }
        String root = this.myRoot.getPath();
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.DIFF);
        h.setSilent(true);
        h.addParameters("--name-status", "--diff-filter=ADMRUX", "--no-renames", revisions);
        StringScanner s = new StringScanner(h.run());
        block5: while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            char status = s.peek();
            s.boundedToken('\t');
            String relative = s.line();
            if (this.myUnmergedPaths.contains(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            switch (status) {
                case 'M': {
                    updated.add(path);
                    continue block5;
                }
                case 'A': {
                    created.add(path);
                    continue block5;
                }
                case 'D': {
                    removed.add(path);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected status: " + status);
        }
    }

    private static void addAll(UpdatedFiles updates, String group_id, Set<String> paths) {
        FileGroup fileGroup = updates.getGroupById(group_id);
        VcsKey vcsKey = GitVcs.getKey();
        for (String path : paths) {
            fileGroup.add(path, vcsKey, null);
        }
    }
}

