/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class GitRebaseUnstructuredEditor
extends DialogWrapper {
    @NotNull
    private final JBLabel myRootLabel;
    @NotNull
    private final CommitMessage myTextEditor;

    GitRebaseUnstructuredEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull String initialText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUnstructuredEditor", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaseUnstructuredEditor", "<init>"));
        }
        if (initialText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "git4idea/rebase/GitRebaseUnstructuredEditor", "<init>"));
        }
        super(project, true);
        this.setTitle(GitBundle.message("rebase.unstructured.editor.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("rebase.unstructured.editor.button", new Object[0]));
        this.myRootLabel = new JBLabel("Git Root: " + root.getPresentableUrl());
        this.myTextEditor = new CommitMessage(project, false, false, false);
        this.myTextEditor.setText(initialText);
        this.myTextEditor.getEditorField().setCaretPosition(0);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        BorderLayoutPanel rootPanel = JBUI.Panels.simplePanel((int)10, (int)4);
        rootPanel.addToTop((Component)this.myRootLabel);
        rootPanel.addToCenter((Component)this.myTextEditor);
        BorderLayoutPanel borderLayoutPanel = rootPanel;
        if (borderLayoutPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUnstructuredEditor", "createCenterPanel"));
        }
        return borderLayoutPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTextEditor.getEditorField().getFocusTarget();
    }

    @NotNull
    String getText() {
        String string = this.myTextEditor.getComment();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUnstructuredEditor", "getText"));
        }
        return string;
    }
}

