/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitTask;
import git4idea.commands.GitTaskResultHandlerAdapter;
import git4idea.commands.GitTaskResultNotificationHandler;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseUtils;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaser {
    private static final Logger LOG = Logger.getInstance(GitRebaser.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private GitVcs myVcs;
    @NotNull
    private ProgressIndicator myProgressIndicator;
    @NotNull
    private List<GitRebaseUtils.CommitInfo> mySkippedCommits;

    public GitRebaser(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaser", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/rebase/GitRebaser", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/rebase/GitRebaser", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = progressIndicator;
        this.myVcs = GitVcs.getInstance(project);
        this.mySkippedCommits = new ArrayList<GitRebaseUtils.CommitInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitUpdateResult rebase(@NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable Runnable onCancel, @Nullable GitLineHandlerListener lineListener) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "rebase"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/rebase/GitRebaser", "rebase"));
        }
        GitLineHandler rebaseHandler = this.createHandler(root);
        rebaseHandler.setStdoutSuppressed(false);
        rebaseHandler.addParameters(parameters);
        if (lineListener != null) {
            rebaseHandler.addLineListener(lineListener);
        }
        GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
        rebaseHandler.addLineListener(rebaseConflictDetector);
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
        GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
        rebaseHandler.addLineListener(untrackedFilesDetector);
        rebaseHandler.addLineListener(localChangesDetector);
        rebaseHandler.addLineListener(GitStandardProgressAnalyzer.createListener(this.myProgressIndicator));
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            String oldText = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText("Rebasing...");
            GitCommandResult result2 = this.myGit.runCommand(rebaseHandler);
            this.myProgressIndicator.setText(oldText);
            GitUpdateResult gitUpdateResult = result2.success() ? GitUpdateResult.SUCCESS : this.handleRebaseFailure(rebaseHandler, root, result2, rebaseConflictDetector, untrackedFilesDetector, localChangesDetector);
            return gitUpdateResult;
        }
        catch (ProcessCanceledException pce) {
            if (onCancel != null) {
                onCancel.run();
            }
            GitUpdateResult gitUpdateResult = GitUpdateResult.CANCEL;
            return gitUpdateResult;
        }
        finally {
            token.finish();
        }
    }

    protected GitLineHandler createHandler(VirtualFile root) {
        return new GitLineHandler(this.myProject, root, GitCommand.REBASE);
    }

    public void abortRebase(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "abortRebase"));
        }
        LOG.info("abortRebase " + root);
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.setStdoutSuppressed(false);
        rh.addParameters("--abort");
        GitTask task = new GitTask(this.myProject, rh, "Aborting rebase");
        task.setProgressIndicator(this.myProgressIndicator);
        task.executeAsync(new GitTaskResultNotificationHandler(this.myProject, "Rebase aborted", "Abort rebase cancelled", "Error aborting rebase"));
    }

    public boolean continueRebase(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "continueRebase"));
        }
        return this.continueRebase(root, "--continue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean continueRebase(@NotNull Collection<VirtualFile> rebasingRoots) {
        if (rebasingRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebasingRoots", "git4idea/rebase/GitRebaser", "continueRebase"));
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            boolean success = true;
            for (VirtualFile root : rebasingRoots) {
                success &= this.continueRebase(root);
            }
            boolean bl = success;
            return bl;
        }
        finally {
            token.finish();
        }
    }

    private boolean continueRebase(@NotNull VirtualFile root, @NotNull String startOperation) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "continueRebase"));
        }
        if (startOperation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startOperation", "git4idea/rebase/GitRebaser", "continueRebase"));
        }
        LOG.info("continueRebase " + root + " " + startOperation);
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.setStdoutSuppressed(false);
        rh.addParameters(startOperation);
        GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
        rh.addLineListener(rebaseConflictDetector);
        this.makeContinueRebaseInteractiveEditor(root, rh);
        GitTask rebaseTask = new GitTask(this.myProject, rh, "git rebase " + startOperation);
        rebaseTask.setProgressAnalyzer(new GitStandardProgressAnalyzer());
        rebaseTask.setProgressIndicator(this.myProgressIndicator);
        return this.executeRebaseTaskInBackground(root, rh, rebaseConflictDetector, rebaseTask);
    }

    protected void makeContinueRebaseInteractiveEditor(VirtualFile root, GitLineHandler rh) {
        GitRebaseEditorService rebaseEditorService = GitRebaseEditorService.getInstance();
        TrivialEditor editor = new TrivialEditor(rebaseEditorService, this.myProject, root);
        UUID rebaseEditorNo = editor.getHandlerNo();
        rebaseEditorService.configureHandler(rh, rebaseEditorNo);
    }

    @NotNull
    public Collection<VirtualFile> getRebasingRoots() {
        HashSet<VirtualFile> rebasingRoots = new HashSet<VirtualFile>();
        for (VirtualFile root : ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)this.myVcs)) {
            if (!GitRebaseUtils.isRebaseInTheProgress(this.myProject, root)) continue;
            rebasingRoots.add(root);
        }
        HashSet<VirtualFile> hashSet = rebasingRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaser", "getRebasingRoots"));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reoderCommitsIfNeeded(@NotNull VirtualFile root, @NotNull String parentCommit, @NotNull List<String> olderCommits) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "reoderCommitsIfNeeded"));
        }
        if (parentCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCommit", "git4idea/rebase/GitRebaser", "reoderCommitsIfNeeded"));
        }
        if (olderCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "olderCommits", "git4idea/rebase/GitRebaser", "reoderCommitsIfNeeded"));
        }
        ArrayList allCommits = new ArrayList();
        if (olderCommits.isEmpty() || olderCommits.size() == allCommits.size()) {
            LOG.info("Nothing to reorder. olderCommits: " + olderCommits + " allCommits: " + allCommits);
            return true;
        }
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        h.setStdoutSuppressed(false);
        UUID rebaseEditorNo = null;
        GitRebaseEditorService rebaseEditorService = GitRebaseEditorService.getInstance();
        try {
            h.addParameters("-i", "-m", "-v");
            h.addParameters(parentCommit);
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            h.addLineListener(rebaseConflictDetector);
            PushRebaseEditor pushRebaseEditor = new PushRebaseEditor(rebaseEditorService, root, olderCommits, false);
            rebaseEditorNo = pushRebaseEditor.getHandlerNo();
            rebaseEditorService.configureHandler(h, rebaseEditorNo);
            GitTask rebaseTask = new GitTask(this.myProject, h, "Reordering commits");
            rebaseTask.setProgressIndicator(this.myProgressIndicator);
            boolean bl = this.executeRebaseTaskInBackground(root, h, rebaseConflictDetector, rebaseTask);
            if (rebaseEditorNo != null) {
                rebaseEditorService.unregisterHandler(rebaseEditorNo);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (rebaseEditorNo != null) {
                rebaseEditorService.unregisterHandler(rebaseEditorNo);
            }
            throw throwable;
        }
    }

    private boolean executeRebaseTaskInBackground(VirtualFile root, GitLineHandler h, GitRebaseProblemDetector rebaseConflictDetector, GitTask rebaseTask) {
        final AtomicBoolean result2 = new AtomicBoolean();
        final AtomicBoolean failure = new AtomicBoolean();
        rebaseTask.executeInBackground(true, new GitTaskResultHandlerAdapter(){

            @Override
            protected void onSuccess() {
                result2.set(true);
            }

            @Override
            protected void onCancel() {
                result2.set(false);
            }

            @Override
            protected void onFailure() {
                failure.set(true);
            }
        });
        if (failure.get()) {
            result2.set(this.handleRebaseFailure(root, h, rebaseConflictDetector));
        }
        return result2.get();
    }

    private boolean handleRebaseFailure(final VirtualFile root, GitLineHandler h, GitRebaseProblemDetector rebaseConflictDetector) {
        if (rebaseConflictDetector.isMergeConflict()) {
            LOG.info("handleRebaseFailure merge conflict");
            return new GitConflictResolver(this.myProject, this.myGit, Collections.singleton(root), GitRebaser.makeParamsForRebaseConflict()){

                @Override
                protected boolean proceedIfNothingToMerge() {
                    return GitRebaser.this.continueRebase(root, "--continue");
                }

                @Override
                protected boolean proceedAfterAllMerged() {
                    return GitRebaser.this.continueRebase(root, "--continue");
                }
            }.merge();
        }
        if (rebaseConflictDetector.isNoChangeError()) {
            LOG.info("handleRebaseFailure no changes error detected");
            try {
                if (GitUtil.hasLocalChanges(true, this.myProject, root)) {
                    LOG.error("The rebase detector incorrectly detected 'no changes' situation. Attempting to continue rebase.");
                    return this.continueRebase(root);
                }
                if (GitUtil.hasLocalChanges(false, this.myProject, root)) {
                    LOG.warn("No changes from patch were not added to the index. Adding all changes from tracked files.");
                    this.stageEverything(root);
                    return this.continueRebase(root);
                }
                GitRebaseUtils.CommitInfo commit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                LOG.info("no changes confirmed. Skipping commit " + commit);
                this.mySkippedCommits.add(commit);
                return this.continueRebase(root, "--skip");
            }
            catch (VcsException e) {
                LOG.info("Failed to work around 'no changes' error.", (Throwable)e);
                String message = "Couldn't proceed with rebase. " + e.getMessage();
                GitUIUtil.notifyImportantError(this.myProject, "Error rebasing", message);
                return false;
            }
        }
        LOG.info("handleRebaseFailure error " + h.errors());
        GitUIUtil.notifyImportantError(this.myProject, "Error rebasing", GitUIUtil.stringifyErrors(h.errors()));
        return false;
    }

    private void stageEverything(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "stageEverything"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.ADD);
        handler.setSilent(false);
        handler.addParameters("--update");
        handler.run();
    }

    private static GitConflictResolver.Params makeParamsForRebaseConflict() {
        return new GitConflictResolver.Params().setReverse(true).setErrorNotificationTitle("Can't continue rebase").setMergeDescription("Merge conflicts detected. Resolve them before continuing rebase.").setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
    }

    @NotNull
    public GitUpdateResult handleRebaseFailure(@NotNull GitLineHandler handler, @NotNull VirtualFile root, @NotNull GitCommandResult result2, @NotNull GitRebaseProblemDetector rebaseConflictDetector, @NotNull GitMessageWithFilesDetector untrackedWouldBeOverwrittenDetector, @NotNull GitLocalChangesWouldBeOverwrittenDetector localChangesDetector) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        if (rebaseConflictDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebaseConflictDetector", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        if (untrackedWouldBeOverwrittenDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untrackedWouldBeOverwrittenDetector", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        if (localChangesDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangesDetector", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        if (rebaseConflictDetector.isMergeConflict()) {
            LOG.info("handleRebaseFailure merge conflict");
            boolean allMerged = new ConflictResolver(this.myProject, this.myGit, root, this).merge();
            GitUpdateResult gitUpdateResult = allMerged ? GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS : GitUpdateResult.INCOMPLETE;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
            }
            return gitUpdateResult;
        }
        if (untrackedWouldBeOverwrittenDetector.wasMessageDetected()) {
            LOG.info("handleRebaseFailure: untracked files would be overwritten by checkout");
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, untrackedWouldBeOverwrittenDetector.getRelativeFilePaths(), "rebase", null);
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
            }
            return gitUpdateResult;
        }
        if (localChangesDetector.wasMessageDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(this.myProject, root, "rebase", localChangesDetector.getRelativeFilePaths());
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
            }
            return gitUpdateResult;
        }
        LOG.info("handleRebaseFailure error " + handler.errors());
        VcsNotifier.getInstance((Project)this.myProject).notifyError("Rebase error", result2.getErrorOutputAsHtmlString());
        GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaser", "handleRebaseFailure"));
        }
        return gitUpdateResult;
    }

    class PushRebaseEditor
    extends GitInteractiveRebaseEditorHandler {
        private final Logger LOG;
        private final List<String> myCommits;
        private final boolean myHasMerges;

        public PushRebaseEditor(GitRebaseEditorService rebaseEditorService, VirtualFile root, List<String> commits2, boolean hasMerges) {
            super(rebaseEditorService, GitRebaser.this.myProject, root);
            this.LOG = Logger.getInstance(PushRebaseEditor.class);
            this.myCommits = commits2;
            this.myHasMerges = hasMerges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int editCommits(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/rebase/GitRebaser$PushRebaseEditor", "editCommits"));
            }
            if (!this.myRebaseEditorShown) {
                this.myRebaseEditorShown = true;
                if (this.myHasMerges) {
                    return 0;
                }
                try {
                    TreeMap<String, String> pickLines = new TreeMap<String, String>();
                    StringScanner s = new StringScanner(new String(FileUtil.loadFileText((File)new File(path), (String)"UTF-8")));
                    while (s.hasMoreData()) {
                        if (!s.tryConsume("pick ")) {
                            s.line();
                            continue;
                        }
                        String commit = s.spaceToken();
                        pickLines.put(commit, "pick " + commit + " " + s.line());
                    }
                    try (PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));){
                        for (String commit : this.myCommits) {
                            String key = pickLines.headMap(commit + "\u0000").lastKey();
                            if (key == null || !commit.startsWith(key)) continue;
                            w.print((String)pickLines.get(key) + "\n");
                        }
                    }
                    return 0;
                }
                catch (Exception ex) {
                    this.LOG.error("Editor failed: ", (Throwable)ex);
                    return 1;
                }
            }
            return super.editCommits(path);
        }
    }

    public static class ConflictResolver
    extends GitConflictResolver {
        @NotNull
        private final GitRebaser myRebaser;
        @NotNull
        private final VirtualFile myRoot;

        public ConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull GitRebaser rebaser) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaser$ConflictResolver", "<init>"));
            }
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/rebase/GitRebaser$ConflictResolver", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser$ConflictResolver", "<init>"));
            }
            if (rebaser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebaser", "git4idea/rebase/GitRebaser$ConflictResolver", "<init>"));
            }
            super(project, git, Collections.singleton(root), ConflictResolver.makeParams());
            this.myRebaser = rebaser;
            this.myRoot = root;
        }

        private static GitConflictResolver.Params makeParams() {
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setReverse(true);
            params.setMergeDescription("Merge conflicts detected. Resolve them before continuing rebase.");
            params.setErrorNotificationTitle("Can't continue rebase");
            params.setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
            return params;
        }

        @Override
        protected boolean proceedIfNothingToMerge() throws VcsException {
            return this.myRebaser.continueRebase(this.myRoot);
        }

        @Override
        protected boolean proceedAfterAllMerged() throws VcsException {
            return this.myRebaser.continueRebase(this.myRoot);
        }
    }

    public static class TrivialEditor
    extends GitInteractiveRebaseEditorHandler {
        public TrivialEditor(@NotNull GitRebaseEditorService service, @NotNull Project project, @NotNull VirtualFile root) {
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "git4idea/rebase/GitRebaser$TrivialEditor", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaser$TrivialEditor", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaser$TrivialEditor", "<init>"));
            }
            super(service, project, root);
        }

        @Override
        public int editCommits(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/rebase/GitRebaser$TrivialEditor", "editCommits"));
            }
            return 0;
        }
    }
}

