/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitRepositoryUpdater
implements Disposable,
BulkFileListener {
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final MessageBusConnection myMessageBusConnection;
    @NotNull
    private final QueueProcessor<List<? extends VFileEvent>> myUpdateQueue;
    @Nullable
    private final VirtualFile myRemotesDir;
    @Nullable
    private final VirtualFile myHeadsDir;
    @Nullable
    private final VirtualFile myTagsDir;
    @NotNull
    private final Set<LocalFileSystem.WatchRequest> myWatchRequests;

    GitRepositoryUpdater(@NotNull GitRepository repository, @NotNull GitRepositoryFiles gitFiles) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/repo/GitRepositoryUpdater", "<init>"));
        }
        if (gitFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitFiles", "git4idea/repo/GitRepositoryUpdater", "<init>"));
        }
        this.myRepository = repository;
        List rootPaths = ContainerUtil.map(gitFiles.getRootDirs(), file -> file.getPath());
        this.myWatchRequests = LocalFileSystem.getInstance().addRootsToWatch((Collection)rootPaths, true);
        this.myRepositoryFiles = gitFiles;
        this.visitSubDirsInVfs();
        this.myHeadsDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsHeadsFile());
        this.myRemotesDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsRemotesFile());
        this.myTagsDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsTagsFile());
        Project project = repository.getProject();
        this.myUpdateQueue = new QueueProcessor(events -> this.processEvents((List<? extends VFileEvent>)events), project.getDisposed());
        if (!project.isDisposed()) {
            this.myMessageBusConnection = project.getMessageBus().connect();
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        } else {
            this.myMessageBusConnection = null;
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "git4idea/repo/GitRepositoryUpdater", "after"));
        }
        this.myUpdateQueue.add((Object)ContainerUtil.newArrayList(events));
    }

    private void processEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "git4idea/repo/GitRepositoryUpdater", "processEvents"));
        }
        boolean configChanged = false;
        boolean headChanged = false;
        boolean branchFileChanged = false;
        boolean packedRefsChanged = false;
        boolean rebaseFileChanged = false;
        boolean mergeFileChanged = false;
        boolean tagChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = GitFileUtils.stripFileProtocolPrefix(vFileEvent.getPath());
            if (this.myRepositoryFiles.isConfigFile(filePath)) {
                configChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isHeadFile(filePath)) {
                headChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isRemoteBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myRemotesDir);
                continue;
            }
            if (this.myRepositoryFiles.isPackedRefs(filePath)) {
                packedRefsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isMergeFile(filePath)) {
                mergeFileChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isTagFile(filePath)) continue;
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myTagsDir);
            tagChanged = true;
        }
        if (headChanged || configChanged || branchFileChanged || packedRefsChanged || rebaseFileChanged || mergeFileChanged) {
            this.myRepository.update();
        } else if (tagChanged) {
            ((GitRepositoryChangeListener)this.myRepository.getProject().getMessageBus().syncPublisher(GitRepository.GIT_REPO_CHANGE)).repositoryChanged(this.myRepository);
        }
    }

    private void visitSubDirsInVfs() {
        for (VirtualFile rootDir : this.myRepositoryFiles.getRootDirs()) {
            rootDir.getChildren();
        }
        for (String path : this.myRepositoryFiles.getDirsToWatch()) {
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        }
    }
}

