/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

class AsBooleanTransformation
extends Transformation {
    public static final String NEGATION = GroovyTokenTypes.mLNOT.toString();
    public static final String DOUBLE_NEGATION = NEGATION + NEGATION;

    AsBooleanTransformation() {
    }

    @Nullable
    protected String getPrefix(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "getPrefix"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "getPrefix"));
        }
        if (AsBooleanTransformation.isImplicitlyBoolean(methodCall)) {
            return "";
        }
        if (options.useDoubleNegation()) {
            return DOUBLE_NEGATION;
        }
        return null;
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "apply"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "apply"));
        }
        GrInspectionUtil.replaceExpression(methodCall, this.getPrefix(methodCall, options) + Objects.requireNonNull(AsBooleanTransformation.getBase(methodCall)).getText());
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "couldApplyInternal"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "couldApplyInternal"));
        }
        return AsBooleanTransformation.getBase(methodCall) != null && methodCall.getExpressionArguments().length == 0 && this.getPrefix(methodCall, options) != null && methodCall.getClosureArguments().length == 0;
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "needParentheses"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "needParentheses"));
        }
        String prefix = this.getPrefix(methodCall, options);
        return DOUBLE_NEGATION.equals(prefix) && ParenthesesUtils.checkPrecedence(ParenthesesUtils.PREFIX_PRECEDENCE, (GrExpression)methodCall);
    }

    private static boolean isImplicitlyBoolean(GrMethodCall methodCall) {
        PsiElement parent = methodCall.getParent();
        if (parent instanceof GrIfStatement || parent instanceof GrWhileStatement) {
            return true;
        }
        if (parent instanceof GrConditionalExpression && ((GrConditionalExpression)parent).getCondition().equals(methodCall)) {
            return true;
        }
        if (parent instanceof GrUnaryExpression && PsiType.BOOLEAN.equals((Object)((GrUnaryExpression)parent).getType())) {
            return true;
        }
        return parent instanceof GrBinaryExpression && PsiType.BOOLEAN.equals((Object)((GrBinaryExpression)parent).getType());
    }
}

