/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GrSplitDeclarationIntention
extends Intention {
    private String myText = "";

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention", "processIntention"));
        }
        if (!(element instanceof GrVariableDeclaration)) {
            return;
        }
        GrVariableDeclaration declaration = (GrVariableDeclaration)element;
        GrVariable[] variables = declaration.getVariables();
        if (variables.length == 1) {
            GrSplitDeclarationIntention.processSingleVar(project, declaration, variables[0]);
        } else if (variables.length > 1) {
            if (!declaration.isTuple() || declaration.getTupleInitializer() instanceof GrListOrMap) {
                GrSplitDeclarationIntention.processMultipleVars(project, declaration);
            } else {
                GrSplitDeclarationIntention.processTuple(project, declaration);
            }
        }
    }

    private static void processTuple(Project project, GrVariableDeclaration declaration) {
        GrExpression initializer = declaration.getTupleInitializer();
        assert (initializer != null);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrVariable[] variables = declaration.getVariables();
        StringBuilder assignmentBuilder = new StringBuilder();
        assignmentBuilder.append('(');
        for (GrVariable variable : variables) {
            assignmentBuilder.append(variable.getName()).append(',');
        }
        assignmentBuilder.replace(assignmentBuilder.length() - 1, assignmentBuilder.length(), ")=");
        assignmentBuilder.append(initializer.getText());
        GrStatement assignment = factory.createStatementFromText(assignmentBuilder.toString());
        declaration = GroovyRefactoringUtil.addBlockIntoParent(declaration);
        declaration.getParent().addAfter((PsiElement)assignment, (PsiElement)declaration);
        initializer.delete();
    }

    private static void processMultipleVars(Project project, GrVariableDeclaration declaration) {
        int i;
        GrVariable[] variables = declaration.getVariables();
        String modifiers = declaration.getModifierList().getText();
        GrStatement[] sts = new GrStatement[variables.length];
        for (i = 0; i < variables.length; ++i) {
            sts[i] = GrSplitDeclarationIntention.createVarDeclaration(project, variables[i], modifiers, declaration.isTuple());
        }
        declaration = GroovyRefactoringUtil.addBlockIntoParent(declaration);
        for (i = sts.length - 1; i >= 0; --i) {
            declaration.getParent().addAfter((PsiElement)sts[i], (PsiElement)declaration);
        }
        declaration.delete();
    }

    private static void processSingleVar(Project project, GrVariableDeclaration declaration, GrVariable variable) {
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            GrExpression assignment = factory.createExpressionFromText(variable.getName() + " = " + initializer.getText());
            initializer.delete();
            declaration = GroovyRefactoringUtil.addBlockIntoParent(declaration);
            declaration.getParent().addAfter((PsiElement)assignment, (PsiElement)declaration);
        }
    }

    private static GrStatement createVarDeclaration(Project project, GrVariable variable, String modifiers, boolean isTuple) {
        StringBuilder builder = new StringBuilder();
        builder.append(modifiers).append(' ');
        GrTypeElement typeElement = variable.getTypeElementGroovy();
        if (typeElement != null) {
            builder.append(typeElement.getText()).append(' ');
        }
        builder.append(variable.getName());
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            builder.append('=').append(initializer.getText());
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrVariableDeclaration decl = (GrVariableDeclaration)factory.createStatementFromText(builder);
        if (isTuple && (variable.getDeclaredType() != null || decl.getModifierList().getModifiers().length > 1)) {
            decl.getModifierList().setModifierProperty("def", false);
        }
        return decl;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention$1", "satisfiedBy"));
                }
                if (element instanceof GrVariableDeclaration) {
                    GrVariableDeclaration decl = (GrVariableDeclaration)element;
                    GrVariable[] variables = decl.getVariables();
                    if (variables.length > 1 && PsiUtil.isLocalVariable(variables[0])) {
                        if (!decl.isTuple() || decl.getTupleInitializer() instanceof GrListOrMap) {
                            GrSplitDeclarationIntention.this.myText = GroovyIntentionsBundle.message("split.into.separate.declaration", new Object[0]);
                        } else {
                            GrSplitDeclarationIntention.this.myText = GroovyIntentionsBundle.message("split.into.declaration.and.assignment", new Object[0]);
                        }
                        return true;
                    }
                    if (variables.length == 1 && PsiUtil.isLocalVariable(variables[0]) && variables[0].getInitializerGroovy() != null) {
                        GrSplitDeclarationIntention.this.myText = GroovyIntentionsBundle.message("split.into.declaration.and.assignment", new Object[0]);
                        return true;
                    }
                }
                return false;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

