/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;

public class GrCodeReferenceElementImpl
extends GrReferenceElementImpl<GrCodeReferenceElement>
implements GrCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl");
    private static final OurResolver RESOLVER = new OurResolver();

    public GrCodeReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (StringUtil.isJavaIdentifier((String)newElementName)) {
            return super.handleElementRename(newElementName);
        }
        throw new IncorrectOperationException("Cannot rename reference to '" + newElementName + "'");
    }

    protected GrCodeReferenceElement bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "bindWithQualifiedRef"));
        }
        GrCodeReferenceElement qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeOrPackageReference(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitCodeReferenceElement(this);
    }

    public String toString() {
        return "Reference element";
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
    }

    public ReferenceKind getKind(boolean forCompletion) {
        if (this.isClassReferenceForNew()) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrCodeReferenceElementImpl) {
            ReferenceKind parentKind = ((GrCodeReferenceElementImpl)parent).getKind(forCompletion);
            if (parentKind == ReferenceKind.CLASS) {
                return ReferenceKind.CLASS_OR_PACKAGE;
            }
            if (parentKind == ReferenceKind.STATIC_MEMBER_FQ) {
                return this.isQualified() ? ReferenceKind.CLASS_FQ : ReferenceKind.CLASS;
            }
            if (parentKind == ReferenceKind.CLASS_FQ) {
                return ReferenceKind.CLASS_OR_PACKAGE_FQ;
            }
            return parentKind;
        }
        if (parent instanceof GrPackageDefinition) {
            return ReferenceKind.PACKAGE_FQ;
        }
        if (parent instanceof GrDocReferenceElement) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        if (parent instanceof GrImportStatement) {
            GrImportStatement importStatement = (GrImportStatement)parent;
            if (importStatement.isStatic()) {
                return importStatement.isOnDemand() ? ReferenceKind.CLASS : ReferenceKind.STATIC_MEMBER_FQ;
            }
            return forCompletion || importStatement.isOnDemand() ? ReferenceKind.CLASS_OR_PACKAGE_FQ : ReferenceKind.CLASS_FQ;
        }
        if (parent instanceof GrNewExpression || parent instanceof GrAnonymousClassDefinition) {
            PsiElement newExpr;
            PsiElement psiElement = newExpr = parent instanceof GrAnonymousClassDefinition ? parent.getParent() : parent;
            assert (newExpr instanceof GrNewExpression);
        }
        return ReferenceKind.CLASS;
    }

    @NotNull
    public String getCanonicalText() {
        ReferenceKind kind = this.getKind(false);
        switch (kind) {
            case CLASS: 
            case CLASS_OR_PACKAGE: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiType[] types;
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    if ((types = this.getTypeArguments()).length == 0) {
                        String string = name;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                        }
                        return string;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    for (int i = 0; i < types.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                    }
                    buf.append('>');
                    String string = buf.toString();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                LOG.assertTrue(target == null);
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: 
            case STATIC_MEMBER_FQ: {
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
        }
        LOG.assertTrue(false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
        }
        return null;
    }

    @Override
    protected boolean bindsCorrectly(PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        if (super.bindsCorrectly(element)) {
            return true;
        }
        return element instanceof PsiClass && (resolved = this.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).isConstructor() && this.getManager().areElementsEquivalent(element, (PsiElement)method.getContainingClass());
    }

    @Override
    public boolean isFullyQualified() {
        switch (this.getKind(false)) {
            case CLASS_OR_PACKAGE: 
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: 
            case STATIC_MEMBER_FQ: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
        }
        GrCodeReferenceElement qualifier = this.getQualifier();
        return qualifier != null && ((GrCodeReferenceElementImpl)qualifier).isFullyQualified();
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiManagerEx manager = this.getManager();
        if (element instanceof PsiNamedElement && this.getParent() instanceof GrImportStatement) {
            GroovyResolveResult[] results2;
            for (GroovyResolveResult result : results2 = this.multiResolve(false)) {
                if (!manager.areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
        }
        return manager.areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private boolean isClassReferenceForNew() {
        PsiElement parent = this.getParent();
        while (parent instanceof GrCodeReferenceElement) {
            parent = parent.getParent();
        }
        return parent instanceof GrNewExpression;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        GrTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList != null && typeArgumentList.isDiamond()) {
            PsiType[] psiTypeArray = this.inferDiamondTypeArguments();
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getTypeArguments"));
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = super.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getTypeArguments"));
        }
        return psiTypeArray;
    }

    private PsiType[] inferDiamondTypeArguments() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof GrNewExpression)) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType lType = PsiImplUtil.inferExpectedTypeForDiamond((GrNewExpression)parent);
        if (lType instanceof PsiClassType) {
            return ((PsiClassType)lType).getParameters();
        }
        return PsiType.EMPTY_ARRAY;
    }

    private static class OurResolver
    implements ResolveCache.PolyVariantResolver<GrCodeReferenceElementImpl> {
        private OurResolver() {
        }

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrCodeReferenceElementImpl reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
            }
            if (reference.getReferenceName() == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results2 = OurResolver._resolve(reference, (PsiManager)reference.getManager(), reference.getKind(false));
            if (results2.length == 0) {
                if (results2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
                }
                return results2;
            }
            ArrayList<GroovyResolveResultImpl> imported = new ArrayList<GroovyResolveResultImpl>();
            PsiType[] args = reference.getTypeArguments();
            for (int i = 0; i < results2.length; ++i) {
                GroovyResolveResult result = results2[i];
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiSubstitutor newSubstitutor = substitutor.putAll((PsiClass)element, args);
                PsiElement context = result.getCurrentFileResolveContext();
                GroovyResolveResultImpl newResult = new GroovyResolveResultImpl(element, context, null, newSubstitutor, result.isAccessible(), result.isStaticsOK());
                results2[i] = newResult;
                if (!(context instanceof GrImportStatement)) continue;
                imported.add(newResult);
            }
            if (!imported.isEmpty()) {
                GroovyResolveResult[] groovyResolveResultArray = imported.toArray(new GroovyResolveResult[imported.size()]);
                if (groovyResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
                }
                return groovyResolveResultArray;
            }
            if (results2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
            }
            return results2;
        }

        @NotNull
        private static GroovyResolveResult[] _resolve(@NotNull GrCodeReferenceElementImpl ref, @NotNull PsiManager manager, @NotNull ReferenceKind kind) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
            }
            String refName = ref.getReferenceName();
            if (refName == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            switch (kind) {
                case CLASS_FQ: 
                case CLASS_OR_PACKAGE_FQ: 
                case PACKAGE_FQ: {
                    String qName = PsiUtil.getQualifiedReferenceText(ref);
                    LOG.assertTrue(qName != null, (Object)ref.getText());
                    PsiElement element = OurResolver.resolveClassOrPackagePreferInner(ref, kind, qName, JavaPsiFacade.getInstance((Project)manager.getProject()));
                    if (element == null) break;
                    boolean accessible = !(element instanceof PsiClass) || PsiUtil.isAccessible(ref, (PsiMember)((PsiClass)element));
                    GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{new GroovyResolveResultImpl(element, accessible)};
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return groovyResolveResultArray;
                }
                case CLASS: {
                    GrCodeReferenceElementImpl placeToStartWalking;
                    EnumSet<ElementClassHint.DeclarationKind> kinds = ClassHint.RESOLVE_KINDS_CLASS;
                    ClassResolverProcessor processor = new ClassResolverProcessor(refName, ref, kinds);
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier != null) {
                        PsiElement qualifierResolved = qualifier.resolve();
                        if (!(qualifierResolved instanceof PsiPackage) && !(qualifierResolved instanceof PsiClass)) break;
                        qualifierResolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)ref);
                        GroovyResolveResult[] groovyResolveResultArray = processor.getCandidates();
                        if (groovyResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                        }
                        return groovyResolveResultArray;
                    }
                    GrCodeReferenceElementImpl grCodeReferenceElementImpl = placeToStartWalking = OurResolver.isAnnotationRef(ref) ? OurResolver.getContainingFileSkippingStubFiles(ref) : ref;
                    if (placeToStartWalking == null) break;
                    PsiTreeUtilKt.treeWalkUp(placeToStartWalking, processor);
                    GroovyResolveResult[] candidates = processor.getCandidates();
                    if (candidates.length <= 0) break;
                    if (candidates == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return candidates;
                }
                case CLASS_OR_PACKAGE: {
                    GroovyResolveResult[] classResult = OurResolver._resolve(ref, manager, ReferenceKind.CLASS);
                    if (classResult.length == 1 && !classResult[0].isAccessible()) {
                        GroovyResolveResult[] packageResult = OurResolver._resolve(ref, manager, ReferenceKind.PACKAGE_FQ);
                        if (packageResult.length != 0) {
                            if (packageResult == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                            }
                            return packageResult;
                        }
                    } else if (classResult.length == 0) {
                        GroovyResolveResult[] groovyResolveResultArray = OurResolver._resolve(ref, manager, ReferenceKind.PACKAGE_FQ);
                        if (groovyResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                        }
                        return groovyResolveResultArray;
                    }
                    if (classResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return classResult;
                }
                case STATIC_MEMBER_FQ: {
                    PsiElement resolved;
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier == null || !((resolved = qualifier.resolve()) instanceof PsiClass)) break;
                    PsiClass clazz = (PsiClass)resolved;
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)clazz.getProject()).getResolveHelper();
                    ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
                    OurResolver.processFields(ref, refName, clazz, helper, result);
                    OurResolver.processMethods(ref, refName, clazz, helper, result);
                    OurResolver.processInnerClasses(ref, refName, clazz, helper, result);
                    if (result.isEmpty()) {
                        OurResolver.processAccessors(ref, refName, clazz, helper, result);
                    }
                    GroovyResolveResult[] groovyResolveResultArray = result.toArray(new GroovyResolveResult[result.size()]);
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return groovyResolveResultArray;
                }
            }
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }

        @Nullable
        private static PsiElement resolveClassOrPackagePreferInner(@NotNull GrCodeReferenceElementImpl ref, @NotNull ReferenceKind kind, String qName, JavaPsiFacade facade) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolveClassOrPackagePreferInner"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolveClassOrPackagePreferInner"));
            }
            if (kind == ReferenceKind.CLASS_OR_PACKAGE_FQ || kind == ReferenceKind.CLASS_FQ) {
                boolean qualified;
                PsiFile file = ref.getContainingFile();
                boolean bl = qualified = qName.indexOf(46) > 0;
                if (qualified || file instanceof GroovyFile && ((GroovyFile)file).getPackageName().isEmpty()) {
                    PsiClass aClass;
                    PsiElement container = qualified ? OurResolver.resolveClassOrPackagePreferInner(ref, kind, StringUtil.getPackageName((String)qName), facade) : null;
                    PsiClass psiClass = aClass = container instanceof PsiClass && PsiUtil.isAccessible(ref, (PsiMember)((PsiClass)container)) ? ((PsiClass)container).findInnerClassByName(StringUtil.getShortName((String)qName), true) : null;
                    if (aClass == null) {
                        aClass = facade.findClass(qName, ref.getResolveScope());
                    }
                    if (aClass != null) {
                        return aClass;
                    }
                }
            }
            if (kind == ReferenceKind.CLASS_OR_PACKAGE_FQ || kind == ReferenceKind.PACKAGE_FQ) {
                return facade.findPackage(qName);
            }
            return null;
        }

        private static PsiFile getContainingFileSkippingStubFiles(GrCodeReferenceElementImpl ref) {
            PsiFile file = ref.getContainingFile();
            while (file != null && !file.isPhysical() && file.getContext() != null) {
                PsiElement context = file.getContext();
                file = context.getContainingFile();
            }
            return file;
        }

        private static boolean isAnnotationRef(GrCodeReferenceElement ref) {
            PsiElement parent = ref.getParent();
            return parent instanceof GrAnnotation || parent instanceof GrCodeReferenceElement && OurResolver.isAnnotationRef((GrCodeReferenceElement)parent);
        }

        private static void processAccessors(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            String booleanGetter = GroovyPropertyUtils.getGetterNameBoolean(refName);
            String nonBooleanGetter = GroovyPropertyUtils.getGetterNameNonBoolean(refName);
            String setter = GroovyPropertyUtils.getSetterName(refName);
            OurResolver.processMethods(ref, booleanGetter, clazz, helper, result);
            if (!result.isEmpty()) {
                return;
            }
            OurResolver.processMethods(ref, nonBooleanGetter, clazz, helper, result);
            if (!result.isEmpty()) {
                return;
            }
            OurResolver.processMethods(ref, setter, clazz, helper, result);
        }

        private static void processInnerClasses(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiClass innerClass = clazz.findInnerClassByName(refName, true);
            if (innerClass != null && innerClass.hasModifierProperty("static")) {
                result.add(new GroovyResolveResultImpl((PsiElement)innerClass, helper.isAccessible((PsiMember)innerClass, (PsiElement)ref, null)));
            }
        }

        private static void processFields(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiField field = clazz.findFieldByName(refName, true);
            if (field != null && field.hasModifierProperty("static")) {
                result.add(new GroovyResolveResultImpl((PsiElement)field, helper.isAccessible((PsiMember)field, (PsiElement)ref, null)));
            }
        }

        private static void processMethods(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = clazz.findMethodsByName(refName, true)) {
                result.add(new GroovyResolveResultImpl((PsiElement)method, helper.isAccessible((PsiMember)method, (PsiElement)ref, null)));
            }
        }
    }

    public static enum ReferenceKind {
        CLASS,
        CLASS_OR_PACKAGE,
        PACKAGE_FQ,
        CLASS_FQ,
        CLASS_OR_PACKAGE_FQ,
        STATIC_MEMBER_FQ;

    }
}

