/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class CachedModuleDataFinder {
    private Map<String, DataNode<ModuleData>> cache = ContainerUtil.newHashMap();

    @Nullable
    public DataNode<ModuleData> findModuleData(DataNode parentNode, String projectPath) {
        DataNode<ModuleData> node = this.cache.get(projectPath);
        if (node != null) {
            return node;
        }
        return ExternalSystemApiUtil.findFirstRecursively((DataNode)parentNode, node1 -> {
            if ((ProjectKeys.MODULE.equals((Object)node1.getKey()) || GradleSourceSetData.KEY.equals((Object)node1.getKey())) && node1.getData() instanceof ModuleData) {
                String externalProjectPath = ((ModuleData)node1.getData()).getLinkedExternalProjectPath();
                DataNode myNode = node1;
                this.cache.put(externalProjectPath, (DataNode<ModuleData>)myNode);
                return StringUtil.equals((CharSequence)projectPath, (CharSequence)((ModuleData)node1.getData()).getLinkedExternalProjectPath());
            }
            return false;
        });
    }

    @Nullable
    public DataNode<ModuleData> findModuleData(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/execution/build/CachedModuleDataFinder", "findModuleData"));
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath == null) {
            return null;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (projectId == null) {
            return null;
        }
        String externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (externalProjectPath == null || StringUtil.endsWith((CharSequence)externalProjectPath, (CharSequence)"buildSrc")) {
            return null;
        }
        ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(module.getProject(), GradleConstants.SYSTEM_ID, rootProjectPath);
        if (projectData == null) {
            return null;
        }
        DataNode projectStructure = projectData.getExternalProjectStructure();
        if (projectStructure == null) {
            return null;
        }
        return this.findModuleData(projectStructure, externalProjectPath);
    }
}

