/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEvent;

public abstract class AbstractTestEvent
implements TestEvent {
    private final GradleTestsExecutionConsole myExecutionConsole;

    public AbstractTestEvent(GradleTestsExecutionConsole executionConsole) {
        this.myExecutionConsole = executionConsole;
    }

    public GradleTestsExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.myExecutionConsole.getResultsViewer();
    }

    protected Project getProject() {
        return this.myExecutionConsole.getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getExecutionConsole().getProperties();
    }

    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        if (fqClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqClassName", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "findLocationUrl"));
        }
        String string = GradleRunnerUtil.getTestLocationUrl(name, fqClassName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "findLocationUrl"));
        }
        return string;
    }

    protected void addToInvokeLater(Runnable runnable) {
        ExternalSystemApiUtil.addToInvokeLater((Runnable)runnable);
    }

    @Nullable
    protected SMTestProxy findTestProxy(String proxyId) {
        return this.getExecutionConsole().getTestsMap().get(proxyId);
    }

    protected void registerTestProxy(String proxyId, SMTestProxy testProxy) {
        this.myExecutionConsole.getTestsMap().put(proxyId, testProxy);
    }

    protected String decode(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }
}

