/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class WifiPowerEstimator
extends PowerCalculator {
    private static final boolean DEBUG = false;
    private static final String TAG = "WifiPowerEstimator";
    private final double mWifiPowerPerPacket;
    private final double mWifiPowerOn;
    private final double mWifiPowerScan;
    private final double mWifiPowerBatchScan;
    private long mTotalAppWifiRunningTimeMs = 0L;

    public WifiPowerEstimator(PowerProfile profile) {
        this.mWifiPowerPerPacket = WifiPowerEstimator.getWifiPowerPerPacket(profile);
        this.mWifiPowerOn = profile.getAveragePower("wifi.on");
        this.mWifiPowerScan = profile.getAveragePower("wifi.scan");
        this.mWifiPowerBatchScan = profile.getAveragePower("wifi.batchedscan");
    }

    private static double getWifiPowerPerPacket(PowerProfile profile) {
        long WIFI_BPS = 1000000L;
        double WIFI_POWER = profile.getAveragePower("wifi.active") / 3600.0;
        return WIFI_POWER / 61.03515625 / 3600.0;
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        app.wifiRxPackets = u.getNetworkActivityPackets(2, statsType);
        app.wifiTxPackets = u.getNetworkActivityPackets(3, statsType);
        app.wifiRxBytes = u.getNetworkActivityBytes(2, statsType);
        app.wifiTxBytes = u.getNetworkActivityBytes(3, statsType);
        double wifiPacketPower = (double)(app.wifiRxPackets + app.wifiTxPackets) * this.mWifiPowerPerPacket;
        app.wifiRunningTimeMs = u.getWifiRunningTime(rawRealtimeUs, statsType) / 1000L;
        this.mTotalAppWifiRunningTimeMs += app.wifiRunningTimeMs;
        double wifiLockPower = (double)app.wifiRunningTimeMs * this.mWifiPowerOn / 3600000.0;
        long wifiScanTimeMs = u.getWifiScanTime(rawRealtimeUs, statsType) / 1000L;
        double wifiScanPower = (double)wifiScanTimeMs * this.mWifiPowerScan / 3600000.0;
        double wifiBatchScanPower = 0.0;
        for (int bin = 0; bin < 5; ++bin) {
            long batchScanTimeMs = u.getWifiBatchedScanTime(bin, rawRealtimeUs, statsType) / 1000L;
            double batchScanPower = (double)batchScanTimeMs * this.mWifiPowerBatchScan / 3600000.0;
            wifiBatchScanPower += batchScanPower;
        }
        app.wifiPowerMah = wifiPacketPower + wifiLockPower + wifiScanPower + wifiBatchScanPower;
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long totalRunningTimeMs = stats.getGlobalWifiRunningTime(rawRealtimeUs, statsType) / 1000L;
        double powerDrain = (double)(totalRunningTimeMs - this.mTotalAppWifiRunningTimeMs) * this.mWifiPowerOn / 3600000.0;
        app.wifiRunningTimeMs = totalRunningTimeMs;
        app.wifiPowerMah = Math.max(0.0, powerDrain);
    }

    @Override
    public void reset() {
        this.mTotalAppWifiRunningTimeMs = 0L;
    }
}

