/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.browser.ie;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.jna.win.WinHttp;
import com.github.markusbernhardt.proxy.jna.win.WinHttpCurrentUserIEProxyConfig;
import com.github.markusbernhardt.proxy.search.browser.ie.IELocalByPassFilter;
import com.github.markusbernhardt.proxy.search.browser.ie.IEProxyConfig;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.whitelist.ProxyBypassListSelector;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyException;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import com.github.markusbernhardt.proxy.util.UriFilter;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Properties;

public class IEProxySearchStrategy
implements ProxySearchStrategy {
    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Detecting IE proxy settings", new Object[0]);
        IEProxyConfig ieProxyConfig = this.readIEProxyConfig();
        ProxySelector result = this.createPacSelector(ieProxyConfig);
        if (result == null) {
            result = this.createFixedProxySelector(ieProxyConfig);
        }
        return result;
    }

    @Override
    public String getName() {
        return "IE";
    }

    public IEProxyConfig readIEProxyConfig() {
        WinHttpCurrentUserIEProxyConfig winHttpCurrentUserIeProxyConfig = new WinHttpCurrentUserIEProxyConfig();
        boolean result = WinHttp.INSTANCE.WinHttpGetIEProxyConfigForCurrentUser(winHttpCurrentUserIeProxyConfig);
        if (!result) {
            return null;
        }
        return new IEProxyConfig(winHttpCurrentUserIeProxyConfig.fAutoDetect, winHttpCurrentUserIeProxyConfig.lpszAutoConfigUrl != null ? winHttpCurrentUserIeProxyConfig.lpszAutoConfigUrl.getValue() : null, winHttpCurrentUserIeProxyConfig.lpszProxy != null ? winHttpCurrentUserIeProxyConfig.lpszProxy.getValue() : null, winHttpCurrentUserIeProxyConfig.lpszProxyBypass != null ? winHttpCurrentUserIeProxyConfig.lpszProxyBypass.getValue() : null);
    }

    private PacProxySelector createPacSelector(IEProxyConfig ieProxyConfig) {
        String pacUrl = null;
        if (ieProxyConfig.isAutoDetect()) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Autodetecting script URL.", new Object[0]);
            WinDef.DWORD dwAutoDetectFlags = new WinDef.DWORD(3L);
            WTypes.LPWSTR ppwszAutoConfigUrl = new WTypes.LPWSTR();
            boolean result = WinHttp.INSTANCE.WinHttpDetectAutoProxyConfigUrl(dwAutoDetectFlags, ppwszAutoConfigUrl);
            if (result) {
                pacUrl = ppwszAutoConfigUrl.getValue();
            }
        }
        if (pacUrl == null) {
            pacUrl = ieProxyConfig.getAutoConfigUrl();
        }
        if (pacUrl != null && pacUrl.trim().length() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "IE uses script: " + pacUrl, new Object[0]);
            if (pacUrl.startsWith("file://") && !pacUrl.startsWith("file:///")) {
                pacUrl = "file:///" + pacUrl.substring(7);
            }
            return ProxyUtil.buildPacSelectorForUrl(pacUrl);
        }
        return null;
    }

    private ProxySelector createFixedProxySelector(IEProxyConfig ieProxyConfig) throws ProxyException {
        String proxyString = ieProxyConfig.getProxy();
        String bypassList = ieProxyConfig.getProxyBypass();
        if (proxyString == null) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "IE uses manual settings: {0} with bypass list: {1}", proxyString, bypassList);
        Properties p = this.parseProxyList(proxyString);
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        this.addSelectorForProtocol(p, "http", ps);
        this.addSelectorForProtocol(p, "https", ps);
        this.addSelectorForProtocol(p, "ftp", ps);
        this.addSelectorForProtocol(p, "gopher", ps);
        this.addSelectorForProtocol(p, "socks", ps);
        this.addFallbackSelector(p, ps);
        ProxySelector result = this.setByPassListOnSelector(bypassList, ps);
        return result;
    }

    private ProxySelector setByPassListOnSelector(String bypassList, ProtocolDispatchSelector ps) {
        if (bypassList != null && bypassList.trim().length() > 0) {
            ProxyBypassListSelector result;
            if ("<local>".equals(bypassList.trim())) {
                result = this.buildLocalBypassSelector(ps);
            } else {
                bypassList = bypassList.replace(';', ',');
                result = new ProxyBypassListSelector(bypassList, (ProxySelector)ps);
            }
            return result;
        }
        return ps;
    }

    private ProxyBypassListSelector buildLocalBypassSelector(ProtocolDispatchSelector ps) {
        ArrayList<UriFilter> localBypassFilter = new ArrayList<UriFilter>();
        localBypassFilter.add(new IELocalByPassFilter());
        return new ProxyBypassListSelector(localBypassFilter, (ProxySelector)ps);
    }

    private void addFallbackSelector(Properties settings, ProtocolDispatchSelector ps) {
        String proxy = settings.getProperty("default");
        if (proxy != null) {
            ps.setFallbackSelector(ProxyUtil.parseProxySettings(proxy));
        }
    }

    private void addSelectorForProtocol(Properties settings, String protocol, ProtocolDispatchSelector ps) {
        String proxy = settings.getProperty(protocol);
        if (proxy != null) {
            FixedProxySelector protocolSelector = ProxyUtil.parseProxySettings(proxy);
            ps.setSelector(protocol, protocolSelector);
        }
    }

    private Properties parseProxyList(String proxyString) throws ProxyException {
        Properties p = new Properties();
        if (proxyString.indexOf(61) == -1) {
            p.setProperty("default", proxyString);
        } else {
            try {
                proxyString = proxyString.replace(';', '\n');
                p.load(new ByteArrayInputStream(proxyString.getBytes("ISO-8859-1")));
            }
            catch (IOException e) {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Error reading IE settings as properties: {0}", e);
                throw new ProxyException(e);
            }
        }
        return p;
    }
}

