/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001eJ\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0018RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006 \b*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/util/Ref;", "Lorg/jetbrains/kotlin/name/FqName;", "", "pendingDirectoryChanges", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "pendingKtFileChanges", "Lorg/jetbrains/kotlin/psi/KtFile;", "projectScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "checkPendingChanges", "", "checkPendingChanges$idea_analysis", "invalidateCacheForModule", "moduleSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "invalidateCacheForModule$idea_analysis", "notifyPackageChange", "file", "notifyPackageChange$idea_analysis", "onTooComplexChange", "onTooComplexChange$idea_analysis", "packageExists", "packageFqName", "moduleInfo", "Companion", "idea-analysis"})
public final class PerModulePackageCacheService {
    private final ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>> cache;
    private final Set<VirtualFile> pendingDirectoryChanges;
    private final Set<KtFile> pendingKtFileChanges;
    private final GlobalSearchScope projectScope;
    private final Project project;
    private static final Key<ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>>> PER_MODULE_PACKAGE_CACHE;
    private static final int FULL_DROP_THRESHOLD = 1000;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTooComplexChange$idea_analysis() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            this.pendingDirectoryChanges.clear();
            this.pendingKtFileChanges.clear();
            Iterable $receiver$iv = this.cache.values();
            for (Object element$iv : $receiver$iv) {
                Ref it = (Ref)element$iv;
                it.set(null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$idea_analysis(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            Unit unit;
            if (file2.isDirectory()) {
                Collection collection = this.pendingDirectoryChanges;
                unit = file2;
                collection.add(unit);
            } else if (file2.getParent() != null && file2.getParent().isDirectory()) {
                VirtualFile virtualFile2 = file2.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.parent");
                this.notifyPackageChange$idea_analysis(virtualFile2);
            }
            unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$idea_analysis(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            Collection collection = this.pendingKtFileChanges;
            KtFile ktFile = file2;
            collection.add(ktFile);
            ktFile = Unit.INSTANCE;
        }
    }

    public final void invalidateCacheForModule$idea_analysis(@NotNull ModuleSourceInfo moduleSourceInfo) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)moduleSourceInfo, (String)"moduleSourceInfo");
            Ref ref = (Ref)this.cache.get(moduleSourceInfo);
            if (ref == null) break block0;
            ref.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkPendingChanges$idea_analysis() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            if (this.pendingDirectoryChanges.size() + this.pendingKtFileChanges.size() >= Companion.getFULL_DROP_THRESHOLD()) {
                this.onTooComplexChange$idea_analysis();
            } else {
                ModuleSourceInfo it;
                ModuleSourceInfo moduleSourceInfo;
                Iterable $receiver$iv = this.pendingDirectoryChanges;
                for (Object element$iv : $receiver$iv) {
                    VirtualFile vfile = (VirtualFile)element$iv;
                    if (this.projectScope.contains(vfile) ^ true) continue;
                    IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfoByVirtualFile(this.project, vfile);
                    if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                        ideaModuleInfo = null;
                    }
                    if ((ModuleSourceInfo)ideaModuleInfo == null) continue;
                    it = moduleSourceInfo;
                    this.invalidateCacheForModule$idea_analysis(it);
                }
                this.pendingDirectoryChanges.clear();
                $receiver$iv = this.pendingKtFileChanges;
                for (Object element$iv : $receiver$iv) {
                    KtFile file2 = (KtFile)element$iv;
                    if (file2.getVirtualFile() != null && this.projectScope.contains(file2.getVirtualFile()) ^ true) continue;
                    IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getNullableModuleInfo((PsiElement)file2);
                    if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                        ideaModuleInfo = null;
                    }
                    if ((ModuleSourceInfo)ideaModuleInfo == null) continue;
                    it = moduleSourceInfo;
                    this.invalidateCacheForModule$idea_analysis(it);
                }
                this.pendingKtFileChanges.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull ModuleSourceInfo moduleInfo) {
        ConcurrentMap cached;
        Object object;
        Ref $receiver;
        ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>> concurrentMap;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        Module module = moduleInfo.getModule();
        this.checkPendingChanges$idea_analysis();
        ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>> concurrentMap2 = (ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>>)module.getUserData(PerModulePackageCacheService.Companion.getPER_MODULE_PACKAGE_CACHE());
        if (concurrentMap2 == null) {
            PerModulePackageCacheService perModulePackageCacheService;
            PerModulePackageCacheService $receiver2 = perModulePackageCacheService = this;
            ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>> $receiver3 = concurrentMap = ContainerUtil.createConcurrentSoftMap();
            module.putUserData(PerModulePackageCacheService.Companion.getPER_MODULE_PACKAGE_CACHE(), $receiver3);
            ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>> concurrentMap3 = concurrentMap;
            concurrentMap2 = concurrentMap3;
            Intrinsics.checkExpressionValueIsNotNull(concurrentMap3, (String)"run {\n            Contai\u2026_CACHE, this) }\n        }");
        }
        ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>> moduleOwnCache = concurrentMap2;
        ConcurrentMap $receiver$iv = moduleOwnCache;
        Object object2 = $receiver$iv.get(moduleInfo);
        if (object2 == null) {
            Ref ref;
            void $receiver$iv2;
            concurrentMap = this.cache;
            ModuleSourceInfo key$iv = moduleInfo;
            Object object3 = $receiver$iv2.get(key$iv);
            if (object3 == null) {
                Ref $i$a$1$apply = new Ref();
                Ref default$iv = $i$a$1$apply;
                object3 = $receiver$iv2.putIfAbsent(key$iv, default$iv);
                if (object3 == null) {
                    object3 = default$iv;
                }
            }
            Intrinsics.checkExpressionValueIsNotNull(object3, (String)"cache.getOrPut(moduleInfo) { Ref() }");
            Ref default$iv = ref = (Ref)object3;
            object2 = $receiver$iv.putIfAbsent(moduleInfo, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        if (($receiver = (Ref)($receiver$iv = object2)).isNull()) {
            $receiver.set((Object)ContainerUtil.createConcurrentSoftMap());
        }
        if ((object = ($receiver$iv = (cached = (ConcurrentMap)((Ref)$receiver$iv).get())).get(packageFqName)) == null) {
            Boolean bl = PackageIndexUtil.packageExists(packageFqName, moduleInfo.contentScope(), this.project);
            Boolean default$iv = bl;
            object = $receiver$iv.putIfAbsent(packageFqName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (Boolean)object;
    }

    public PerModulePackageCacheService(@NotNull Project project) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.cache = ContainerUtil.createConcurrentWeakMap();
        PerModulePackageCacheService perModulePackageCacheService = this;
        perModulePackageCacheService.pendingDirectoryChanges = set2 = (Set)new LinkedHashSet();
        perModulePackageCacheService = this;
        perModulePackageCacheService.pendingKtFileChanges = set2 = (Set)new LinkedHashSet();
        this.projectScope = GlobalSearchScope.projectScope((Project)this.project);
    }

    static {
        Companion = new Companion(null);
        PER_MODULE_PACKAGE_CACHE = Key.create((String)"per_module_package_cache");
        FULL_DROP_THRESHOLD = 1000;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R^\u0010\u0007\u001aL\u0012H\u0012F\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\t0\u000b \u000e*\"\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\t0\u000b\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion;", "", "()V", "FULL_DROP_THRESHOLD", "", "getFULL_DROP_THRESHOLD", "()I", "PER_MODULE_PACKAGE_CACHE", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "Lcom/intellij/openapi/util/Ref;", "Lorg/jetbrains/kotlin/name/FqName;", "", "kotlin.jvm.PlatformType", "getPER_MODULE_PACKAGE_CACHE", "()Lcom/intellij/openapi/util/Key;", "idea-analysis"})
    public static final class Companion {
        private final Key<ConcurrentMap<ModuleInfo, Ref<ConcurrentMap<FqName, Boolean>>>> getPER_MODULE_PACKAGE_CACHE() {
            return PER_MODULE_PACKAGE_CACHE;
        }

        public final int getFULL_DROP_THRESHOLD() {
            return FULL_DROP_THRESHOLD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

