/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SimplifyNegatedBinaryExpressionIntention;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u001a\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertAssertToIfWithThrowIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessageSingleExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isApplicableTo", "", "caretOffset", "", "messageIsFunction", "callExpr", "replaceWithIfThenThrowExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "original", "simplifyConditionIfPossible", "ifExpression", "idea"})
public final class ConvertAssertToIfWithThrowIntention
extends SelfTargetingIntention<KtCallExpression>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getCalleeExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression callee = ktExpression;
        if (!callee.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        int argumentSize = element2.getValueArguments().size();
        int n = argumentSize;
        if (1 > n || n > 2) {
            return false;
        }
        List<KtLambdaArgument> functionLiterals = element2.getLambdaArguments();
        if (functionLiterals.size() > 1) {
            return false;
        }
        if (functionLiterals.size() == 1 && argumentSize == 1) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element2, ResolutionUtils.analyze$default(element2, null, 1, null));
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtils.getFqName(resolvedCall3.getResultingDescriptor()).asString(), (Object)"kotlin.assert");
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element2, @Nullable Editor editor) {
        KtCallExpression assertionErrorCall;
        KtCallExpression ktCallExpression;
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtValueArgument messageFunctionExpr;
        KtValueArgument ktValueArgument;
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        List<KtValueArgument> args = element2.getValueArguments();
        Object object = args.get(0);
        if (object == null || (object = ((KtValueArgument)object).getArgumentExpression()) == null || (object = object.getText()) == null) {
            return;
        }
        Object conditionText = object;
        KtLambdaArgument functionLiteralArgument = (KtLambdaArgument)CollectionsKt.singleOrNull(element2.getLambdaArguments());
        BindingContext bindingContext2 = ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element2, false, 2, null);
        if (args.size() == 2) {
            ktElement = args.get(1);
            if (ktElement == null || (ktElement = ((KtValueArgument)ktElement).getArgumentExpression()) == null) {
                return;
            }
        } else {
            ktElement = functionLiteralArgument != null ? (KtExpression)functionLiteralArgument.getLambdaExpression() : null;
        }
        if (!((ktValueArgument = (messageFunctionExpr = ktElement)) instanceof KtLambdaExpression)) {
            ktValueArgument = null;
        }
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)((Object)ktValueArgument);
        if (ktLambdaExpression != null) {
            KtLambdaExpression ktLambdaExpression2;
            KtLambdaExpression it = ktLambdaExpression2 = ktLambdaExpression;
            ktExpression2 = this.extractMessageSingleExpression(it, bindingContext2);
        } else {
            ktExpression2 = null;
        }
        KtExpression extractedMessageSingleExpr = ktExpression2;
        boolean messageIsFunction = extractedMessageSingleExpr == null && this.messageIsFunction(element2, bindingContext2);
        KtElement ktElement2 = extractedMessageSingleExpr;
        if (ktElement2 == null) {
            ktElement2 = ktExpression = messageFunctionExpr;
        }
        if (ktElement2 == null) {
            ktExpression = psiFactory.createExpression("\"Assertion failed\"");
        }
        KtExpression messageExpr = ktExpression;
        KtIfExpression ifExpression2 = this.replaceWithIfThenThrowExpression(element2);
        KtExpression ktExpression3 = ifExpression2.getThen();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ifExpression.then!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktExpression3, null, 2, null);
        KtExpression ktExpression4 = ifExpression2.getCondition();
        if (ktExpression4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        KtPrefixExpression ifCondition = (KtPrefixExpression)ktExpression4;
        KtExpression ktExpression5 = ifCondition.getBaseExpression();
        if (ktExpression5 == null) {
            Intrinsics.throwNpe();
        }
        ktExpression5.replace((PsiElement)psiFactory.createExpression((String)conditionText));
        KtExpression ktExpression6 = ifExpression2.getThen();
        if (ktExpression6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        Object object2 = CollectionsKt.single(((KtBlockExpression)ktExpression6).getStatements());
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThrowExpression");
        }
        KtExpression thrownExpression = ((KtThrowExpression)object2).getThrownExpression();
        KtExpression ktExpression7 = thrownExpression;
        if (!(ktExpression7 instanceof KtCallExpression)) {
            ktExpression7 = null;
        }
        if ((ktCallExpression = (KtCallExpression)ktExpression7) == null) {
            KtExpression ktExpression8 = thrownExpression;
            if (ktExpression8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            }
            KtExpression ktExpression9 = ((KtDotQualifiedExpression)ktExpression8).getSelectorExpression();
            if (ktExpression9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            ktCallExpression = assertionErrorCall = (KtCallExpression)ktExpression9;
        }
        String string = messageIsFunction && messageExpr instanceof KtCallableReferenceExpression ? ((KtCallableReferenceExpression)messageExpr).getCallableReference().getText() + "()" : (messageIsFunction ? messageExpr.getText() + "()" : messageExpr.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (messageIsFunction &&\u2026pr.text\n                }");
        KtExpression message2 = psiFactory.createExpression(string);
        KtExpression ktExpression10 = ((KtValueArgument)CollectionsKt.single(assertionErrorCall.getValueArguments())).getArgumentExpression();
        if (ktExpression10 == null) {
            Intrinsics.throwNpe();
        }
        ktExpression10.replace((PsiElement)message2);
        this.simplifyConditionIfPossible(ifExpression2, editor);
    }

    private final KtExpression extractMessageSingleExpression(KtLambdaExpression functionLiteral, BindingContext bindingContext2) {
        Object object;
        Object singleStatement;
        Object object2;
        Object it;
        Object object3 = functionLiteral.getBodyExpression();
        return object3 != null && (object3 = ((KtBlockExpression)object3).getStatements()) != null && (object3 = (KtExpression)CollectionsKt.singleOrNull((List)object3)) != null ? (BindingContextUtilsKt.isUsedAsExpression((KtExpression)(it = (object2 = (singleStatement = (object = object3)))), bindingContext2) ? object2 : null) : null;
    }

    private final boolean messageIsFunction(KtCallExpression callExpr, BindingContext bindingContext2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpr, bindingContext2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> valParameters = resolvedCall3.getResultingDescriptor().getValueParameters();
        return valParameters.size() > 1 && !KotlinBuiltIns.isAny(valParameters.get(1).getType());
    }

    private final void simplifyConditionIfPossible(KtIfExpression ifExpression2, Editor editor) {
        KtExpression ktExpression = ifExpression2.getCondition();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        SimplifyNegatedBinaryExpressionIntention simplifier = new SimplifyNegatedBinaryExpressionIntention();
        KtPrefixExpression condition2 = (KtPrefixExpression)ktExpression;
        if (simplifier.isApplicableTo(condition2)) {
            simplifier.applyTo(condition2, editor);
        }
    }

    private final KtIfExpression replaceWithIfThenThrowExpression(KtCallExpression original) {
        KtExpression ktExpression;
        block14: {
            Object object;
            PsiElement result$iv;
            PsiElement $receiver$iv;
            KtIfExpression replacement;
            block13: {
                Object object2;
                KtExpression ktExpression2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)original, false, 2, null).createExpression("if (!true) { throw kotlin.AssertionError(\"\") }");
                if (ktExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                }
                replacement = (KtIfExpression)ktExpression2;
                PsiElement parent2 = original.getParent();
                PsiElement psiElement2 = parent2;
                if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                    psiElement2 = null;
                }
                if ((ktExpression = (KtDotQualifiedExpression)psiElement2) == null) break block13;
                $receiver$iv = (PsiElement)ktExpression;
                result$iv = $receiver$iv.replace((PsiElement)replacement);
                if (result$iv instanceof KtIfExpression) {
                    object2 = result$iv;
                } else {
                    PsiElement psiElement3 = result$iv;
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement3).getExpression();
                    if (ktExpression3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                    }
                    object2 = (KtIfExpression)ktExpression3;
                }
                if ((ktExpression = (KtIfExpression)object2) != null) break block14;
            }
            if ((result$iv = ($receiver$iv = (PsiElement)original).replace((PsiElement)replacement)) instanceof KtIfExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement4 = result$iv;
                if (psiElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression4 = ((KtParenthesizedExpression)psiElement4).getExpression();
                if (ktExpression4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                }
                object = (KtIfExpression)ktExpression4;
            }
            ktExpression = (KtIfExpression)object;
        }
        return ktExpression;
    }

    public ConvertAssertToIfWithThrowIntention() {
        super(KtCallExpression.class, "Replace 'assert' with 'if' statement", null, 4, null);
    }
}

