/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J@\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u000e0\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KotlinSelectInProjectViewProvider;", "Lcom/intellij/ide/projectView/SelectableTreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileInRoots", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getData", "", "selected", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "dataName", "", "getTopLevelElement", "Lcom/intellij/psi/PsiElement;", "element", "modify", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "isSelectable", "idea"})
public final class KotlinSelectInProjectViewProvider
implements SelectableTreeStructureProvider,
DumbAware {
    private final Project project;

    @Nullable
    public Object getData(@NotNull Collection<? extends AbstractTreeNode<Object>> selected, @NotNull String dataName) {
        Intrinsics.checkParameterIsNotNull(selected, (String)"selected");
        Intrinsics.checkParameterIsNotNull((Object)dataName, (String)"dataName");
        return null;
    }

    @NotNull
    public Collection<AbstractTreeNode<? extends Object>> modify(@NotNull AbstractTreeNode<Object> parent2, @NotNull Collection<? extends AbstractTreeNode<Object>> children2, @NotNull ViewSettings settings2) {
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull(children2, (String)"children");
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        return new ArrayList<AbstractTreeNode<Object>>(children2);
    }

    @Nullable
    public PsiElement getTopLevelElement(@NotNull PsiElement element2) {
        PsiElement psiElement2;
        Object v2;
        VirtualFile virtualFile2;
        KtFile file2;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (!element2.isValid()) {
                return null;
            }
            PsiFile psiFile = element2.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return null;
            }
            file2 = ktFile;
            virtualFile2 = file2.getVirtualFile();
            if (!this.fileInRoots(virtualFile2)) {
                return (PsiElement)file2;
            }
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParentsWithSelf(element2);
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!this.isSelectable(it)) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        PsiElement current = v2;
        if (current instanceof KtFile) {
            Object nameWithoutExtension;
            KtDeclaration declaration2 = (KtDeclaration)CollectionsKt.singleOrNull(((KtFile)current).getDeclarations());
            Object object = virtualFile2;
            if (object == null || (object = object.getNameWithoutExtension()) == null) {
                object = nameWithoutExtension = file2.getName();
            }
            if (declaration2 instanceof KtClassOrObject && Intrinsics.areEqual((Object)nameWithoutExtension, (Object)((KtClassOrObject)declaration2).getName())) {
                current = declaration2;
            }
        }
        if ((psiElement2 = current) == null) {
            psiElement2 = (PsiElement)file2;
        }
        return psiElement2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSelectable(@NotNull PsiElement $receiver) {
        PsiElement psiElement2 = $receiver;
        if (psiElement2 instanceof KtFile) {
            return true;
        }
        if (!(psiElement2 instanceof KtDeclaration)) return false;
        if (((KtDeclaration)$receiver).getParent() instanceof KtFile) return true;
        PsiElement psiElement3 = ((KtDeclaration)$receiver).getParent();
        if (!(psiElement3 instanceof KtClassBody)) {
            psiElement3 = null;
        }
        KtClassBody ktClassBody = (KtClassBody)psiElement3;
        Object object = ktClassBody != null ? ktClassBody.getParent() : null;
        if (!(object instanceof KtClassOrObject)) {
            object = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)object;
        if (ktClassOrObject == null) return false;
        boolean bl = this.isSelectable(ktClassOrObject);
        if (!bl) return false;
        return true;
    }

    private final boolean fileInRoots(VirtualFile file2) {
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        return file2 != null && (index2.isInSourceContent(file2) || index2.isInLibraryClasses(file2) || index2.isInLibrarySource(file2));
    }

    public KotlinSelectInProjectViewProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

