/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KotlinStringLiteralTextEscaper;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtStringTemplateExpression
extends KtExpressionImpl
implements PsiLanguageInjectionHost {
    private static final TokenSet CLOSE_QUOTE_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.CLOSING_QUOTE});

    public KtStringTemplateExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "accept"));
        }
        return visitor2.visitStringTemplateExpression(this, data);
    }

    @NotNull
    public KtStringTemplateEntry[] getEntries() {
        KtStringTemplateEntry[] ktStringTemplateEntryArray = (KtStringTemplateEntry[])this.findChildrenByClass(KtStringTemplateEntry.class);
        if (ktStringTemplateEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "getEntries"));
        }
        return ktStringTemplateEntryArray;
    }

    public boolean isValidHost() {
        return this.getNode().getChildren(CLOSE_QUOTE_TOKEN_SET).length != 0;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "updateText"));
        }
        KtExpression newExpression2 = new KtPsiFactory(this.getProject()).createExpressionIfPossible(text2);
        if (newExpression2 instanceof KtStringTemplateExpression) {
            return (KtStringTemplateExpression)this.replace((PsiElement)newExpression2);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text2);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        KotlinStringLiteralTextEscaper kotlinStringLiteralTextEscaper = new KotlinStringLiteralTextEscaper(this);
        if (kotlinStringLiteralTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtStringTemplateExpression", "createLiteralTextEscaper"));
        }
        return kotlinStringLiteralTextEscaper;
    }

    public boolean hasInterpolation() {
        for (PsiElement child : this.getChildren()) {
            if (!(child instanceof KtSimpleNameStringTemplateEntry) && !(child instanceof KtBlockStringTemplateEntry)) continue;
            return true;
        }
        return false;
    }
}

