/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.configurable.VcsManagerConfigurable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.GeneralSettingsPanel;
import org.jetbrains.idea.svn.NetworkSettingsPanel;
import org.jetbrains.idea.svn.PresentationSettingsPanel;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.dialogs.SshSettingsPanel;

public abstract class SvnConfigurable
extends ConfigurableBase<ConfigurableUi<SvnConfiguration>, SvnConfiguration> {
    public static final String DISPLAY_NAME = "Subversion";
    public static final String ID = VcsManagerConfigurable.getVcsConfigurableId((String)"Subversion");
    @NonNls
    private static final String HELP_ID = "project.propSubversion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Supplier<? extends ConfigurableUi<SvnConfiguration>> myUiSupplier;

    protected SvnConfigurable(@NotNull Project project, @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        if (uiSupplier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSupplier", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        this(project, ID + "." + displayName, displayName, uiSupplier, "project.propSubversion." + displayName);
    }

    protected SvnConfigurable(@NotNull Project project, @NotNull String id, @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier, @NotNull String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        if (uiSupplier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSupplier", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "org/jetbrains/idea/svn/SvnConfigurable", "<init>"));
        }
        super(id, displayName, helpId);
        this.myProject = project;
        this.myUiSupplier = uiSupplier;
    }

    protected ConfigurableUi<SvnConfiguration> createUi() {
        return this.myUiSupplier.get();
    }

    @NotNull
    protected SvnConfiguration getSettings() {
        SvnConfiguration svnConfiguration = SvnConfiguration.getInstance(this.myProject);
        if (svnConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfigurable", "getSettings"));
        }
        return svnConfiguration;
    }

    public static void selectConfigurationDirectory(@NotNull String path, @NotNull Consumer<String> dirConsumer, Project project, @Nullable Component component) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnConfigurable", "selectConfigurationDirectory"));
        }
        if (dirConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirConsumer", "org/jetbrains/idea/svn/SvnConfigurable", "selectConfigurationDirectory"));
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(SvnBundle.message("dialog.title.select.configuration.directory", new Object[0])).withDescription(SvnBundle.message("dialog.description.select.configuration.directory", new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false).withShowHiddenFiles(true);
        path = "file://" + path.replace(File.separatorChar, '/');
        VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(path);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)component, (Project)project, (VirtualFile)root);
        if (file == null) {
            return;
        }
        String resultPath = file.getPath().replace('/', File.separatorChar);
        dirConsumer.consume((Object)resultPath);
    }

    public static class Ssh
    extends SvnConfigurable {
        public Ssh(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Ssh", "<init>"));
            }
            super(project, "SSH", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Ssh", "lambda$new$0"));
                }
                return new SshSettingsPanel(project);
            });
        }
    }

    public static class Network
    extends SvnConfigurable {
        public Network(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Network", "<init>"));
            }
            super(project, "Network", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Network", "lambda$new$0"));
                }
                return new NetworkSettingsPanel(project);
            });
        }
    }

    public static class Presentation
    extends SvnConfigurable {
        public Presentation(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Presentation", "<init>"));
            }
            super(project, "Presentation", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Presentation", "lambda$new$0"));
                }
                return new PresentationSettingsPanel(project);
            });
        }
    }

    public static class General
    extends SvnConfigurable {
        public General(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$General", "<init>"));
            }
            super(project, ID, SvnConfigurable.DISPLAY_NAME, () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$General", "lambda$new$0"));
                }
                return new GeneralSettingsPanel(project);
            }, SvnConfigurable.HELP_ID);
        }
    }
}

