/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;

public class SvnMapping {
    private static final Comparator<String> FILE_PATHS_COMPARATOR = (path1, path2) -> FileUtil.comparePaths((String)path1, (String)path2);
    @NotNull
    private final List<VirtualFile> myLonelyRoots = ContainerUtil.newArrayList();
    @NotNull
    private final TreeMap<String, RootUrlInfo> myFile2UrlMap = new TreeMap(FILE_PATHS_COMPARATOR);
    @NotNull
    private final Map<String, RootUrlInfo> myUrl2FileMap = ContainerUtilRt.newHashMap();
    @NotNull
    private final ClearableLazyValue<List<VirtualFile>> myPreCalculatedUnderVcsRoots = new ClearableLazyValue<List<VirtualFile>>(){

        @NotNull
        protected List<VirtualFile> compute() {
            List list = ContainerUtil.map(SvnMapping.this.myFile2UrlMap.values(), RootUrlInfo::getVirtualFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnMapping$1", "compute"));
            }
            return list;
        }
    };

    public void copyFrom(@NotNull SvnMapping other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/idea/svn/SvnMapping", "copyFrom"));
        }
        this.myFile2UrlMap.clear();
        this.myUrl2FileMap.clear();
        this.myLonelyRoots.clear();
        this.myFile2UrlMap.putAll(other.myFile2UrlMap);
        this.myUrl2FileMap.putAll(other.myUrl2FileMap);
        this.myLonelyRoots.addAll(other.myLonelyRoots);
        this.myPreCalculatedUnderVcsRoots.drop();
    }

    public void addAll(@NotNull Collection<RootUrlInfo> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/idea/svn/SvnMapping", "addAll"));
        }
        roots.forEach(this::add);
    }

    public void add(@NotNull RootUrlInfo rootInfo) {
        if (rootInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootInfo", "org/jetbrains/idea/svn/SvnMapping", "add"));
        }
        this.myFile2UrlMap.put(rootInfo.getPath(), rootInfo);
        this.myUrl2FileMap.put(rootInfo.getAbsoluteUrl(), rootInfo);
    }

    @NotNull
    public List<VirtualFile> getUnderVcsRoots() {
        List list = (List)this.myPreCalculatedUnderVcsRoots.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnMapping", "getUnderVcsRoots"));
        }
        return list;
    }

    @NotNull
    public List<RootUrlInfo> getAllCopies() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myFile2UrlMap.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnMapping", "getAllCopies"));
        }
        return arrayList;
    }

    @Nullable
    public String getRootForPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnMapping", "getRootForPath"));
        }
        return (String)ContainerUtil.find(this.myFile2UrlMap.headMap(path, true).descendingKeySet(), root -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnMapping", "lambda$getRootForPath$1"));
            }
            return SystemInfo.isFileSystemCaseSensitive ? path.startsWith((String)root) : StringUtil.startsWithIgnoreCase((String)path, (String)root);
        });
    }

    @NotNull
    public Collection<String> getUrls() {
        Set<String> set = this.myUrl2FileMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnMapping", "getUrls"));
        }
        return set;
    }

    @Nullable
    public RootUrlInfo byFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnMapping", "byFile"));
        }
        return this.myFile2UrlMap.get(path);
    }

    @Nullable
    public RootUrlInfo byUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/SvnMapping", "byUrl"));
        }
        return this.myUrl2FileMap.get(url);
    }

    public boolean isEmpty() {
        return this.myUrl2FileMap.isEmpty();
    }

    public void reportLonelyRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/idea/svn/SvnMapping", "reportLonelyRoots"));
        }
        this.myLonelyRoots.addAll(roots);
    }

    @NotNull
    public List<VirtualFile> getLonelyRoots() {
        List<VirtualFile> list = this.myLonelyRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnMapping", "getLonelyRoots"));
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnMapping mapping = (SvnMapping)o;
        if (!this.myFile2UrlMap.equals(mapping.myFile2UrlMap)) {
            return false;
        }
        if (!this.myLonelyRoots.equals(mapping.myLonelyRoots)) {
            return false;
        }
        return this.myUrl2FileMap.equals(mapping.myUrl2FileMap);
    }

    public int hashCode() {
        int result = this.myLonelyRoots.hashCode();
        result = 31 * result + this.myFile2UrlMap.hashCode();
        result = 31 * result + this.myUrl2FileMap.hashCode();
        return result;
    }
}

