/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRecursiveStatusWalker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnRecursiveStatusWalker");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @Nullable
    private final ProgressIndicator myProgress;
    @NotNull
    private final StatusReceiver myReceiver;
    @NotNull
    private final LinkedList<MyItem> myQueue;
    @NotNull
    private final MyHandler myHandler;
    @Nullable
    private ISVNStatusFileProvider myFileProvider;

    public SvnRecursiveStatusWalker(@NotNull SvnVcs vcs, @NotNull StatusReceiver receiver, @Nullable ProgressIndicator progress) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "<init>"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "<init>"));
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myReceiver = receiver;
        this.myProgress = progress;
        this.myQueue = new LinkedList();
        this.myHandler = new MyHandler();
    }

    public void setFileProvider(@Nullable ISVNStatusFileProvider fileProvider) {
        this.myFileProvider = fileProvider;
    }

    public void go(@NotNull FilePath rootPath, @NotNull Depth depth) throws SvnBindException {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "go"));
        }
        if (depth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "go"));
        }
        this.myQueue.add(this.createItem(rootPath, depth, false));
        while (!this.myQueue.isEmpty()) {
            this.checkCanceled();
            MyItem item = this.myQueue.removeFirst();
            try {
                if (item.getPath().isDirectory()) {
                    this.processDirectory(item);
                    continue;
                }
                this.processFile(item);
            }
            catch (SvnBindException e) {
                this.handleStatusException(item, e);
            }
        }
    }

    private void processDirectory(@NotNull MyItem item) throws SvnBindException {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "processDirectory"));
        }
        File ioFile = item.getPath().getIOFile();
        this.myHandler.setCurrentItem(item);
        item.getClient().doStatus(ioFile, SVNRevision.WORKING, item.getDepth(), false, false, true, true, this.myHandler, null);
        if (!this.myHandler.myMetCurrentItem) {
            this.myHandler.checkIfCopyRootWasReported(this.myHandler.getCurrentItemStatus());
        }
    }

    private void processFile(@NotNull MyItem item) throws SvnBindException {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "processFile"));
        }
        try {
            this.myReceiver.process(item.getPath(), item.getClient().doStatus(item.getPath().getIOFile(), false));
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    public boolean isIgnoredByVcs(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "isIgnoredByVcs"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "lambda$isIgnoredByVcs$0"));
            }
            if (this.myVcs.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return this.myVcsManager.isIgnored(vFile);
        });
    }

    public boolean isIgnoredIdeaLevel(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "isIgnoredIdeaLevel"));
        }
        return this.myChangeListManager.isIgnoredFile(vFile);
    }

    private void handleStatusException(@NotNull MyItem item, @NotNull SvnBindException e) throws SvnBindException {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "handleStatusException"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "handleStatusException"));
        }
        if (e.contains(SVNErrorCode.WC_NOT_DIRECTORY) || e.contains(SVNErrorCode.WC_NOT_FILE) || e.contains(SVNErrorCode.WC_PATH_NOT_FOUND)) {
            VirtualFile virtualFile = item.getPath().getVirtualFile();
            if (virtualFile != null && !this.isIgnoredByVcs(virtualFile)) {
                this.myReceiver.processUnversioned(virtualFile);
                if (virtualFile.isDirectory()) {
                    this.processRecursively(virtualFile, item.getDepth());
                }
            }
        } else {
            throw e;
        }
    }

    private void processRecursively(@NotNull VirtualFile vFile, @NotNull Depth prevDepth) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "processRecursively"));
        }
        if (prevDepth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevDepth", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "processRecursively"));
        }
        if (Depth.EMPTY.equals((Object)prevDepth)) {
            return;
        }
        if (this.isIgnoredIdeaLevel(vFile)) {
            this.myReceiver.processIgnored(vFile);
            return;
        }
        final Depth newDepth = Depth.INFINITY.equals((Object)prevDepth) ? Depth.INFINITY : Depth.EMPTY;
        VirtualFileVisitor.Option[] options = newDepth.equals((Object)Depth.EMPTY) ? (VirtualFileVisitor.Option[])ContainerUtil.ar((Object[])new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, VirtualFileVisitor.ONE_LEVEL_DEEP}) : new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(options){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$1", "visitFileEx"));
                }
                if (SvnRecursiveStatusWalker.this.isIgnoredIdeaLevel(file)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(file);
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$1", "visitFileEx"));
                    }
                    return result;
                }
                if (file.isDirectory() && file.findChild(SvnUtil.SVN_ADMIN_DIR_NAME) != null) {
                    SvnRecursiveStatusWalker.this.myQueue.add(SvnRecursiveStatusWalker.this.createItem(VcsUtil.getFilePath((VirtualFile)file), newDepth, true));
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$1", "visitFileEx"));
                    }
                    return result;
                }
                SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(file);
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$1", "visitFileEx"));
                }
                return result;
            }
        });
    }

    @NotNull
    private MyItem createItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createItem"));
        }
        if (depth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createItem"));
        }
        StatusClient statusClient = this.myVcs.getFactory(path.getIOFile()).createStatusClient(this.myFileProvider, this.createEventHandler());
        MyItem myItem = new MyItem(path, depth, isInnerCopyRoot, statusClient);
        if (myItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createItem"));
        }
        return myItem;
    }

    @NotNull
    public ProgressTracker createEventHandler() {
        ProgressTracker progressTracker = new ProgressTracker(){

            public void consume(ProgressEvent event) throws SVNException {
            }

            @Override
            public void checkCancelled() throws SVNCancelException {
                SvnRecursiveStatusWalker.this.checkCanceled();
            }
        };
        if (progressTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createEventHandler"));
        }
        return progressTracker;
    }

    private class MyHandler
    implements StatusConsumer {
        private MyItem myCurrentItem;
        private boolean myMetCurrentItem;

        private MyHandler() {
        }

        public void setCurrentItem(@NotNull MyItem currentItem) {
            if (currentItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentItem", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyHandler", "setCurrentItem"));
            }
            this.myCurrentItem = currentItem;
            this.myMetCurrentItem = false;
        }

        public void checkIfCopyRootWasReported(@Nullable Status status) {
            if (!this.myMetCurrentItem && status != null && FileUtil.filesEqual((File)status.getFile(), (File)this.myCurrentItem.getPath().getIOFile())) {
                this.myMetCurrentItem = true;
                this.processCurrentItem(status);
            }
        }

        @Nullable
        public Status getCurrentItemStatus() {
            Status result = null;
            try {
                result = this.myCurrentItem.getClient().doStatus(this.myCurrentItem.getPath().getIOFile(), false);
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
            return result;
        }

        public void processCurrentItem(@NotNull Status status) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyHandler", "processCurrentItem"));
            }
            StatusType nodeStatus = status.getNodeStatus();
            FilePath path = this.myCurrentItem.getPath();
            VirtualFile vf = path.getVirtualFile();
            if (vf != null) {
                if (StatusType.STATUS_IGNORED.equals((Object)nodeStatus)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                } else if (StatusType.STATUS_UNVERSIONED.equals((Object)nodeStatus) || StatusType.UNKNOWN.equals((Object)nodeStatus)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                    SvnRecursiveStatusWalker.this.processRecursively(vf, this.myCurrentItem.getDepth());
                } else if (!StatusType.OBSTRUCTED.equals((Object)nodeStatus) && !StatusType.STATUS_NONE.equals((Object)nodeStatus)) {
                    if (this.myCurrentItem.isIsInnerCopyRoot()) {
                        SvnRecursiveStatusWalker.this.myReceiver.processCopyRoot(vf, status.getURL(), SvnRecursiveStatusWalker.this.myVcs.getWorkingCopyFormat(path.getIOFile()), status.getRepositoryRootURL());
                    } else {
                        SvnRecursiveStatusWalker.this.myReceiver.bewareRoot(vf, status.getURL());
                    }
                }
            }
        }

        public void consume(Status status) throws SVNException {
            SvnRecursiveStatusWalker.this.checkCanceled();
            File ioFile = status.getFile();
            this.checkIfCopyRootWasReported(status);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            if (vFile != null && SvnRecursiveStatusWalker.this.isIgnoredByVcs(vFile)) {
                return;
            }
            if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null && status.is(StatusType.STATUS_UNVERSIONED)) {
                if (vFile.isDirectory()) {
                    if (!FileUtil.filesEqual((File)this.myCurrentItem.getPath().getIOFile(), (File)ioFile)) {
                        SvnRecursiveStatusWalker.this.myQueue.add(SvnRecursiveStatusWalker.this.createItem(VcsUtil.getFilePath((VirtualFile)vFile), Depth.INFINITY, true));
                    }
                } else {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vFile);
                }
            } else {
                SvnRecursiveStatusWalker.this.myReceiver.process(VcsUtil.getFilePath((File)ioFile, (boolean)status.getKind().isDirectory()), status);
            }
        }
    }

    private static class MyItem {
        @NotNull
        private final FilePath myPath;
        @NotNull
        private final Depth myDepth;
        @NotNull
        private final StatusClient myStatusClient;
        private final boolean myIsInnerCopyRoot;

        private MyItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot, @NotNull StatusClient statusClient) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "<init>"));
            }
            if (depth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "<init>"));
            }
            if (statusClient == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusClient", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "<init>"));
            }
            this.myPath = path;
            this.myDepth = depth;
            this.myStatusClient = statusClient;
            this.myIsInnerCopyRoot = isInnerCopyRoot;
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "getPath"));
            }
            return filePath;
        }

        @NotNull
        public Depth getDepth() {
            Depth depth = this.myDepth;
            if (depth == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "getDepth"));
            }
            return depth;
        }

        @NotNull
        public StatusClient getClient() {
            StatusClient statusClient = this.myStatusClient;
            if (statusClient == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "getClient"));
            }
            return statusClient;
        }

        public boolean isIsInnerCopyRoot() {
            return this.myIsInnerCopyRoot;
        }
    }
}

