/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public class SvnKitStatusClient
extends BaseSvnClient
implements StatusClient {
    private SVNStatusClient myStatusClient;
    @Nullable
    private final ISVNStatusFileProvider myProvider;
    @Nullable
    private final ProgressTracker myHandler;

    public SvnKitStatusClient() {
        this(null, null);
    }

    public SvnKitStatusClient(@Nullable ISVNStatusFileProvider provider, @Nullable ProgressTracker handler) {
        this.myProvider = provider;
        this.myHandler = handler;
    }

    @Override
    public long doStatus(@NotNull File path, @Nullable SVNRevision revision, @NotNull Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, @NotNull StatusConsumer handler, @Nullable Collection changeLists) throws SvnBindException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "doStatus"));
        }
        if (depth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "doStatus"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "doStatus"));
        }
        try {
            return this.getStatusClient().doStatus(path, revision, SvnKitStatusClient.toDepth(depth), remote, reportAll, includeIgnored, collectParentExternals, status -> {
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "lambda$doStatus$0"));
                }
                handler.consume(Status.create(status));
            }, changeLists);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    @Nullable
    public Status doStatus(@NotNull File path, boolean remote) throws SvnBindException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "doStatus"));
        }
        try {
            return Status.create(this.getStatusClient().doStatus(path, remote));
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private SVNStatusClient getStatusClient() {
        SVNStatusClient sVNStatusClient = this.myHandler != null || this.myProvider != null ? this.ensureStatusClient() : this.myVcs.getSvnKitManager().createStatusClient();
        if (sVNStatusClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "getStatusClient"));
        }
        return sVNStatusClient;
    }

    @NotNull
    private SVNStatusClient ensureStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = this.myVcs.getSvnKitManager().createStatusClient();
            this.myStatusClient.setFilesProvider(this.myProvider);
            this.myStatusClient.setEventHandler(SvnKitStatusClient.toEventHandler(this.myHandler));
        }
        SVNStatusClient sVNStatusClient = this.myStatusClient;
        if (sVNStatusClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/SvnKitStatusClient", "ensureStatusClient"));
        }
        return sVNStatusClient;
    }
}

