/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.AddHandler;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsFileOperationsHandler;
import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.cvsSupport2.application.DeleteHandler;
import com.intellij.cvsSupport2.application.DeletedCVSDirectoryStorage;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CvsStorageSupportingDeletionComponent
extends CvsStorageComponent
implements CommandListener {
    private static final Logger LOG = Logger.getInstance(CvsStorageSupportingDeletionComponent.class);
    private Project myProject;
    private DeletedCVSDirectoryStorage myDeletedStorage;
    private DeleteHandler myDeleteHandler = null;
    private AddHandler myAddHandler = null;
    private CvsFileOperationsHandler myFileOperationsHandler;
    private int myCommandLevel = 0;
    private boolean myAnotherProjectCommand = false;
    static final Key<AbstractVcs> FILE_VCS = new Key("File VCS");

    public void commandStarted(CommandEvent event) {
        ++this.myCommandLevel;
        if (this.myCommandLevel == 1) {
            boolean bl = this.myAnotherProjectCommand = event.getProject() != null != (event.getProject() == this.myProject);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Started" + event.getCommandName() + ", commandLevel: " + this.myCommandLevel);
        }
    }

    public void commandFinished(CommandEvent event) {
        --this.myCommandLevel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished" + event.getCommandName() + ", commandLevel: " + this.myCommandLevel);
        }
        this.execute();
    }

    @Override
    public void init(Project project, boolean sync) {
        this.myProject = project;
        this.initializeDeletedStorage();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
        CvsEntriesManager.getInstance().registerAsVirtualFileListener();
        CommandProcessor.getInstance().addCommandListener((CommandListener)this);
        this.myFileOperationsHandler = new CvsFileOperationsHandler(project, this);
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this.myFileOperationsHandler);
        this.myIsActive = true;
    }

    @Override
    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
        CvsEntriesManager.getInstance().unregisterAsVirtualFileListener();
        CommandProcessor.getInstance().removeCommandListener((CommandListener)this);
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this.myFileOperationsHandler);
        this.myFileOperationsHandler = null;
        this.myIsActive = false;
        this.myProject = null;
    }

    public DeleteHandler getDeleteHandler() {
        if (this.myDeleteHandler == null) {
            this.myDeleteHandler = this.myDeletedStorage.createDeleteHandler(this.myProject, this);
        }
        return this.myDeleteHandler;
    }

    private boolean shouldProcessEvent(VirtualFileEvent event, boolean parentShouldBeUnderCvs) {
        if (this.myAnotherProjectCommand) {
            return false;
        }
        VirtualFile file = event.getFile();
        if (this.disabled(file) || event.isFromRefresh() || CvsStorageSupportingDeletionComponent.isStorageEvent(event) || !this.isUnderCvsManagedModuleRoot(file)) {
            return false;
        }
        return !parentShouldBeUnderCvs || CvsStorageSupportingDeletionComponent.parentIsUnderCvs(file);
    }

    private static boolean isStorageEvent(VirtualFileEvent event) {
        return event.getRequestor() instanceof DeletedCVSDirectoryStorage;
    }

    private static boolean parentIsUnderCvs(VirtualFile file) {
        return CvsUtil.fileIsUnderCvs(file.getParent());
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent", "fileMoved"));
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    private boolean processMoveOrRename() {
        return this.myDeleteHandler != null;
    }

    private AbstractVcs getFileVcs(VirtualFile file) {
        AbstractVcs storedData = (AbstractVcs)file.getUserData(FILE_VCS);
        if (storedData != null) {
            return storedData;
        }
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
    }

    private boolean isUnderCvsManagedModuleRoot(VirtualFile file) {
        return this.getFileVcs(file) == CvsVcs2.getInstance(this.myProject);
    }

    private boolean disabled(VirtualFile file) {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file) != CvsVcs2.getInstance(this.myProject);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent", "beforePropertyChange"));
        }
        if (!event.getPropertyName().equals("name")) {
            return;
        }
        if (!CvsUtil.fileIsUnderCvs(event.getFile())) {
            return;
        }
        this.beforeFileDeletion((VirtualFileEvent)event);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent", "propertyChanged"));
        }
        if (this.processMoveOrRename()) {
            this.fileDeleted((VirtualFileEvent)event);
            this.fileCreated((VirtualFileEvent)event);
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent", "fileCreated"));
        }
        if (!this.shouldProcessEvent(event, false)) {
            return;
        }
        Project project = this.myProject;
        if (project == null) {
            return;
        }
        VirtualFile file = event.getFile();
        if (this.myDeleteHandler != null) {
            this.myDeleteHandler.removeDeletedRoot(file);
        }
        this.myDeletedStorage.checkNeedForPurge(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        this.deleteIfAdminDirCreated(file);
        this.getAddHandler().addFile(file);
        this.execute();
    }

    public AddHandler getAddHandler() {
        if (this.myAddHandler == null) {
            this.myAddHandler = new AddHandler(this.myProject, this);
        }
        return this.myAddHandler;
    }

    private void execute() {
        if (this.myCommandLevel > 0) {
            return;
        }
        if (!this.myAnotherProjectCommand) {
            if (this.myDeleteHandler != null) {
                this.myDeleteHandler.execute();
            }
            if (this.myAddHandler != null) {
                this.myAddHandler.execute();
            }
        }
        this.myAnotherProjectCommand = false;
        this.myDeleteHandler = null;
        this.myAddHandler = null;
    }

    private void initializeDeletedStorage() {
        File storageRoot = CvsStorageSupportingDeletionComponent.getStorageRoot();
        storageRoot.mkdirs();
        this.myDeletedStorage = new DeletedCVSDirectoryStorage(storageRoot);
    }

    private static File getStorageRoot() {
        return new File(PathManager.getSystemPath(), "CVS-TO-DELETE");
    }

    public void sync() {
    }

    public static CvsStorageComponent getInstance(Project project) {
        return (CvsStorageComponent)PeriodicalTasksCloser.getInstance().safeGetService(project, CvsStorageComponent.class);
    }

    @Override
    public void deleteIfAdminDirCreated(VirtualFile addedFile) {
        this.myDeletedStorage.deleteIfAdminDirCreated(addedFile);
    }
}

