/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.GroupBasedTestClassFilter;
import com.intellij.PatternListTestClassFilter;
import com.intellij.TestAll;
import com.intellij.TestClassesFilter;
import com.intellij.idea.Bombed;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.JITSensitive;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseLoader {
    public static final String PERFORMANCE_TESTS_ONLY_FLAG = "idea.performance.tests";
    public static final String INCLUDE_PERFORMANCE_TESTS_FLAG = "idea.include.performance.tests";
    public static final String INCLUDE_UNCONVENTIONALLY_NAMED_TESTS_FLAG = "idea.include.unconventionally.named.tests";
    private static final String ALL_TESTS_GROUP = "ALL";
    private final List<Class> myClassList = new ArrayList<Class>();
    private final List<Throwable> myClassLoadingErrors = new ArrayList<Throwable>();
    private Class myFirstTestClass;
    private Class myLastTestClass;
    private final TestClassesFilter myTestClassesFilter;
    private final boolean myForceLoadPerformanceTests;
    private static final List<String> ourRankList = TestCaseLoader.getTeamCityRankList();

    public TestCaseLoader(String classFilterName) {
        this(classFilterName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestCaseLoader(String classFilterName, boolean forceLoadPerformanceTests) {
        this.myForceLoadPerformanceTests = forceLoadPerformanceTests;
        String patterns = TestCaseLoader.getTestPatterns();
        if (!StringUtil.isEmpty((String)patterns)) {
            this.myTestClassesFilter = new PatternListTestClassFilter(StringUtil.split((String)patterns, (String)";"));
            System.out.println("Using patterns: [" + patterns + "]");
        } else {
            List<URL> groupingFileUrls = Collections.emptyList();
            if (!StringUtil.isEmpty((String)classFilterName)) {
                try {
                    groupingFileUrls = Collections.list(this.getClass().getClassLoader().getResources(classFilterName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            List<String> testGroupNames = TestCaseLoader.getTestGroups();
            MultiMap groups = MultiMap.createLinked();
            for (URL fileUrl : groupingFileUrls) {
                try (InputStreamReader reader = new InputStreamReader(fileUrl.openStream());){
                    groups.putAllValues(GroupBasedTestClassFilter.readGroups(reader));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Failed to load test groups from " + fileUrl);
                }
            }
            if (groups.isEmpty() || testGroupNames.contains(ALL_TESTS_GROUP)) {
                System.out.println("Using all classes");
                this.myTestClassesFilter = TestClassesFilter.ALL_CLASSES;
            } else {
                System.out.println("Using test groups: " + testGroupNames);
                this.myTestClassesFilter = new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
            }
        }
    }

    @Nullable
    private static String getTestPatterns() {
        return System.getProperty("intellij.build.test.patterns", System.getProperty("idea.test.patterns"));
    }

    @NotNull
    private static List<String> getTestGroups() {
        List list2 = StringUtil.split((String)System.getProperty("intellij.build.test.groups", System.getProperty("idea.test.group", "")).trim(), (String)";");
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/TestCaseLoader", "getTestGroups"));
        }
        return list2;
    }

    void addClassIfTestCase(Class testCaseClass, String moduleName) {
        if (this.shouldAddTestCase(testCaseClass, moduleName, true) && testCaseClass != this.myFirstTestClass && testCaseClass != this.myLastTestClass && PlatformTestUtil.canRunTest(testCaseClass)) {
            this.myClassList.add(testCaseClass);
        }
    }

    void addFirstTest(Class aClass) {
        assert (this.myFirstTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myFirstTestClass = aClass;
    }

    void addLastTest(Class aClass) {
        assert (this.myLastTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myLastTestClass = aClass;
    }

    private boolean shouldAddTestCase(Class<?> testCaseClass, String moduleName, boolean testForExcluded) {
        if ((testCaseClass.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (testForExcluded && this.shouldExcludeTestClass(moduleName, testCaseClass)) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && (suiteMethod.getModifiers() & 8) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestRunnerUtil.isJUnit4TestClass(testCaseClass);
    }

    private boolean shouldExcludeTestClass(String moduleName, Class testCaseClass) {
        if (!this.myForceLoadPerformanceTests && !TestAll.shouldIncludePerformanceTestCase(testCaseClass)) {
            return true;
        }
        String className = testCaseClass.getName();
        return !this.myTestClassesFilter.matches(className, moduleName) || TestCaseLoader.isBombed(testCaseClass);
    }

    public static boolean isBombed(AnnotatedElement element) {
        Bombed bombedAnnotation = element.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        return !PlatformTestUtil.bombExplodes(bombedAnnotation);
    }

    public void loadTestCases(String moduleName, Collection<String> classNamesIterator) {
        for (String className : classNamesIterator) {
            try {
                Class<?> candidateClass = Class.forName(className, false, this.getClass().getClassLoader());
                this.addClassIfTestCase(candidateClass, moduleName);
            }
            catch (Throwable e) {
                String message2 = "Cannot load class " + className + ": " + e.getMessage();
                System.err.println(message2);
                this.myClassLoadingErrors.add(new Throwable(message2, e));
            }
        }
    }

    public List<Throwable> getClassLoadingErrors() {
        return this.myClassLoadingErrors;
    }

    private static List<String> getTeamCityRankList() {
        if (TestAll.isPerformanceTestsRun()) {
            return Collections.emptyList();
        }
        String filePath = System.getProperty("teamcity.tests.recentlyFailedTests.file", null);
        if (filePath != null) {
            try {
                return FileUtil.loadLines((String)filePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static int getRank(Class aClass) {
        if (TestAll.isPerformanceTestsRun()) {
            return TestCaseLoader.moveToStart(aClass) ? 0 : 1;
        }
        int i2 = ourRankList.indexOf(aClass.getName());
        if (i2 != -1) {
            return i2;
        }
        return ourRankList.size();
    }

    private static boolean moveToStart(Class testClass) {
        return testClass.getAnnotation(JITSensitive.class) != null;
    }

    public List<Class> getClasses() {
        ArrayList<Class> result2 = new ArrayList<Class>(this.myClassList.size());
        result2.addAll(this.myClassList);
        Collections.sort(result2, Comparator.comparingInt(TestCaseLoader::getRank));
        if (this.myFirstTestClass != null) {
            result2.add(0, this.myFirstTestClass);
        }
        if (this.myLastTestClass != null) {
            result2.add(this.myLastTestClass);
        }
        return result2;
    }

    public void clearClasses() {
        this.myClassList.clear();
    }
}

