/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDescriptionsComboBox
extends ComboBox<ModuleDescription> {
    private final SortedComboBoxModel<ModuleDescription> myModel = new SortedComboBoxModel(Comparator.comparing(description -> description != null ? description.getName() : "", String.CASE_INSENSITIVE_ORDER));
    private boolean myAllowEmptySelection;

    public ModuleDescriptionsComboBox() {
        this.setModel((ComboBoxModel)this.myModel);
        new ComboboxSpeedSearch((JComboBox)((Object)this)){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ModuleDescription) {
                    return ((ModuleDescription)element).getName();
                }
                return "";
            }
        };
        this.setRenderer((ListCellRenderer)((Object)new ModuleDescriptionListCellRenderer()));
    }

    public void allowEmptySelection(@NotNull String emptySelectionText) {
        if (emptySelectionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptySelectionText", "com/intellij/application/options/ModuleDescriptionsComboBox", "allowEmptySelection"));
        }
        this.myAllowEmptySelection = true;
        this.myModel.add(null);
        this.setRenderer((ListCellRenderer)((Object)new ModuleDescriptionListCellRenderer(emptySelectionText)));
    }

    public void setModules(@NotNull Collection<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/application/options/ModuleDescriptionsComboBox", "setModules"));
        }
        this.myModel.clear();
        for (Module module2 : modules) {
            this.myModel.add((Object)new LoadedModuleDescriptionImpl(module2));
        }
        if (this.myAllowEmptySelection) {
            this.myModel.add(null);
        }
    }

    public void setAllModulesFromProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/application/options/ModuleDescriptionsComboBox", "setAllModulesFromProject"));
        }
        this.setModules(Arrays.asList(ModuleManager.getInstance((Project)project2).getModules()));
    }

    public void setSelectedModule(@Nullable Module module2) {
        this.myModel.setSelectedItem((Object)(module2 != null ? new LoadedModuleDescriptionImpl(module2) : null));
    }

    public void setSelectedModule(@NotNull Project project2, @NotNull String moduleName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/application/options/ModuleDescriptionsComboBox", "setSelectedModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/application/options/ModuleDescriptionsComboBox", "setSelectedModule"));
        }
        Module module2 = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
        if (module2 != null) {
            this.setSelectedModule(module2);
        } else {
            UnloadedModuleDescription description = ModuleManager.getInstance((Project)project2).getUnloadedModuleDescription(moduleName);
            if (description != null) {
                if (this.myModel.indexOf((Object)description) < 0) {
                    this.myModel.add((Object)description);
                }
                this.myModel.setSelectedItem((Object)description);
            } else {
                this.myModel.setSelectedItem(null);
            }
        }
    }

    @Nullable
    public Module getSelectedModule() {
        ModuleDescription selected = (ModuleDescription)this.myModel.getSelectedItem();
        if (selected instanceof LoadedModuleDescription) {
            return ((LoadedModuleDescription)selected).getModule();
        }
        return null;
    }

    @Nullable
    public String getSelectedModuleName() {
        ModuleDescription selected = (ModuleDescription)this.myModel.getSelectedItem();
        return selected != null ? selected.getName() : null;
    }

    private static class ModuleDescriptionListCellRenderer
    extends ListCellRendererWrapper<ModuleDescription> {
        private final String myEmptySelectionText;

        public ModuleDescriptionListCellRenderer() {
            this("[none]");
        }

        public ModuleDescriptionListCellRenderer(@NotNull String emptySelectionText) {
            if (emptySelectionText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptySelectionText", "com/intellij/application/options/ModuleDescriptionsComboBox$ModuleDescriptionListCellRenderer", "<init>"));
            }
            this.myEmptySelectionText = emptySelectionText;
        }

        public void customize(JList list2, ModuleDescription moduleDescription, int index, boolean selected, boolean hasFocus) {
            if (moduleDescription == null) {
                this.setText(this.myEmptySelectionText);
            } else {
                if (moduleDescription instanceof LoadedModuleDescription) {
                    this.setIcon(ModuleType.get((Module)((LoadedModuleDescription)moduleDescription).getModule()).getIcon());
                    this.setForeground(null);
                } else {
                    this.setIcon(AllIcons.Modules.UnloadedModule);
                    this.setForeground((Color)JBColor.RED);
                }
                this.setText(moduleDescription.getName());
            }
        }
    }
}

