/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleMainPanel
extends JPanel
implements TabbedLanguageCodeStylePanel.TabChangeListener {
    private final CardLayout myLayout = new CardLayout();
    private final JPanel mySettingsPanel = new JPanel(this.myLayout);
    private final Map<String, NewCodeStyleSettingsPanel> mySettingsPanels = new HashMap<String, NewCodeStyleSettingsPanel>();
    private Future<?> myAlarm = CompletableFuture.completedFuture(null);
    private final CodeStyleSchemesModel myModel;
    private final CodeStyleSettingsPanelFactory myFactory;
    private final CodeStyleSchemesPanel mySchemesPanel;
    private boolean myIsDisposed = false;
    private final Action mySetFromAction = new AbstractAction("Set from..."){

        @Override
        public void actionPerformed(ActionEvent event) {
            CodeStyleAbstractPanel selectedPanel = CodeStyleMainPanel.this.ensureCurrentPanel().getSelectedPanel();
            if (selectedPanel instanceof TabbedLanguageCodeStylePanel) {
                ((TabbedLanguageCodeStylePanel)selectedPanel).showSetFrom((Component)event.getSource());
            }
        }
    };
    @NonNls
    private static final String WAIT_CARD = "CodeStyleSchemesConfigurable.$$$.Wait.placeholder.$$$";
    private final PropertiesComponent myProperties;
    private static final String SELECTED_TAB = "settings.code.style.selected.tab";

    public CodeStyleMainPanel(CodeStyleSchemesModel model, CodeStyleSettingsPanelFactory factory, boolean schemesPanelEnabled) {
        super(new BorderLayout());
        this.myModel = model;
        this.myFactory = factory;
        this.mySchemesPanel = new CodeStyleSchemesPanel(model, this.createLinkComponent());
        this.myProperties = PropertiesComponent.getInstance();
        model.addListener(new CodeStyleSettingsListener(){

            @Override
            public void currentSchemeChanged(Object source) {
                if (source != CodeStyleMainPanel.this.mySchemesPanel) {
                    CodeStyleMainPanel.this.mySchemesPanel.onSelectedSchemeChanged();
                }
                CodeStyleMainPanel.this.onCurrentSchemeChanged();
            }

            @Override
            public void schemeListChanged() {
                CodeStyleMainPanel.this.mySchemesPanel.resetSchemesCombo();
            }

            @Override
            public void beforeCurrentSettingsChanged() {
                if (!CodeStyleMainPanel.this.myIsDisposed) {
                    CodeStyleMainPanel.this.ensureCurrentPanel().onSomethingChanged();
                }
            }

            @Override
            public void afterCurrentSettingsChanged() {
                CodeStyleMainPanel.this.mySchemesPanel.updateOnCurrentSettingsChange();
                DataContext context = DataManager.getInstance().getDataContext((Component)CodeStyleMainPanel.this.mySettingsPanel);
                Settings settings = (Settings)Settings.KEY.getData(context);
                if (settings != null) {
                    settings.revalidate();
                }
            }

            @Override
            public void schemeChanged(CodeStyleScheme scheme2) {
                CodeStyleMainPanel.this.ensurePanel(scheme2).reset(scheme2.getCodeStyleSettings());
            }

            @Override
            public void settingsChanged(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/CodeStyleMainPanel$2", "settingsChanged"));
                }
                CodeStyleMainPanel.this.ensureCurrentPanel().reset(settings);
            }
        });
        this.addWaitCard();
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        if (schemesPanelEnabled) {
            top.add(this.mySchemesPanel);
        }
        top.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)0, (int)10));
        this.add((Component)top, "North");
        this.add((Component)this.mySettingsPanel, "Center");
        this.mySchemesPanel.resetSchemesCombo();
        this.mySchemesPanel.onSelectedSchemeChanged();
        this.onCurrentSchemeChanged();
    }

    @NotNull
    private JComponent createLinkComponent() {
        JPanel linkPanel = new JPanel();
        SwingActionLink link = new SwingActionLink(this.mySetFromAction);
        link.setVerticalAlignment(3);
        linkPanel.setLayout(new BoxLayout(linkPanel, 1));
        linkPanel.add(Box.createVerticalGlue());
        linkPanel.add((Component)link);
        JPanel jPanel = linkPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleMainPanel", "createLinkComponent"));
        }
        return jPanel;
    }

    private void addWaitCard() {
        JPanel waitPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        label.setHorizontalAlignment(0);
        waitPanel.add((Component)label, "Center");
        label.setCursor(Cursor.getPredefinedCursor(3));
        waitPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.mySettingsPanel.add(WAIT_CARD, waitPanel);
    }

    public void onCurrentSchemeChanged() {
        this.myLayout.show(this.mySettingsPanel, WAIT_CARD);
        Runnable replaceLayout = () -> {
            if (!this.myIsDisposed) {
                this.ensureCurrentPanel().onSomethingChanged();
                String schemeName = this.myModel.getSelectedScheme().getName();
                this.updateSetFrom();
                this.myLayout.show(this.mySettingsPanel, schemeName);
            }
        };
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            replaceLayout.run();
        } else {
            this.myAlarm.cancel(false);
            this.myAlarm = EdtExecutorService.getScheduledExecutorInstance().schedule(replaceLayout, 200L, TimeUnit.MILLISECONDS);
        }
    }

    private void updateSetFrom() {
        this.mySetFromAction.setEnabled(this.ensureCurrentPanel().getSelectedPanel() instanceof TabbedLanguageCodeStylePanel);
    }

    public NewCodeStyleSettingsPanel[] getPanels() {
        Collection<NewCodeStyleSettingsPanel> panels = this.mySettingsPanels.values();
        return panels.toArray(new NewCodeStyleSettingsPanel[panels.size()]);
    }

    public boolean isModified() {
        NewCodeStyleSettingsPanel[] panels;
        for (NewCodeStyleSettingsPanel panel2 : panels = this.getPanels()) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.clearPanels();
        this.onCurrentSchemeChanged();
    }

    private void clearPanels() {
        for (NewCodeStyleSettingsPanel panel2 : this.mySettingsPanels.values()) {
            panel2.dispose();
        }
        this.mySettingsPanels.clear();
    }

    public void apply() throws ConfigurationException {
        for (NewCodeStyleSettingsPanel panel2 : this.getPanels()) {
            if (!panel2.isModified()) continue;
            panel2.apply();
        }
    }

    @NonNls
    @Nullable
    public String getHelpTopic() {
        NewCodeStyleSettingsPanel selectedPanel = this.ensureCurrentPanel();
        return selectedPanel != null ? selectedPanel.getHelpTopic() : "reference.settingsdialog.IDE.globalcodestyle";
    }

    private NewCodeStyleSettingsPanel ensureCurrentPanel() {
        return this.ensurePanel(this.myModel.getSelectedScheme());
    }

    private NewCodeStyleSettingsPanel ensurePanel(CodeStyleScheme scheme2) {
        String name2 = scheme2.getName();
        if (!this.mySettingsPanels.containsKey(name2)) {
            NewCodeStyleSettingsPanel panel2 = this.myFactory.createPanel(scheme2);
            panel2.reset(this.myModel.getCloneSettings(scheme2));
            panel2.setModel(this.myModel);
            CodeStyleAbstractPanel settingsPanel = panel2.getSelectedPanel();
            if (settingsPanel instanceof TabbedLanguageCodeStylePanel) {
                TabbedLanguageCodeStylePanel tabbedPanel = (TabbedLanguageCodeStylePanel)settingsPanel;
                tabbedPanel.setListener(this);
                String currentTab = this.myProperties.getValue(CodeStyleMainPanel.getSelectedTabPropertyName(tabbedPanel));
                if (currentTab != null) {
                    tabbedPanel.changeTab(currentTab);
                }
            }
            this.mySettingsPanels.put(name2, panel2);
            this.mySettingsPanel.add(scheme2.getName(), panel2);
        }
        return this.mySettingsPanels.get(name2);
    }

    public String getDisplayName() {
        return this.myModel.getSelectedScheme().getName();
    }

    public void disposeUIResources() {
        this.myAlarm.cancel(false);
        this.clearPanels();
        this.myIsDisposed = true;
    }

    public boolean isModified(CodeStyleScheme scheme2) {
        if (!this.mySettingsPanels.containsKey(scheme2.getName())) {
            return false;
        }
        return this.mySettingsPanels.get(scheme2.getName()).isModified();
    }

    public Set<String> processListOptions() {
        CodeStyleScheme defaultScheme = CodeStyleSchemes.getInstance().getDefaultScheme();
        NewCodeStyleSettingsPanel panel2 = this.ensurePanel(defaultScheme);
        return panel2.processListOptions();
    }

    @Override
    public void tabChanged(@NotNull TabbedLanguageCodeStylePanel source, @NotNull String tabTitle) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/application/options/codeStyle/CodeStyleMainPanel", "tabChanged"));
        }
        if (tabTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabTitle", "com/intellij/application/options/codeStyle/CodeStyleMainPanel", "tabChanged"));
        }
        this.myProperties.setValue(CodeStyleMainPanel.getSelectedTabPropertyName(source), tabTitle);
        for (NewCodeStyleSettingsPanel panel2 : this.getPanels()) {
            panel2.tabChanged(source, tabTitle);
        }
    }

    @NotNull
    private static String getSelectedTabPropertyName(@NotNull TabbedLanguageCodeStylePanel panel2) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/application/options/codeStyle/CodeStyleMainPanel", "getSelectedTabPropertyName"));
        }
        Language language = panel2.getDefaultLanguage();
        String string = language != null ? "settings.code.style.selected.tab." + language.getID() : SELECTED_TAB;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleMainPanel", "getSelectedTabPropertyName"));
        }
        return string;
    }
}

