/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model, int vGap) {
        super(vGap);
        this.myIsReset = false;
        this.myModel = model;
    }

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model, @NotNull JComponent linkComponent) {
        if (linkComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkComponent", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel", "<init>"));
        }
        super(8, linkComponent);
        this.myIsReset = false;
        this.myModel = model;
    }

    private void onCombo() {
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        if (selected != null) {
            this.myModel.selectScheme(selected, this);
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>();
            schemes.addAll(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    @Override
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        return new CodeStyleSchemesActions(this){

            @Override
            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme2) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            @Override
            protected void renameScheme(@NotNull CodeStyleScheme scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1", "renameScheme"));
                }
                if (newName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1", "renameScheme"));
                }
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName, false, scheme2);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme2);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel", "getModel"));
        }
        return codeStyleSchemesModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }
}

