/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchNodeComponentFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementAndMatchConditionComponent
extends JPanel
implements ArrangementUiComponent {
    @NotNull
    private final List<ArrangementUiComponent> myComponents;
    @NotNull
    private final Set<ArrangementSettingsToken> myAvailableTokens;
    @NotNull
    private final ArrangementCompositeMatchCondition mySetting;
    @Nullable
    private Rectangle myScreenBounds;
    @Nullable
    private ArrangementUiComponent myComponentUnderMouse;

    public ArrangementAndMatchConditionComponent(@NotNull StdArrangementMatchRule rule, @NotNull ArrangementCompositeMatchCondition setting, @NotNull ArrangementMatchNodeComponentFactory factory, @NotNull ArrangementStandardSettingsManager manager, boolean allowModification) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "<init>"));
        }
        if (setting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "<init>"));
        }
        this.myComponents = ContainerUtilRt.newArrayList();
        this.myAvailableTokens = ContainerUtilRt.newHashSet();
        this.mySetting = setting;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        final HashMap operands2 = ContainerUtilRt.newHashMap();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            public void visit(@NotNull ArrangementAtomMatchCondition condition2) {
                if (condition2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent$1", "visit"));
                }
                operands2.put(condition2.getType(), condition2);
            }

            public void visit(@NotNull ArrangementCompositeMatchCondition condition2) {
                if (condition2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent$1", "visit"));
                }
                assert (false);
            }
        };
        for (ArrangementMatchCondition operand2 : setting.getOperands()) {
            operand2.invite(visitor);
        }
        List ordered = manager.sort(operands2.keySet());
        GridBag constraints = new GridBag().anchor(13).insets(0, 0, 0, 5);
        for (ArrangementSettingsToken key2 : ordered) {
            ArrangementMatchCondition operand3 = (ArrangementMatchCondition)operands2.get(key2);
            assert (operand3 != null);
            ArrangementUiComponent component = factory.getComponent(operand3, rule, allowModification);
            this.myComponents.add(component);
            this.myAvailableTokens.addAll(component.getAvailableTokens());
            JComponent uiComponent = component.getUiComponent();
            this.add((Component)uiComponent, constraints);
        }
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        ArrangementCompositeMatchCondition arrangementCompositeMatchCondition = this.mySetting;
        if (arrangementCompositeMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "getMatchCondition"));
        }
        return arrangementCompositeMatchCondition;
    }

    public void setData(@NotNull Object data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "setData"));
        }
    }

    @NotNull
    public JComponent getUiComponent() {
        ArrangementAndMatchConditionComponent arrangementAndMatchConditionComponent = this;
        if (arrangementAndMatchConditionComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "getUiComponent"));
        }
        return arrangementAndMatchConditionComponent;
    }

    @Nullable
    public Rectangle getScreenBounds() {
        return this.myScreenBounds;
    }

    public void setSelected(boolean selected) {
        for (ArrangementUiComponent component : this.myComponents) {
            component.setSelected(selected);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        Point point = UIUtil.getLocationOnScreen((JComponent)this);
        if (point != null) {
            Rectangle bounds = this.getBounds();
            this.myScreenBounds = new Rectangle(point.x, point.y, bounds.width, bounds.height);
        }
        super.paint(g);
    }

    public Rectangle onMouseMove(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "onMouseMove"));
        }
        Point location = event.getLocationOnScreen();
        for (ArrangementUiComponent component : this.myComponents) {
            Rectangle bounds = component.getScreenBounds();
            if (bounds == null || !bounds.contains(location)) continue;
            if (this.myComponentUnderMouse == null) {
                this.myComponentUnderMouse = component;
                Rectangle rectangleOnEnter = this.myComponentUnderMouse.onMouseEntered(event);
                Rectangle rectangleOnMove = this.myComponentUnderMouse.onMouseMove(event);
                if (rectangleOnEnter != null && rectangleOnMove != null) {
                    return this.myScreenBounds;
                }
                if (rectangleOnEnter != null) {
                    return rectangleOnEnter;
                }
                return rectangleOnMove;
            }
            if (this.myComponentUnderMouse != component) {
                this.myComponentUnderMouse.onMouseExited();
                this.myComponentUnderMouse = component;
                component.onMouseEntered(event);
                return this.myScreenBounds;
            }
            return component.onMouseMove(event);
        }
        if (this.myComponentUnderMouse == null) {
            return null;
        }
        Rectangle result2 = this.myComponentUnderMouse.onMouseExited();
        this.myComponentUnderMouse = null;
        return result2;
    }

    public void onMouseRelease(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "onMouseRelease"));
        }
        Point location = event.getLocationOnScreen();
        for (ArrangementUiComponent component : this.myComponents) {
            Rectangle bounds = component.getScreenBounds();
            if (bounds == null || !bounds.contains(location)) continue;
            component.onMouseRelease(event);
            return;
        }
    }

    public Rectangle onMouseEntered(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "onMouseEntered"));
        }
        Point location = event.getLocationOnScreen();
        for (ArrangementUiComponent component : this.myComponents) {
            Rectangle bounds = component.getScreenBounds();
            if (bounds == null || !bounds.contains(location)) continue;
            this.myComponentUnderMouse = component;
            return component.onMouseEntered(event);
        }
        return null;
    }

    @Nullable
    public Rectangle onMouseExited() {
        if (this.myComponentUnderMouse != null) {
            Rectangle result2 = this.myComponentUnderMouse.onMouseExited();
            this.myComponentUnderMouse = null;
            return result2;
        }
        return null;
    }

    @Nullable
    public ArrangementSettingsToken getToken() {
        return this.myComponentUnderMouse == null ? null : this.myComponentUnderMouse.getToken();
    }

    @NotNull
    public Set<ArrangementSettingsToken> getAvailableTokens() {
        Set<ArrangementSettingsToken> set2 = this.myAvailableTokens;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "getAvailableTokens"));
        }
        return set2;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws IllegalArgumentException, UnsupportedOperationException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "chooseToken"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSelected() {
        return this.myComponentUnderMouse != null && this.myComponentUnderMouse.isSelected();
    }

    public void reset() {
        for (ArrangementUiComponent component : this.myComponents) {
            component.reset();
        }
    }

    public int getBaselineToUse(int width, int height) {
        return -1;
    }

    public void setListener(@NotNull ArrangementUiComponent.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAndMatchConditionComponent", "setListener"));
        }
        for (ArrangementUiComponent component : this.myComponents) {
            component.setListener(listener2);
        }
    }

    public void handleMouseClickOnSelected() {
        for (ArrangementUiComponent component : this.myComponents) {
            component.handleMouseClickOnSelected();
        }
    }

    public boolean alwaysCanBeActive() {
        return false;
    }

    @Override
    public String toString() {
        return String.format("(%s)", StringUtil.join(this.myComponents, (String)" and "));
    }
}

