/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.component.AbstractArrangementUiComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Alarm;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ArrangementTextFieldUiComponent
extends AbstractArrangementUiComponent {
    @NotNull
    private final JBTextField myTextField;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final ArrangementSettingsToken myToken;

    public ArrangementTextFieldUiComponent(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent", "<init>"));
        }
        super(token);
        this.myTextField = new JBTextField(20);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myToken = token;
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }
        });
    }

    private void scheduleUpdate() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.fireStateChanged(), 1000);
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        ArrangementSettingsToken arrangementSettingsToken = this.myToken;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent", "getToken"));
        }
        return arrangementSettingsToken;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws IllegalArgumentException, UnsupportedOperationException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent", "chooseToken"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        String text2 = this.myTextField.getText();
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = new ArrangementAtomMatchCondition(this.myToken, (Object)(StringUtil.isEmpty((String)text2) ? "" : text2.trim()));
        if (arrangementAtomMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent", "getMatchCondition"));
        }
        return arrangementAtomMatchCondition;
    }

    @Override
    protected JComponent doGetUiComponent() {
        return this.myTextField;
    }

    public boolean isSelected() {
        return !StringUtil.isEmpty((String)this.myTextField.getText());
    }

    public void setSelected(boolean selected) {
    }

    @Override
    public boolean isEnabled() {
        return this.myTextField.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTextField.setEnabled(enabled);
    }

    @Override
    public void setData(@NotNull Object data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent", "setData"));
        }
        if (data instanceof String) {
            this.myTextField.setText(data.toString());
        }
    }

    @Override
    public void doReset() {
        this.myTextField.setText("");
    }

    public int getBaselineToUse(int width, int height) {
        return this.myTextField.getBaseline(width, height);
    }

    public void handleMouseClickOnSelected() {
        this.setSelected(false);
    }
}

